/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.webserver.utils;

import android.net.Uri;
import com.xshare.base.BaseApplication;
import com.yanzhenjie.andserver.bean.ProgressBean;
import com.yanzhenjie.andserver.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/xshare/webserver/utils/FileOperationUtils;", "", "()V", "writeFileToDisk", "", "responseBody", "Lokhttp3/ResponseBody;", "saveFilePath", "", "fileUrl", "currentDownloadSize", "", "app_release"})
public final class FileOperationUtils {
    @NotNull
    public static final FileOperationUtils INSTANCE = new FileOperationUtils();

    private FileOperationUtils() {
    }

    public final void writeFileToDisk(@NotNull ResponseBody responseBody, @NotNull String saveFilePath, @NotNull String fileUrl, long currentDownloadSize) {
        Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
        Intrinsics.checkNotNullParameter((Object)saveFilePath, (String)"saveFilePath");
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        long totalByte = responseBody.contentLength() + currentDownloadSize;
        long downloadByte = currentDownloadSize;
        File file = new File(saveFilePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        BufferedInputStream inbuff = null;
        BufferedOutputStream bos = null;
        OutputStream os = BaseApplication.Companion.getContext().getContentResolver().openOutputStream(Uri.fromFile((File)file), "wa");
        byte[] buffer = new byte[16384];
        inbuff = new BufferedInputStream(responseBody.byteStream(), buffer.length);
        bos = new BufferedOutputStream(os, buffer.length);
        ProgressBean progressBean = new ProgressBean();
        progressBean.setPath(fileUrl);
        progressBean.setSavePath(saveFilePath);
        progressBean.setTotalSize(totalByte);
        while (true) {
            int len;
            if ((len = inbuff.read(buffer)) == -1) {
                if (progressBean.getProgress() == 100) break;
                progressBean.setProgress(100);
                progressBean.setCurrentTotalBytes(totalByte);
                IOUtils.progress.postValue((Object)progressBean);
                break;
            }
            bos.write(buffer, 0, len);
            progressBean.setCurrentTotalBytes(downloadByte += (long)len);
            int pg = (int)(downloadByte * (long)100 / totalByte);
            progressBean.setProgress(pg);
            IOUtils.progress.postValue((Object)progressBean);
        }
        bos.flush();
        bos.close();
        inbuff.close();
    }

    public static /* synthetic */ void writeFileToDisk$default(FileOperationUtils fileOperationUtils, ResponseBody responseBody, String string2, String string3, long l, int n, Object object) {
        if ((n & 8) != 0) {
            l = 0L;
        }
        fileOperationUtils.writeFileToDisk(responseBody, string2, string3, l);
    }
}

