/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.webserver.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import com.xshare.base.BaseApplication;
import com.xshare.base.util.DLog;
import com.xshare.business.utils.LogUtils;
import com.xshare.business.utils.MD5Utils;
import com.xshare.webserver.bean.FileInfoBean;
import com.xshare.webserver.utils.BitmapUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ;\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/xshare/webserver/utils/FileUtils;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getChooseFileResultPath", "", "uri", "Landroid/net/Uri;", "getDataColumn", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getPath", "getRealPathFromURI", "contentUri", "isDownloadsDocument", "", "isExternalStorageDocument", "isMediaDocument", "Companion", "app_release"})
public final class FileUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private static final String TAG = "FileUtils";
    @Nullable
    private static FileUtils util;
    @Nullable
    private static Method sGetMimeTypeMethod;
    @Nullable
    private static Class<?> sMediaFileClazz;

    private FileUtils(Context context) {
        this.context = context;
    }

    @Nullable
    public final String getChooseFileResultPath(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String chooseFilePath = null;
        if (StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true)) {
            chooseFilePath = uri.getPath();
            Toast.makeText((Context)this.context, (CharSequence)chooseFilePath, (int)0).show();
            return chooseFilePath;
        }
        chooseFilePath = Build.VERSION.SDK_INT > 19 ? this.getPath(this.context, uri) : this.getRealPathFromURI(uri);
        return chooseFilePath;
    }

    private final String getRealPathFromURI(Uri contentUri) {
        String res = null;
        String[] stringArray = new String[]{"_data"};
        String[] proj = stringArray;
        Cursor cursor = this.context.getContentResolver().query(contentUri, proj, null, null, null);
        if (cursor != null && cursor.moveToFirst()) {
            int column_index = cursor.getColumnIndexOrThrow("_data");
            res = cursor.getString(column_index);
            cursor.close();
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"NewApi"})
    private final String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (this.isExternalStorageDocument(uri)) {
                void $this$toTypedArray$iv;
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                Object object = docId;
                Regex regex = new Regex(":");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                String[] split = stringArray;
                String type = split[0];
                if (StringsKt.equals((String)"primary", (String)type, (boolean)true)) {
                    return Environment.getExternalStorageDirectory().toString() + '/' + split[1];
                }
            } else {
                if (this.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
                    Long $i$f$toTypedArray = Long.valueOf(id2);
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$toTypedArray, (String)"valueOf(id)");
                    Uri type = ContentUris.withAppendedId((Uri)uri2, (long)((Number)$i$f$toTypedArray).longValue());
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"withAppendedId(Uri.parse\u2026va.lang.Long.valueOf(id))");
                    Uri contentUri = type;
                    return this.getDataColumn(context, contentUri, null, null);
                }
                if (this.isMediaDocument(uri)) {
                    void $this$toTypedArray$iv;
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                    Object type = docId;
                    Regex $i$f$toTypedArray = new Regex(":");
                    int thisCollection$iv = 0;
                    type = $i$f$toTypedArray.split((CharSequence)type, thisCollection$iv);
                    boolean $i$f$toTypedArray2 = false;
                    void thisCollection$iv2 = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv2.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    String[] split = stringArray;
                    type = split[0];
                    Uri contentUri = null;
                    if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if (Intrinsics.areEqual((Object)"audio", (Object)type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] stringArray2 = new String[]{split[1]};
                    String[] selectionArgs = stringArray2;
                    return this.getDataColumn(context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if (StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true)) {
                return this.getDataColumn(context, uri, null, null);
            }
            if (StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true)) {
                uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor;
        block4: {
            Cursor cursor2;
            String string2;
            cursor = null;
            String column = "_data";
            String[] stringArray = new String[]{column};
            String[] projection = stringArray;
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri2 = uri;
                Intrinsics.checkNotNull((Object)uri2);
                cursor = contentResolver.query(uri2, projection, selection, selectionArgs, null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                int column_index = cursor.getColumnIndexOrThrow(column);
                string2 = cursor.getString(column_index);
                cursor2 = cursor;
            }
            catch (Throwable throwable) {
                Cursor cursor3 = cursor;
                if (cursor3 != null) {
                    cursor3.close();
                }
                throw throwable;
            }
            cursor2.close();
            return string2;
        }
        Cursor cursor4 = cursor;
        if (cursor4 != null) {
            cursor4.close();
        }
        return null;
    }

    private final boolean isExternalStorageDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    private final boolean isDownloadsDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    private final boolean isMediaDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    public /* synthetic */ FileUtils(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u0012\u0010!\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u001c\u0010\"\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u0015J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000eJ\u000e\u0010'\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/xshare/webserver/utils/FileUtils$Companion;", "", "()V", "TAG", "", "sGetMimeTypeMethod", "Ljava/lang/reflect/Method;", "sMediaFileClazz", "Ljava/lang/Class;", "util", "Lcom/xshare/webserver/utils/FileUtils;", "checkDirectory", "", "directory", "Ljava/io/File;", "createDirectory", "", "path", "filesOfDirectory", "Ljava/util/ArrayList;", "getAppInfo", "Lcom/xshare/webserver/bean/FileInfoBean;", "packageName", "pm", "Landroid/content/pm/PackageManager;", "getDirectoryName", "directoryPath", "getFileExtension", "fileName", "getInstance", "context", "Landroid/content/Context;", "getMimeType", "getMimeTypeMethod", "getSaveFilePath", "fileInfoBean", "sizeOf", "", "file", "sizeOfDirectory", "app_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final FileUtils getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (util == null) {
                util = new FileUtils(context, null);
            }
            return util;
        }

        public final void createDirectory(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (TextUtils.isEmpty((CharSequence)path)) {
                return;
            }
            try {
                File f = new File(path);
                if (!f.exists()) {
                    f.mkdirs();
                }
            }
            catch (Exception e) {
                Log.d((String)FileUtils.TAG, (String)Intrinsics.stringPlus((String)" createDirectory fail path=", (Object)path));
            }
        }

        public final long sizeOfDirectory(@NotNull File directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            long size = 0L;
            if (this.checkDirectory(directory)) {
                File[] fileArray = directory.listFiles();
                if (fileArray == null) {
                    return 0L;
                }
                for (File file : fileArray) {
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    if ((size += this.sizeOf(file)) >= 0L) continue;
                    break;
                }
            }
            return size;
        }

        private final boolean checkDirectory(File directory) {
            if (directory == null) {
                return false;
            }
            if (!directory.exists()) {
                return false;
            }
            return directory.isDirectory();
        }

        public final long sizeOf(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!file.exists()) {
                String message = file + " does not exist";
                Log.e((String)FileUtils.TAG, (String)message);
                return 0L;
            }
            return file.isDirectory() ? this.sizeOfDirectory(file) : file.length();
        }

        @Nullable
        public final ArrayList<File> filesOfDirectory(@NotNull File directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            ArrayList<File> fileList = new ArrayList<File>();
            if (this.checkDirectory(directory)) {
                File[] fileArray = directory.listFiles();
                if (fileArray == null) {
                    return null;
                }
                for (File file : fileArray) {
                    if (file.isDirectory()) {
                        ArrayList<File> fileArrayList;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                        ArrayList<File> arrayList = fileArrayList = this.filesOfDirectory(file);
                        Intrinsics.checkNotNull(arrayList);
                        if (arrayList.size() <= 0) continue;
                        fileList.addAll((Collection<File>)fileArrayList);
                        continue;
                    }
                    fileList.add(file);
                }
            }
            return fileList;
        }

        @NotNull
        public final String getDirectoryName(@NotNull String directoryPath) {
            Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
            if (TextUtils.isEmpty((CharSequence)directoryPath)) {
                return "";
            }
            CharSequence charSequence = directoryPath;
            Regex regex = new Regex("/");
            int n = 0;
            Collection $this$toTypedArray$iv = regex.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] split = stringArray;
            if (split.length == 0) {
                return "";
            }
            String name = split[split.length - 1];
            return TextUtils.isEmpty((CharSequence)name) ? split[split.length - 2] : name;
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final String getSaveFilePath(@Nullable String directory, @Nullable FileInfoBean fileInfoBean) {
            if (fileInfoBean == null) {
                return null;
            }
            file = new File(directory);
            file.mkdirs();
            parentPath = null;
            type = this.getMimeType(fileInfoBean.getFileName());
            v0 = fileInfoBean.getFileName();
            if (v0 == null ? false : StringsKt.endsWith$default((String)v0, (String)".apks", (boolean)false, (int)2, null) == true) ** GOTO lbl-1000
            v1 = fileInfoBean.getFileName();
            if (v1 == null ? false : StringsKt.endsWith$default((String)v1, (String)".apk", (boolean)false, (int)2, null) == true) lbl-1000:
            // 2 sources

            {
                v2 = "apps";
            } else {
                v3 = type;
                if (v3 == null ? false : StringsKt.startsWith$default((String)v3, (String)"video", (boolean)false, (int)2, null) == true) {
                    v2 = "videos";
                } else {
                    v4 = type;
                    if (v4 == null ? false : StringsKt.startsWith$default((String)v4, (String)"audio", (boolean)false, (int)2, null) == true) {
                        v2 = "audios";
                    } else {
                        v5 = type;
                        v2 = (v5 == null ? false : StringsKt.startsWith$default((String)v5, (String)"image", (boolean)false, (int)2, null) == true) != false ? "images" : "files";
                    }
                }
            }
            parentPath = v2;
            DLog.INSTANCE.d("XSLOG", "getSaveFilePath savePath:" + file.getAbsolutePath() + ", parentPath:" + parentPath);
            parentFile = new File(file.getAbsolutePath() + File.separator + parentPath);
            parentFile.mkdirs();
            oldName = fileInfoBean.getFileName();
            saveName = null;
            saveName = fileInfoBean.getFileName();
            DLog.INSTANCE.d("XSLOG", "getSaveFilePath parentFile:" + parentFile + "  saveName:" + saveName);
            v6 = parentFile.list();
            if (v6 != null) {
                $this$forEachIndexed$iv = v6;
                $i$f$forEachIndexed = false;
                index$iv = 0;
                for (String item$iv : $this$forEachIndexed$iv) {
                    v7 = index$iv++;
                    var15_15 = item$iv;
                    i = v7;
                    $i$a$-forEachIndexed-FileUtils$Companion$getSaveFilePath$1 = false;
                    v8 = oldName;
                    v9 = index = v8 == null ? null : Integer.valueOf(StringsKt.lastIndexOf$default((CharSequence)v8, (String)".", (int)0, (boolean)false, (int)6, null));
                    if (index == null) continue;
                    if (index > -1) {
                        v10 = new StringBuilder();
                        var18_18 = oldName;
                        var20_20 = 0;
                        var21_21 = index;
                        v11 = var18_18.substring(var20_20, var21_21);
                        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        v12 = v10.append(v11).append('(').append(i).append(')');
                        var18_18 = oldName;
                        var20_20 = StringsKt.lastIndexOf$default((CharSequence)oldName, (String)".", (int)0, (boolean)false, (int)6, null);
                        v13 = var18_18.substring(var20_20);
                        Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"this as java.lang.String).substring(startIndex)");
                        v14 = v12.append(v13).toString();
                    } else {
                        v14 = String.valueOf(oldName);
                    }
                    saveName = v14;
                }
            }
            return parentFile.getAbsolutePath() + File.separator + saveName;
        }

        @Nullable
        public final String getMimeType(@Nullable String fileName) {
            if (fileName == null || TextUtils.isEmpty((CharSequence)fileName)) {
                return null;
            }
            if (StringsKt.endsWith$default((String)fileName, (String)".ogg", (boolean)false, (int)2, null)) {
                return "audio/ogg";
            }
            if (StringsKt.endsWith$default((String)fileName, (String)".ape", (boolean)false, (int)2, null)) {
                return "audio/x-ape";
            }
            String type = null;
            String extension = this.getFileExtension(fileName);
            if (extension != null) {
                type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
            }
            if (type == null && !TextUtils.isEmpty((CharSequence)fileName)) {
                type = this.getMimeTypeMethod(fileName);
            }
            if (type == null && !TextUtils.isEmpty((CharSequence)fileName)) {
                if (StringsKt.endsWith$default((String)fileName, (String)"png", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"bmp", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"tif", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"svg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"jpg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"jpeg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"webp", (boolean)false, (int)2, null)) {
                    type = "image/*";
                } else if (StringsKt.endsWith$default((String)fileName, (String)"mp4", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"rmvb", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"wmv", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"avi", (boolean)false, (int)2, null)) {
                    type = "video/*";
                } else if (StringsKt.endsWith$default((String)fileName, (String)"mp3", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"flac", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"wma", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"wav", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"midi", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"m4a", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"amr", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"ogg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"aac", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)"wave", (boolean)false, (int)2, null)) {
                    type = "audio/*";
                }
            }
            return type;
        }

        @SuppressLint(value={"DefaultLocale"})
        @Nullable
        public final String getFileExtension(@Nullable String fileName) {
            if (fileName == null) {
                return null;
            }
            String extension = null;
            int lastDot = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (lastDot >= 0) {
                String string2 = fileName.substring(lastDot + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                extension = string3;
            }
            return extension;
        }

        @Nullable
        public final String getMimeTypeMethod(@Nullable String fileName) {
            String mimeType = null;
            try {
                Object object;
                Object[] objectArray;
                if (sMediaFileClazz == null) {
                    sMediaFileClazz = Class.forName("android.media.MediaFile");
                }
                if (sGetMimeTypeMethod == null) {
                    Method method;
                    Class clazz = sMediaFileClazz;
                    if (clazz == null) {
                        method = null;
                    } else {
                        objectArray = new Class[]{String.class};
                        method = clazz.getMethod("getMimeTypeForFile", (Class<?>[])objectArray);
                    }
                    sGetMimeTypeMethod = method;
                }
                Method method = sGetMimeTypeMethod;
                if (method == null) {
                    object = null;
                } else {
                    objectArray = new Object[]{fileName};
                    object = method.invoke((Object)sMediaFileClazz, objectArray);
                }
                mimeType = (String)object;
            }
            catch (Exception e) {
                e.printStackTrace();
                DLog.INSTANCE.d("XSLOG", Intrinsics.stringPlus((String)"getMimeTypeMethod:   e :", (Object)e));
            }
            return mimeType;
        }

        @Nullable
        public final FileInfoBean getAppInfo(@Nullable String packageName, @NotNull PackageManager pm) {
            Intrinsics.checkNotNullParameter((Object)pm, (String)"pm");
            PackageInfo packageInfo = null;
            FileInfoBean appInfo = new FileInfoBean();
            ApplicationInfo app = null;
            try {
                ApplicationInfo applicationInfo;
                ApplicationInfo e2;
                appInfo.setPackageName(packageName);
                appInfo.setApp(true);
                try {
                    String string2 = packageName;
                    Intrinsics.checkNotNull((Object)string2);
                    packageInfo = pm.getPackageInfo(string2, 0);
                    long appVersionCode = Build.VERSION.SDK_INT >= 28 ? packageInfo.getLongVersionCode() : (long)packageInfo.versionCode;
                    appInfo.setAppVersionCode(appVersionCode);
                    appInfo.setAppVersionName(packageInfo.versionName);
                }
                catch (Exception e2) {
                    LogUtils.d(FileUtils.TAG, Intrinsics.stringPlus((String)"Read PackageInfo Error:", (Object)e2.getMessage()));
                }
                if (packageInfo != null) {
                    e2 = packageInfo.applicationInfo;
                    Intrinsics.checkNotNullExpressionValue((Object)e2, (String)"{\n                    pa\u2026ionInfo\n                }");
                    applicationInfo = e2;
                } else {
                    String string3 = packageName;
                    Intrinsics.checkNotNull((Object)string3);
                    e2 = pm.getApplicationInfo(string3, 0);
                    Intrinsics.checkNotNullExpressionValue((Object)e2, (String)"{\n                    pm\u2026e!!, 0)\n                }");
                    applicationInfo = e2;
                }
                app = applicationInfo;
                try {
                    appInfo.setAppName(((Object)app.loadLabel(pm)).toString());
                    appInfo.setFileName(appInfo.getAppName());
                    appInfo.setFilePath(app.sourceDir);
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                appInfo.setApkIconPath(BitmapUtil.saveBitmap((Context)BaseApplication.Companion.getBaseApplication(), MD5Utils.getMD5String(packageName), app.loadIcon(pm)));
                long baseSize = new File(appInfo.getFilePath()).length();
                LogUtils.d(FileUtils.TAG, "appInfo.getFilePath() = " + appInfo.getFilePath() + " , app.publicSourceDir = " + app.publicSourceDir);
                if (app.splitPublicSourceDirs != null && app.splitPublicSourceDirs.length > 0) {
                    appInfo.setAppBundleModule(true);
                    appInfo.setFolder(true);
                    ArrayList<FileInfoBean> fileList = new ArrayList<FileInfoBean>();
                    String[] stringArray = app.splitPublicSourceDirs;
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"app.splitPublicSourceDirs");
                    String[] stringArray2 = stringArray;
                    int n = 0;
                    int n2 = stringArray2.length;
                    while (n < n2) {
                        String splitPath = stringArray2[n];
                        ++n;
                        long fileSize = new File(splitPath).length();
                        FileInfoBean childFileInfo = new FileInfoBean();
                        childFileInfo.setFolder(false);
                        childFileInfo.setServer(true);
                        Intrinsics.checkNotNullExpressionValue((Object)splitPath, (String)"splitPath");
                        String string4 = splitPath.substring(StringsKt.lastIndexOf$default((CharSequence)splitPath, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                        childFileInfo.setFileName(string4);
                        childFileInfo.setFilePath(splitPath);
                        childFileInfo.setSize(fileSize);
                        fileList.add(childFileInfo);
                        baseSize += fileSize;
                    }
                    FileInfoBean childFileInfo = new FileInfoBean();
                    childFileInfo.setFolder(false);
                    childFileInfo.setServer(true);
                    String string5 = app.publicSourceDir;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"app.publicSourceDir");
                    String string6 = app.publicSourceDir;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"app.publicSourceDir");
                    String string7 = string5.substring(StringsKt.lastIndexOf$default((CharSequence)string6, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                    childFileInfo.setFileName(string7);
                    childFileInfo.setFilePath(app.publicSourceDir);
                    childFileInfo.setSize(new File(app.publicSourceDir).length());
                    fileList.add(childFileInfo);
                    appInfo.setChildFiles((List<FileInfoBean>)fileList);
                } else {
                    appInfo.setAppBundleModule(false);
                }
                appInfo.setSize(baseSize);
                appInfo.setSystem((app.flags & 1) == 1);
            }
            catch (Exception e) {
                LogUtils.d(FileUtils.TAG, Intrinsics.stringPlus((String)"LoadAppAsyncTask->doInBackground Exception:", (Object)e.getMessage()));
            }
            return appInfo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

