/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.wifi;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import com.xshare.base.BaseApplication;
import com.xshare.business.bean.wifi.WifiInfoModel;
import com.xshare.wifi.WifiCreateManager;
import com.xshare.wifi.adapter.ApWifiAdapter;
import com.xshare.wifi.adapter.LocalHostWifiAdapter;
import com.xshare.wifi.adapter.P2pWifiAdapter;
import com.xshare.wifi.adapter.WifiCreateAdapter;
import com.xshare.wifi.log.WifiLog;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.DelicateCoroutinesApi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0006H\u0002J\u0006\u0010\u0019\u001a\u00020\u0006J6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001b0\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u001fJ\u0006\u0010!\u001a\u00020\u001bJ\b\u0010\"\u001a\u00020\u000eH\u0002J\b\u0010#\u001a\u00020\u000eH\u0002J\u0006\u0010$\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/xshare/wifi/WifiCreateManager;", "", "()V", "TAG", "", "isDeviceSupport5G", "", "()Z", "setDeviceSupport5G", "(Z)V", "isInit", "selectWifiType", "", "wifiAdapter", "Lcom/xshare/wifi/adapter/WifiCreateAdapter;", "wifiManager", "Landroid/net/wifi/WifiManager;", "getWifiManager", "()Landroid/net/wifi/WifiManager;", "wifiManager$delegate", "Lkotlin/Lazy;", "checkCanWriteSetting", "context", "Landroid/content/Context;", "checkDeviceIs5GHzBandSupported", "checkP2pSupported", "createWifi", "", "wifiInfoModel", "Lcom/xshare/business/bean/wifi/WifiInfoModel;", "successFun", "Lkotlin/Function1;", "errorFun", "init", "initWifiAdapter", "initWifiAdapterWithAndroidVersion", "releaseWifi", "app_release"})
@DelicateCoroutinesApi
public final class WifiCreateManager {
    @NotNull
    public static final WifiCreateManager INSTANCE = new WifiCreateManager();
    @NotNull
    public static final String TAG = "WifiCreateManager";
    private static int selectWifiType;
    private static boolean isInit;
    private static boolean isDeviceSupport5G;
    private static WifiCreateAdapter wifiAdapter;
    @NotNull
    private static final Lazy wifiManager$delegate;

    private WifiCreateManager() {
    }

    public final boolean isDeviceSupport5G() {
        return isDeviceSupport5G;
    }

    public final void setDeviceSupport5G(boolean bl) {
        isDeviceSupport5G = bl;
    }

    private final WifiManager getWifiManager() {
        Lazy lazy = wifiManager$delegate;
        return (WifiManager)lazy.getValue();
    }

    public final void init() {
        if (!isInit) {
            isInit = true;
            isDeviceSupport5G = this.checkDeviceIs5GHzBandSupported();
        } else {
            WifiLog.INSTANCE.d(TAG, "WifiCreateManager has init, do nothing");
        }
    }

    public final void createWifi(@NotNull WifiInfoModel wifiInfoModel, @NotNull Function1<? super WifiInfoModel, Unit> successFun2, @NotNull Function1<? super Integer, Unit> errorFun2) {
        Intrinsics.checkNotNullParameter((Object)wifiInfoModel, (String)"wifiInfoModel");
        Intrinsics.checkNotNullParameter(successFun2, (String)"successFun");
        Intrinsics.checkNotNullParameter(errorFun2, (String)"errorFun");
        wifiAdapter = this.initWifiAdapter();
        WifiCreateAdapter wifiCreateAdapter = wifiAdapter;
        if (wifiCreateAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiAdapter");
            wifiCreateAdapter = null;
        }
        wifiCreateAdapter.startCreateWifi(wifiInfoModel, successFun2, errorFun2);
    }

    private final WifiCreateAdapter initWifiAdapter() {
        WifiCreateAdapter wifiCreateAdapter;
        switch (selectWifiType) {
            case 1: {
                wifiCreateAdapter = new P2pWifiAdapter();
                break;
            }
            case 2: {
                wifiCreateAdapter = new ApWifiAdapter();
                break;
            }
            case 3: {
                wifiCreateAdapter = new LocalHostWifiAdapter();
                break;
            }
            default: {
                wifiCreateAdapter = this.initWifiAdapterWithAndroidVersion();
            }
        }
        return wifiCreateAdapter;
    }

    private final WifiCreateAdapter initWifiAdapterWithAndroidVersion() {
        return Build.VERSION.SDK_INT >= 26 ? (WifiCreateAdapter)new P2pWifiAdapter() : (this.checkCanWriteSetting(BaseApplication.Companion.getCONTEXT()) ? (WifiCreateAdapter)new ApWifiAdapter() : (WifiCreateAdapter)new LocalHostWifiAdapter());
    }

    public final void releaseWifi() {
        try {
            WifiCreateAdapter wifiCreateAdapter = wifiAdapter;
            if (wifiCreateAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"wifiAdapter");
                wifiCreateAdapter = null;
            }
            wifiCreateAdapter.releaseWifi();
        }
        catch (Exception e) {
            WifiLog.INSTANCE.d("releaseWifi", Intrinsics.stringPlus((String)"Exception = ", (Object)e.getMessage()));
        }
    }

    private final boolean checkDeviceIs5GHzBandSupported() {
        return this.getWifiManager().is5GHzBandSupported();
    }

    public final boolean checkP2pSupported() {
        return this.getWifiManager().isP2pSupported();
    }

    private final boolean checkCanWriteSetting(Context context) {
        return context == null ? false : Build.VERSION.SDK_INT < 23 || Settings.System.canWrite((Context)context);
    }

    static {
        wifiManager$delegate = LazyKt.lazy((Function0)wifiManager.2.INSTANCE);
    }
}

