/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.wifi.bluetooth;

import com.xshare.business.utils.LogUtils;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;

class BleCMD {
    public LinkedBlockingQueue<byte[]> getWifiInfoCmdQue(String wifiInfo) {
        LinkedBlockingQueue<byte[]> wifiQueue = new LinkedBlockingQueue<byte[]>();
        try {
            int defaultLength;
            byte[] sendByte = wifiInfo.getBytes();
            byte[] pactHead = new byte[]{3};
            for (int sendLength = 0; sendLength < sendByte.length; sendLength += defaultLength) {
                int gap = sendByte.length - sendLength;
                defaultLength = gap <= 19 ? gap : 19;
                byte[] originData = Arrays.copyOfRange(sendByte, sendLength, sendLength + defaultLength);
                byte[] pactData = new byte[pactHead.length + originData.length];
                System.arraycopy(pactHead, 0, pactData, 0, pactHead.length);
                System.arraycopy(originData, 0, pactData, pactHead.length, originData.length);
                wifiQueue.put(pactData);
            }
            wifiQueue.add(new byte[]{2});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wifiQueue;
    }

    public LinkedBlockingQueue<byte[]> getDisconnectCmdQue(String wifiInfo) {
        LinkedBlockingQueue<byte[]> wifiQueue = new LinkedBlockingQueue<byte[]>();
        try {
            int defaultLength;
            byte[] sendByte = wifiInfo.getBytes();
            byte[] pactHead = new byte[]{5};
            for (int sendLength = 0; sendLength < sendByte.length; sendLength += defaultLength) {
                int gap = sendByte.length - sendLength;
                defaultLength = gap <= 19 ? gap : 19;
                byte[] originData = Arrays.copyOfRange(sendByte, sendLength, sendLength + defaultLength);
                byte[] pactData = new byte[pactHead.length + originData.length];
                System.arraycopy(pactHead, 0, pactData, 0, pactHead.length);
                System.arraycopy(originData, 0, pactData, pactHead.length, originData.length);
                wifiQueue.put(pactData);
            }
            wifiQueue.add(new byte[]{6});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wifiQueue;
    }

    public String covertWifiInfoQueueToString(LinkedBlockingQueue<byte[]> wifiQueue) {
        String mWifiInfo = null;
        try {
            if (wifiQueue != null) {
                byte[] temp = new byte[]{};
                while (wifiQueue.size() > 0) {
                    byte[] data = wifiQueue.poll();
                    byte[] nTemp = new byte[temp.length + data.length];
                    System.arraycopy(temp, 0, nTemp, 0, temp.length);
                    System.arraycopy(data, 0, nTemp, temp.length, data.length);
                    temp = nTemp;
                }
                mWifiInfo = new String(temp);
                LogUtils.e("BleCMD", "updateWifiInfo:" + mWifiInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mWifiInfo;
    }
}

