/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.wifi.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.ParcelUuid;
import android.text.TextUtils;
import android.util.Log;
import com.xshare.business.utils.LogUtils;
import com.xshare.business.wifi.WifiDeviceBean;
import com.xshare.wifi.bluetooth.BleCMD;
import com.xshare.wifi.bluetooth.BleConfig;
import com.xshare.wifi.bluetooth.BleDisConnect;
import com.xshare.wifi.bluetooth.BleManager;
import com.xshare.wifi.bluetooth.BleUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;

@SuppressLint(value={"MissingPermission"})
class BleClient {
    private final String TAG = BleClient.class.getSimpleName();
    private Context mApplicationContext;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothLeScanner mBluetoothLeScanner;
    private BluetoothDevice mBluetoothDevice;
    private BluetoothGatt mBluetoothGatt;
    private BluetoothGatt mConnectedGatt;
    private BluetoothGattCharacteristic mCharacteristic;
    private ScanCallback mScanCallback;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private final int retryCounts = 10;
    private final int MSG_GAP_SCAN = 0xFF1101;
    private final int MSG_GAP_STOP_SCAN = 16716034;
    private final int MSG_GET_SCANNER = 16716035;
    private final int MSG_GATT_CONNECT_BUSY = 16716036;
    private final int MSG_CHECK_DISCOVERY = 16716037;
    private final long SCAN_GAT_TIME = 5000L;
    private WifiDeviceBean mWifiDeviceBean;
    private LinkedBlockingQueue<byte[]> mCmdQueue;
    private BleCMD bleCMD;
    private Map<String, BluetoothDevice> mBleDevicesList;
    private Map<String, BluetoothDevice> hadConnect;
    private String currentConnectUUID;
    private boolean sending = false;
    private int startRetry = 0;
    private int discoveryRetry = 0;
    private boolean onScanningFlag = false;
    private ScanFilter build;
    private ArrayList<ScanFilter> arrayList;
    private ScanSettings.Builder mScanBuilder;
    public BluetoothGattCallback mBluetoothGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            try {
                BluetoothDevice dev = gatt.getDevice();
                BleClient.this.mConnectedGatt = gatt;
                LogUtils.e(BleClient.this.TAG, String.format("onConnectionStateChange:%s,%s,%s,%s", dev.getName(), dev.getAddress(), status, newState));
                if (status == 0 && newState == 2) {
                    LogUtils.e(BleClient.this.TAG, "Connect Succeed , onConnectionStateChange, gatt.discoverServices()");
                    boolean discoverStatus = BleClient.this.mConnectedGatt.discoverServices();
                    LogUtils.e(BleClient.this.TAG, "onConnectionStateChange, mConnectedGatt.discoverServices() result =" + discoverStatus);
                } else {
                    BleClient.this.closeConn();
                    if (BleClient.this.mBleDevicesList.containsKey(gatt.getDevice().getAddress())) {
                        BleClient.this.mBleDevicesList.remove(gatt.getDevice().getAddress());
                    }
                    BleClient.this.startProcessConnect();
                    LogUtils.e(BleClient.this.TAG, "Connect Failed ,  UUID=" + BleClient.this.currentConnectUUID);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            try {
                LogUtils.e(BleClient.this.TAG, String.format("onServicesDiscovered:%s,%s,%s", gatt.getDevice().getName(), gatt.getDevice().getAddress(), status));
                if (status == 0) {
                    boolean findXShare = false;
                    for (BluetoothGattService service : gatt.getServices()) {
                        UUID xshareUUid = service.getUuid();
                        LogUtils.e(BleClient.this.TAG, "Gatt Services's UUID:" + xshareUUid);
                        if (xshareUUid == null || !xshareUUid.toString().equals(BleConfig.XSHARE_SERVER_UUID.toString())) continue;
                        LogUtils.e(BleClient.this.TAG, "Find XShare UUID:" + xshareUUid);
                        findXShare = true;
                        String macAddress = gatt.getDevice().getAddress();
                        if (BleClient.this.hadConnect.containsKey(macAddress)) continue;
                        BleClient.this.mCharacteristic = service.getCharacteristic(BleConfig.UUID_CHAR_WRITE);
                        BleClient.this.mCmdQueue = BleClient.this.bleCMD.getWifiInfoCmdQue(BleUtil.convertToBleDevices(BleClient.this.mWifiDeviceBean).createBleStr());
                        if (BleClient.this.mCmdQueue == null || BleClient.this.mCharacteristic == null) break;
                        BleClient.this.mCharacteristic.setWriteType(2);
                        byte[] sendByte = (byte[])BleClient.this.mCmdQueue.poll();
                        BleClient.this.mCharacteristic.setValue(sendByte);
                        BleClient.this.sending = true;
                        boolean sendStatus = BleClient.this.mBluetoothGatt.writeCharacteristic(BleClient.this.mCharacteristic);
                        if (sendStatus) {
                            BleClient.this.hadConnect.put(macAddress, (BluetoothDevice)BleClient.this.mBleDevicesList.get(macAddress));
                        }
                        LogUtils.e(BleClient.this.TAG, "sendStatus:" + sendStatus);
                        break;
                    }
                    if (!((findXShare || BleClient.this.sending) && BleClient.this.sending || BleClient.this.mHandler == null)) {
                        BleClient.this.stopLeScanAndConnect();
                        BleClient.this.mHandler.removeMessages(0xFF1101);
                        LogUtils.e(BleClient.this.TAG, "onServicesDiscovered Succeed sendEmptyMessage(MSG_GAP_SCAN)");
                        BleClient.this.mHandler.sendEmptyMessage(0xFF1101);
                    }
                    LogUtils.e(BleClient.this.TAG, "Find XShare Result:" + findXShare + ", Sending Status\uff1a" + BleClient.this.sending);
                } else if (BleClient.this.mHandler != null) {
                    BleClient.this.stopLeScanAndConnect();
                    BleClient.this.mHandler.removeMessages(0xFF1101);
                    LogUtils.e(BleClient.this.TAG, "onServicesDiscovered Failed sendEmptyMessage(MSG_GAP_SCAN)");
                    BleClient.this.mHandler.sendEmptyMessage(0xFF1101);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            String valueStr = new String(characteristic.getValue());
            LogUtils.e(BleClient.this.TAG, "onCharacteristicRead:" + valueStr);
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            try {
                LogUtils.e(BleClient.this.TAG, "onCharacteristicWrite:" + new String(characteristic.getValue()));
                if (BleClient.this.mCmdQueue != null && BleClient.this.mCmdQueue.size() > 0) {
                    characteristic.setWriteType(2);
                    BleClient.this.sending = true;
                    byte[] sendByte = (byte[])BleClient.this.mCmdQueue.poll();
                    characteristic.setValue(sendByte);
                    boolean sendStatus = BleClient.this.mBluetoothGatt.writeCharacteristic(characteristic);
                    LogUtils.e(BleClient.this.TAG, "onCharacteristicWrite sendStatus:" + sendStatus);
                    if (BleClient.this.mCmdQueue.size() < 1) {
                        LogUtils.e(BleClient.this.TAG, "Send CMD Finish");
                        BleClient.this.closeConn();
                        BleClient.this.stopLeScanAndConnect();
                        if (BleClient.this.mHandler != null) {
                            BleClient.this.mHandler.removeMessages(0xFF1101);
                            LogUtils.e(BleClient.this.TAG, "onCharacteristicWrite Finished sendEmptyMessage(MSG_GAP_SCAN)");
                            BleClient.this.mHandler.sendEmptyMessage(0xFF1101);
                        }
                    }
                } else {
                    BleClient.this.closeConn();
                    BleClient.this.stopLeScanAndConnect();
                    if (BleClient.this.mHandler != null) {
                        BleClient.this.mHandler.removeMessages(0xFF1101);
                        LogUtils.e(BleClient.this.TAG, "onCharacteristicWrite No CMD sendEmptyMessage(MSG_GAP_SCAN)");
                        BleClient.this.mHandler.sendEmptyMessage(0xFF1101);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            String valueStr = new String(characteristic.getValue());
            LogUtils.e(BleClient.this.TAG, "onCharacteristicChanged:" + valueStr);
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            String valueStr = Arrays.toString(descriptor.getValue());
            LogUtils.e(BleClient.this.TAG, "onDescriptorRead:" + valueStr);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            String valueStr = Arrays.toString(descriptor.getValue());
            LogUtils.e(BleClient.this.TAG, "onDescriptorWrite:" + valueStr);
        }
    };

    public BleClient(Context applicationContext, BluetoothAdapter bluetoothAdapter) {
        this.mApplicationContext = applicationContext;
        this.mBluetoothAdapter = bluetoothAdapter;
        this.mBleDevicesList = new HashMap<String, BluetoothDevice>();
        this.hadConnect = new HashMap<String, BluetoothDevice>();
        try {
            this.build = new ScanFilter.Builder().setServiceUuid(ParcelUuid.fromString((String)BleConfig.XSHARE_SERVER_UUID.toString())).build();
            this.arrayList = new ArrayList();
            this.arrayList.add(this.build);
            this.mScanBuilder = new ScanSettings.Builder();
            this.mScanBuilder.setScanMode(2);
            if (Build.VERSION.SDK_INT >= 23) {
                this.mScanBuilder.setCallbackType(1);
            }
            this.initHandlerThread();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateWifiDeviceBean(WifiDeviceBean wifiDeviceBean) {
        try {
            this.mWifiDeviceBean = wifiDeviceBean;
            this.stopLeScanAndConnect();
            if (this.mBleDevicesList != null && !this.mBleDevicesList.isEmpty()) {
                this.startProcessConnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initHandlerThread() {
        LogUtils.e(this.TAG, "initHandlerThread");
        try {
            if (this.mHandlerThread != null && this.mHandlerThread.isAlive()) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread.interrupt();
                this.mHandlerThread = null;
            }
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mHandlerThread = new HandlerThread("BleClient", 0);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            public void dispatchMessage(Message msg) {
                switch (msg.what) {
                    case 0xFF1101: {
                        BleClient.this.startBleScan();
                        break;
                    }
                    case 16716034: {
                        try {
                            if (BleClient.this.mHandler == null) break;
                            BleClient.this.stopLeScanAndConnect();
                            BleClient.this.mHandler.sendEmptyMessageDelayed(0xFF1101, 1500L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 16716035: {
                        BleClient.this.getBluetoothLeScanner();
                        break;
                    }
                    case 16716036: {
                        BleClient.this.processBleConnectBusy();
                        break;
                    }
                    case 16716037: {
                        BleClient.this.reCheckDiscovery();
                    }
                }
            }
        };
    }

    public void init(WifiDeviceBean wifiDeviceBean) {
        try {
            if (this.mBleDevicesList != null) {
                this.mBleDevicesList.clear();
            }
            if (this.hadConnect != null) {
                this.hadConnect.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.mHandler == null) {
                this.initHandlerThread();
            }
            LogUtils.e(this.TAG, "BleClient onScanResult Start Scan");
            this.mWifiDeviceBean = wifiDeviceBean;
            this.bleCMD = new BleCMD();
            this.startRetry = 0;
            this.intScanCallBack();
            this.mHandler.sendEmptyMessage(0xFF1101);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void intScanCallBack() {
        if (null == this.mScanCallback) {
            this.mScanCallback = new ScanCallback(){

                public void onScanResult(int callbackType, ScanResult result) {
                    super.onScanResult(callbackType, result);
                    LogUtils.e(BleClient.this.TAG, "result \uff1a " + result.toString());
                    try {
                        List resultUuids = result.getScanRecord().getServiceUuids();
                        if (null != resultUuids && null != resultUuids.get(0)) {
                            UUID targetUUID = ((ParcelUuid)resultUuids.get(0)).getUuid();
                            if (targetUUID != null) {
                                String tUUIDStr = targetUUID.toString();
                                if (tUUIDStr.equals(BleConfig.XSHARE_SERVER_UUID.toString()) && !BleClient.this.mBleDevicesList.containsKey(result.getDevice().getAddress())) {
                                    LogUtils.d(BleClient.this.TAG, "XShare onScanResult Address:" + result.getDevice().getAddress());
                                    BleClient.this.mBleDevicesList.put(result.getDevice().getAddress(), result.getDevice());
                                    if (BleClient.this.mWifiDeviceBean != null && !TextUtils.isEmpty((CharSequence)BleClient.this.mWifiDeviceBean.getWifiSSID()) && BleClient.this.mHandler != null && !BleClient.this.hadConnect.containsKey(result.getDevice().getAddress())) {
                                        BleClient.this.stopLeScanAndConnect();
                                        BleClient.this.startConnect(result.getDevice());
                                    }
                                } else {
                                    LogUtils.d(BleClient.this.TAG, "Not XShare Address Or Had Add:" + result.getDevice().getAddress());
                                }
                            } else {
                                LogUtils.d(BleClient.this.TAG, "Not XShare Address:" + result.getDevice().getAddress());
                            }
                        }
                    }
                    catch (Exception e) {
                        LogUtils.d(BleClient.this.TAG, "mBluetoothLeScanner Exception:" + e.getMessage());
                    }
                }

                public void onBatchScanResults(List<ScanResult> results) {
                    super.onBatchScanResults(results);
                    LogUtils.e(BleClient.this.TAG, "onBatchScanResults Size:" + results.size());
                }

                public void onScanFailed(int errorCode) {
                    super.onScanFailed(errorCode);
                    try {
                        LogUtils.d(BleClient.this.TAG, "onScanFailed:" + errorCode);
                        BleClient.this.stopLeScanAndConnect();
                        if (BleClient.this.mHandler != null) {
                            BleClient.this.closeConn();
                            BleClient.this.mHandler.removeMessages(0xFF1101);
                            BleClient.this.mHandler.sendEmptyMessage(0xFF1101);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
        }
    }

    private void startBleScan() {
        try {
            if (null != this.mBluetoothAdapter) {
                this.mBluetoothLeScanner = this.mBluetoothAdapter.getBluetoothLeScanner();
                if (this.mScanCallback == null) {
                    this.intScanCallBack();
                }
                if (this.mBluetoothLeScanner != null && this.mBluetoothAdapter.isEnabled()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                BleClient.this.startRetry = 0;
                                LogUtils.e(BleClient.this.TAG, "mBluetoothLeScanner.startScan()");
                                BleClient.this.onScanningFlag = true;
                                try {
                                    BleClient.this.mBluetoothLeScanner.startScan((List)BleClient.this.arrayList, BleClient.this.mScanBuilder.build(), BleClient.this.mScanCallback);
                                    if (null != BleClient.this.mHandler) {
                                        BleClient.this.mHandler.sendEmptyMessageDelayed(16716034, 5000L);
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    if (null == BleClient.this.mHandler) break block3;
                                    BleClient.this.mHandler.sendEmptyMessageDelayed(16716035, 5000L);
                                }
                            }
                        }
                    }).start();
                } else if (this.mHandler != null) {
                    if (this.startRetry < 10) {
                        this.mHandler.sendEmptyMessage(16716035);
                    } else {
                        LogUtils.e(this.TAG, "startBleScan sendEmptyMessage(MSG_GAP_SCAN)");
                        this.mHandler.sendEmptyMessage(0xFF1101);
                    }
                }
            } else {
                Log.e((String)this.TAG, (String)"mBluetoothAdapter is Null ,Can't Start Scan");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getBluetoothLeScanner() {
        try {
            this.mBluetoothLeScanner = this.mBluetoothAdapter.getBluetoothLeScanner();
            if (this.mBluetoothLeScanner == null && this.startRetry < 10) {
                if (this.mHandler != null) {
                    ++this.startRetry;
                    this.mHandler.removeMessages(16716035);
                    this.mHandler.sendEmptyMessageDelayed(16716035, 300L);
                }
            } else if (this.mHandler != null) {
                this.stopLeScanAndConnect();
                this.mHandler.removeMessages(0xFF1101);
                LogUtils.e(this.TAG, "getBluetoothLeScanner sendEmptyMessage(MSG_GAP_SCAN)");
                this.mHandler.sendEmptyMessage(0xFF1101);
            }
            BleManager.getInstance().openBluetooth();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startProcessConnect() {
        try {
            if (this.mBleDevicesList != null && !this.mBleDevicesList.isEmpty() && this.mWifiDeviceBean != null && !TextUtils.isEmpty((CharSequence)this.mWifiDeviceBean.getWifiSSID())) {
                this.stopLeScanAndConnect();
                boolean connecting = false;
                for (Map.Entry<String, BluetoothDevice> entry : this.mBleDevicesList.entrySet()) {
                    if (this.hadConnect.containsKey(entry.getKey())) continue;
                    connecting = true;
                    this.currentConnectUUID = entry.getKey();
                    this.startConnect(entry.getValue());
                    break;
                }
                if (!connecting) {
                    this.stopLeScanAndConnect();
                    LogUtils.e(this.TAG, "startProcessConnect sendEmptyMessage(MSG_GAP_SCAN)");
                    this.mHandler.sendEmptyMessage(0xFF1101);
                }
            } else if (this.mHandler != null) {
                this.stopLeScanAndConnect();
                this.mHandler.removeMessages(0xFF1101);
                this.mHandler.removeMessages(16716035);
                LogUtils.e(this.TAG, "startProcessConnect (Devices is null)sendEmptyMessage(MSG_GAP_SCAN)");
                this.mHandler.sendEmptyMessage(0xFF1101);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopLeScanAndConnect() {
        try {
            if (null != this.mBluetoothLeScanner && null != this.mBluetoothAdapter && null != this.mScanCallback) {
                this.mBluetoothLeScanner.stopScan(this.mScanCallback);
                this.startRetry = 0;
                this.mScanCallback = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startConnect(BluetoothDevice bluetoothDevice) {
        try {
            if (this.mHandler != null) {
                this.mHandler.removeMessages(16716034);
            }
            this.closeConn();
            if (null != bluetoothDevice) {
                this.mBluetoothDevice = bluetoothDevice;
                LogUtils.e(this.TAG, "startConnect, Mac Address=" + this.mBluetoothDevice.getAddress() + " , Devices Name:" + this.mBluetoothDevice.getName());
                this.discoveryRetry = 0;
                this.mBluetoothGatt = Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22 ? this.hookBleConnectGatt(bluetoothDevice, this.mApplicationContext, false, this.mBluetoothGattCallback, 2) : this.mBluetoothDevice.connectGatt(this.mApplicationContext, false, this.mBluetoothGattCallback);
                if (null == this.mBluetoothGatt) {
                    if (this.mHandler != null) {
                        this.mHandler.removeMessages(0xFF1101);
                        this.mHandler.removeMessages(16716035);
                    }
                    this.startProcessConnect();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BluetoothGatt hookBleConnectGatt(BluetoothDevice bluetoothDevice, Context mApplicationContext, boolean autoConnect, BluetoothGattCallback bluetoothGattCallback, int transport) {
        try {
            Method connectGatt = bluetoothDevice.getClass().getDeclaredMethod("connectGatt", Context.class, Boolean.TYPE, BluetoothGattCallback.class, Integer.TYPE);
            return (BluetoothGatt)connectGatt.invoke((Object)bluetoothDevice, mApplicationContext, autoConnect, bluetoothGattCallback, transport);
        }
        catch (Throwable e) {
            Log.e((String)this.TAG, (String)("mBluetoothDevice.connectGatt:" + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }

    private void closeConn() {
        try {
            this.sending = false;
            if (this.mBluetoothGatt != null) {
                this.mBluetoothGatt.disconnect();
                this.mBluetoothGatt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processBleConnectBusy() {
        try {
            this.stopLeScanAndConnect();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.startProcessConnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reCheckDiscovery() {
        block6: {
            try {
                if (this.discoveryRetry < 10) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            boolean discoverStatus = BleClient.this.mConnectedGatt.discoverServices();
                            BleClient.this.discoveryRetry++;
                            LogUtils.e(BleClient.this.TAG, "onConnectionStateChange, requested =" + discoverStatus);
                            if (BleClient.this.mHandler != null) {
                                BleClient.this.mHandler.sendEmptyMessageDelayed(16716037, 200L);
                            }
                        }
                    }).start();
                    break block6;
                }
                if (this.mHandler != null) {
                    this.stopLeScanAndConnect();
                    LogUtils.e(this.TAG, "reCheckDiscovery sendEmptyMessage(MSG_GAP_SCAN)");
                    this.mHandler.sendEmptyMessage(0xFF1101);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopLeScan() {
        try {
            this.closeConn();
            if (null != this.mBluetoothLeScanner && this.mBluetoothAdapter.isEnabled() && null != this.mScanCallback) {
                this.mBluetoothLeScanner.stopScan(this.mScanCallback);
            }
            if (this.mHandlerThread != null && this.mHandlerThread.isAlive()) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread.interrupt();
                this.mHandlerThread = null;
            }
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler = null;
            }
            BleDisConnect bleDisConnect = new BleDisConnect(this.hadConnect, this.mWifiDeviceBean);
            bleDisConnect.startSendDisconnectCmd(() -> {
                try {
                    if (this.mBleDevicesList != null) {
                        this.mBleDevicesList.clear();
                    }
                    if (this.hadConnect != null) {
                        this.hadConnect.clear();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

