/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.wifi.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.LogUtils;
import com.xshare.business.wifi.WifiDeviceBean;
import com.xshare.wifi.bluetooth.BleCMD;
import com.xshare.wifi.bluetooth.BleConfig;
import com.xshare.wifi.bluetooth.BleUtil;
import com.xshare.wifi.bluetooth.SendDisconnectCmdListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;

@SuppressLint(value={"MissingPermission"})
public class BleDisConnect {
    private final String TAG = BleDisConnect.class.getSimpleName();
    private BluetoothGattCharacteristic mCharacteristic;
    private Map<String, BluetoothDevice> mDisconnectList;
    private Map<String, BluetoothDevice> hadDisconnected;
    private BluetoothDevice mBluetoothDevice;
    private BluetoothGatt mBluetoothGatt;
    private BluetoothGatt mConnectedGatt;
    private boolean connecting = false;
    private boolean sending = false;
    private LinkedBlockingQueue<byte[]> mCmdQueue;
    private BleCMD bleCMD;
    private WifiDeviceBean mWifiDeviceBean;
    private SendDisconnectCmdListener mSendDisconnectCmdListener;
    private BluetoothGattCallback mBluetoothGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            try {
                BluetoothDevice dev = gatt.getDevice();
                BleDisConnect.this.mConnectedGatt = gatt;
                LogUtils.e(BleDisConnect.this.TAG, String.format("onConnectionStateChange:%s,%s,%s,%s", dev.getName(), dev.getAddress(), status, newState));
                if (status == 0 && newState == 2) {
                    LogUtils.e(BleDisConnect.this.TAG, "Connect Succeed , onConnectionStateChange, gatt.discoverServices()");
                    boolean discoverStatus = BleDisConnect.this.mConnectedGatt.discoverServices();
                    LogUtils.e(BleDisConnect.this.TAG, "onConnectionStateChange, mConnectedGatt.discoverServices() result =" + discoverStatus);
                } else {
                    BleDisConnect.this.closeConn();
                    if (BleDisConnect.this.mDisconnectList != null && BleDisConnect.this.mDisconnectList.size() > 0) {
                        BleDisConnect.this.hadDisconnected.remove(dev.getAddress());
                    }
                    BleDisConnect.this.startSendDisconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            try {
                LogUtils.e(BleDisConnect.this.TAG, String.format("onServicesDiscovered:%s,%s,%s", gatt.getDevice().getName(), gatt.getDevice().getAddress(), status));
                if (status == 0) {
                    boolean findXShare = false;
                    for (BluetoothGattService service : gatt.getServices()) {
                        UUID xshareUUid = service.getUuid();
                        if (xshareUUid == null || !xshareUUid.toString().equals(BleConfig.XSHARE_SERVER_UUID.toString())) continue;
                        LogUtils.e(BleDisConnect.this.TAG, "Find XShare UUID:" + xshareUUid);
                        findXShare = true;
                        String macAddress = gatt.getDevice().getAddress();
                        if (BleDisConnect.this.hadDisconnected.containsKey(macAddress)) continue;
                        BleDisConnect.this.mCharacteristic = service.getCharacteristic(BleConfig.UUID_CHAR_WRITE);
                        BleDisConnect.this.mCmdQueue = BleDisConnect.this.bleCMD.getDisconnectCmdQue(BleUtil.convertToBleDevices(BleDisConnect.this.mWifiDeviceBean).createBleStr());
                        if (BleDisConnect.this.mCmdQueue == null || BleDisConnect.this.mCharacteristic == null) break;
                        BleDisConnect.this.mCharacteristic.setWriteType(2);
                        byte[] sendByte = (byte[])BleDisConnect.this.mCmdQueue.poll();
                        BleDisConnect.this.mCharacteristic.setValue(sendByte);
                        BleDisConnect.this.sending = true;
                        boolean sendStatus = BleDisConnect.this.mBluetoothGatt.writeCharacteristic(BleDisConnect.this.mCharacteristic);
                        if (sendStatus) {
                            BleDisConnect.this.hadDisconnected.put(macAddress, (BluetoothDevice)BleDisConnect.this.mDisconnectList.get(macAddress));
                        }
                        LogUtils.e(BleDisConnect.this.TAG, "sendStatus:" + sendStatus);
                        break;
                    }
                    if (!findXShare && !BleDisConnect.this.sending || !BleDisConnect.this.sending) {
                        BleDisConnect.this.closeConn();
                        BleDisConnect.this.startSendDisconnect();
                    }
                    LogUtils.e(BleDisConnect.this.TAG, "Find XShare Result:" + findXShare + ", Sending Status\uff1a" + BleDisConnect.this.sending);
                } else {
                    BleDisConnect.this.closeConn();
                    BleDisConnect.this.startSendDisconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            String valueStr = new String(characteristic.getValue());
            LogUtils.e(BleDisConnect.this.TAG, "onCharacteristicRead:" + valueStr);
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            try {
                if (characteristic.getValue() != null) {
                    LogUtils.e(BleDisConnect.this.TAG, "onCharacteristicWrite:" + new String(characteristic.getValue()));
                }
                if (BleDisConnect.this.mCmdQueue != null && BleDisConnect.this.mCmdQueue.size() > 0) {
                    characteristic.setWriteType(2);
                    BleDisConnect.this.sending = true;
                    byte[] sendByte = (byte[])BleDisConnect.this.mCmdQueue.poll();
                    characteristic.setValue(sendByte);
                    boolean sendStatus = BleDisConnect.this.mBluetoothGatt.writeCharacteristic(characteristic);
                    LogUtils.e(BleDisConnect.this.TAG, "onCharacteristicWrite sendStatus:" + sendStatus);
                    if (BleDisConnect.this.mCmdQueue.size() < 1) {
                        LogUtils.e(BleDisConnect.this.TAG, "Send CMD Finish");
                        BleDisConnect.this.closeConn();
                        BleDisConnect.this.mDisconnectList.remove(gatt.getDevice().getAddress());
                        BleDisConnect.this.startSendDisconnect();
                    }
                } else {
                    BleDisConnect.this.closeConn();
                    BleDisConnect.this.startSendDisconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            String valueStr = new String(characteristic.getValue());
            LogUtils.e(BleDisConnect.this.TAG, "onCharacteristicChanged:" + valueStr);
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            String valueStr = Arrays.toString(descriptor.getValue());
            LogUtils.e(BleDisConnect.this.TAG, "onDescriptorRead:" + valueStr);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            String valueStr = Arrays.toString(descriptor.getValue());
            LogUtils.e(BleDisConnect.this.TAG, "onDescriptorWrite:" + valueStr);
        }
    };

    public BleDisConnect(Map<String, BluetoothDevice> disconnectList, WifiDeviceBean wifiDeviceBean) {
        this.mDisconnectList = disconnectList;
        this.hadDisconnected = new HashMap<String, BluetoothDevice>();
        this.mWifiDeviceBean = wifiDeviceBean;
        this.bleCMD = new BleCMD();
    }

    public void startSendDisconnectCmd(SendDisconnectCmdListener sendDisconnectCmdListener) {
        this.mSendDisconnectCmdListener = sendDisconnectCmdListener;
        this.startSendDisconnect();
    }

    private void startSendDisconnect() {
        try {
            for (Map.Entry<String, BluetoothDevice> entry : this.mDisconnectList.entrySet()) {
                if (this.hadDisconnected.containsKey(entry.getKey())) continue;
                this.connecting = true;
                this.startConnect(entry.getValue());
                break;
            }
            if (this.mDisconnectList == null || this.hadDisconnected.size() == this.mDisconnectList.size()) {
                this.mSendDisconnectCmdListener.onSendFinished();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeConn() {
        try {
            this.sending = false;
            if (this.mBluetoothGatt != null) {
                this.mBluetoothGatt.disconnect();
                this.mBluetoothGatt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startConnect(BluetoothDevice bluetoothDevice) {
        try {
            this.closeConn();
            if (null != bluetoothDevice) {
                this.mBluetoothDevice = bluetoothDevice;
                LogUtils.e(this.TAG, "startConnect, Mac Address=" + this.mBluetoothDevice.getAddress() + " , Devices Name:" + this.mBluetoothDevice.getName());
                this.mBluetoothGatt = Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22 ? this.hookBleConnectGatt(bluetoothDevice, (Context)BaseApplication.baseApplication, false, this.mBluetoothGattCallback, 2) : this.mBluetoothDevice.connectGatt((Context)BaseApplication.baseApplication, false, this.mBluetoothGattCallback);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BluetoothGatt hookBleConnectGatt(BluetoothDevice bluetoothDevice, Context mApplicationContext, boolean autoConnect, BluetoothGattCallback bluetoothGattCallback, int transport) {
        try {
            Method connectGatt = bluetoothDevice.getClass().getDeclaredMethod("connectGatt", Context.class, Boolean.TYPE, BluetoothGattCallback.class, Integer.TYPE);
            return (BluetoothGatt)connectGatt.invoke((Object)bluetoothDevice, mApplicationContext, autoConnect, bluetoothGattCallback, transport);
        }
        catch (Throwable e) {
            Log.e((String)this.TAG, (String)("mBluetoothDevice.connectGatt:" + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }
}

