/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.wifi.bluetooth;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import com.xshare.base.BaseApplication;
import com.xshare.business.utils.XSMatch;
import com.xshare.business.wifi.WifiDeviceBean;
import com.xshare.wifi.bluetooth.BleClient;
import com.xshare.wifi.bluetooth.BleScanListener;
import com.xshare.wifi.bluetooth.BleServer;

@SuppressLint(value={"MissingPermission"})
public class BleManager {
    private final String TAG = BleManager.class.getSimpleName();
    private Context mContext;
    private BluetoothManager mBluetoothManager;
    private BluetoothAdapter mBluetoothAdapter;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    static final int MSG_OPEN_BLUETOOTH = 0xFF1001;
    static final int MSG_CLOSE_BLUETOOTH = 16715778;
    static final int MSG_START_SERVER = 16715779;
    static final int MSG_STOP_SERVER = 16715780;
    static final int MSG_START_CLIENT = 16715781;
    static final int MSG_STOP_CLIENT = 16715782;
    static final int MSG_UPDATE_CLIENT = 267452519;
    private BleServer mBleServer;
    private BleClient mBleClient;

    public static BleManager getInstance() {
        return SingleTonHolder.INSTANCE;
    }

    private BleManager() {
        if (this.mHandlerThread != null && this.mHandlerThread.isAlive()) {
            this.mHandlerThread.quitSafely();
            this.mHandlerThread.interrupt();
            this.mHandlerThread = null;
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        this.mHandlerThread = new HandlerThread("BleManager", 0);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            public void dispatchMessage(Message msg) {
                if (!ActivityManager.isUserAMonkey()) {
                    switch (msg.what) {
                        case 0xFF1001: {
                            try {
                                if (null == BleManager.this.mBluetoothAdapter || BleManager.this.mBluetoothAdapter.isEnabled()) break;
                                BleManager.this.mBluetoothAdapter.enable();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case 16715778: {
                            try {
                                boolean isTranssionDevices = XSMatch.IS_TRANSSION_DEVICES;
                                Log.d((String)BleManager.this.TAG, (String)("isTranssionDevices:" + isTranssionDevices));
                                if (null == BleManager.this.mBluetoothAdapter || !BleManager.this.mBluetoothAdapter.isEnabled() || !isTranssionDevices) break;
                                BleManager.this.mBluetoothAdapter.disable();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case 16715779: {
                            try {
                                if (BleManager.this.hadLeFeature() && BleManager.this.mBleServer != null) {
                                    BleManager.this.mBleServer.initBleServer();
                                    break;
                                }
                                Log.e((String)BleManager.this.TAG, (String)"This Phone is not Support LE");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case 16715780: {
                            try {
                                if (BleManager.this.mBleServer == null) break;
                                BleManager.this.mBleServer.stop();
                                BleManager.this.mBleServer = null;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case 16715781: {
                            try {
                                if (BleManager.this.hadLeFeature() && BleManager.this.mBleClient != null) {
                                    BleManager.this.mBleClient.init((WifiDeviceBean)msg.obj);
                                    break;
                                }
                                Log.e((String)BleManager.this.TAG, (String)"This Phone is not Support LE");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case 267452519: {
                            try {
                                if (BleManager.this.hadLeFeature() && BleManager.this.mBleClient != null) {
                                    BleManager.this.mBleClient.updateWifiDeviceBean((WifiDeviceBean)msg.obj);
                                    break;
                                }
                                Log.e((String)BleManager.this.TAG, (String)"This Phone is not Support LE");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case 16715782: {
                            try {
                                if (BleManager.this.mBleClient == null) break;
                                BleManager.this.mBleClient.stopLeScan();
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        };
        this.mContext = BaseApplication.baseApplication.getApplicationContext();
        if (this.hadLeFeature()) {
            this.mBluetoothManager = (BluetoothManager)this.mContext.getSystemService("bluetooth");
            this.mBluetoothAdapter = this.mBluetoothManager.getAdapter();
        } else {
            Log.e((String)this.TAG, (String)"This Phone is not Support LE");
        }
    }

    public boolean hadLeFeature() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public boolean isMultipleAdvertisementSupported() {
        if (this.mBluetoothAdapter != null) {
            return this.mBluetoothAdapter.isMultipleAdvertisementSupported();
        }
        return false;
    }

    public void openBluetooth() {
        if (!ActivityManager.isUserAMonkey() && this.mHandler != null) {
            this.mHandler.sendEmptyMessage(0xFF1001);
        }
    }

    public void resetBluetooth() {
        if (!ActivityManager.isUserAMonkey() && this.mHandler != null) {
            this.mHandler.sendEmptyMessage(16715778);
        }
    }

    public void startBleServer(BleScanListener bleScanListener) {
        if (!ActivityManager.isUserAMonkey() && this.mHandler != null) {
            if (this.mBleServer == null) {
                this.mBleServer = new BleServer(this.mContext, this.mBluetoothManager, this.mBluetoothAdapter, bleScanListener);
            } else {
                this.mBleServer.setBleScanListener(bleScanListener);
            }
            this.mHandler.sendEmptyMessage(16715779);
        }
    }

    public void stopBleServer() {
        if (!ActivityManager.isUserAMonkey() && this.mHandler != null) {
            this.mHandler.sendEmptyMessage(16715780);
        }
    }

    public void startBleClient(WifiDeviceBean wifiDeviceBean) {
        if (!ActivityManager.isUserAMonkey() && this.mHandler != null) {
            Message msg;
            if (this.mBleClient == null) {
                this.mBleClient = new BleClient(this.mContext, this.mBluetoothAdapter);
            }
            if ((msg = this.mHandler.obtainMessage(16715781)) == null) {
                msg = new Message();
            }
            msg.obj = wifiDeviceBean;
            msg.what = 16715781;
            this.mHandler.sendMessage(msg);
        }
    }

    public void updateBleClientWifiInfo(WifiDeviceBean wifiDeviceBean) {
        if (!ActivityManager.isUserAMonkey() && this.mHandler != null) {
            Message msg;
            if (this.mBleClient == null) {
                this.mBleClient = new BleClient(this.mContext, this.mBluetoothAdapter);
            }
            if ((msg = this.mHandler.obtainMessage(267452519)) == null) {
                msg = new Message();
            }
            msg.obj = wifiDeviceBean;
            msg.what = 267452519;
            this.mHandler.sendMessage(msg);
        }
    }

    public void stopBleClient() {
        if (!ActivityManager.isUserAMonkey() && this.mHandler != null) {
            this.mHandler.sendEmptyMessage(16715782);
        }
    }

    public void releaseBleManager() {
        try {
            if (this.mHandlerThread != null && this.mHandlerThread.isAlive()) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread.interrupt();
                this.mHandlerThread = null;
            }
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class SingleTonHolder {
        private static BleManager INSTANCE = new BleManager();

        private SingleTonHolder() {
        }
    }
}

