/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.wifi.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.content.Context;
import android.os.ParcelUuid;
import com.xshare.business.utils.LogUtils;
import com.xshare.wifi.bluetooth.BleCMD;
import com.xshare.wifi.bluetooth.BleConfig;
import com.xshare.wifi.bluetooth.BleDevice;
import com.xshare.wifi.bluetooth.BleManager;
import com.xshare.wifi.bluetooth.BleScanListener;
import com.xshare.wifi.bluetooth.BleUtil;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

@SuppressLint(value={"MissingPermission"})
class BleServer {
    private final String TAG = BleServer.class.getSimpleName();
    private BluetoothManager mBluetoothManager;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothLeAdvertiser mBluetoothLeAdvertiser;
    private BluetoothGattServer mBluetoothGattServer;
    private BluetoothGattService mBluetoothGattService;
    private Context mApplicationContext;
    private UUID mServicesUUID;
    private BleCMD mBleCmd;
    private BleScanListener mBleScanListenerRef;
    private ConcurrentHashMap<String, LinkedBlockingQueue<byte[]>> mXShareWifiMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, LinkedBlockingQueue<byte[]>> mDisConnectMap = new ConcurrentHashMap();
    private AdvertiseCallback mAdvertiseCallback;
    private BluetoothGattServerCallback mBluetoothGattServerCallback = new BluetoothGattServerCallback(){

        public void onConnectionStateChange(BluetoothDevice device, int status, int newState) {
            super.onConnectionStateChange(device, status, newState);
            LogUtils.e(BleServer.this.TAG, String.format("onConnectionStateChange:%s,%s,%s,%s", device.getName(), device.getAddress(), status, newState));
            LogUtils.e(BleServer.this.TAG, String.format(status == 0 ? (newState == 2 ? "[%s]Connect Succeed" : "[%s]Disconnect") : "[%s]Connect error,Error Code:" + status, device));
        }

        public void onServiceAdded(int status, BluetoothGattService service) {
            LogUtils.e(BleServer.this.TAG, String.format("onServiceAdded:%s,%s", status, service.getUuid()));
            LogUtils.e(BleServer.this.TAG, String.format(status == 0 ? "Add Service[%s]Succeed" : "Add Service[%s]Failed,Error Code:" + status, service.getUuid()));
        }

        public void onCharacteristicReadRequest(BluetoothDevice device, int requestId, int offset, BluetoothGattCharacteristic characteristic) {
            String response = "XS_" + (int)(Math.random() * 100.0);
            BleServer.this.mBluetoothGattServer.sendResponse(device, requestId, 0, offset, response.getBytes());
            LogUtils.e(BleServer.this.TAG, "onCharacteristicReadRequest:" + response);
        }

        public void onCharacteristicWriteRequest(BluetoothDevice device, int requestId, BluetoothGattCharacteristic characteristic, boolean preparedWrite, boolean responseNeeded, int offset, byte[] requestBytes) {
            try {
                BleServer.this.setData(device.getAddress(), requestBytes);
                BleServer.this.mBluetoothGattServer.sendResponse(device, requestId, 0, offset, "OK".getBytes());
                LogUtils.e(BleServer.this.TAG, "onCharacteristicWriteRequest:requestId" + requestId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onDescriptorReadRequest(BluetoothDevice device, int requestId, int offset, BluetoothGattDescriptor descriptor) {
            String response = "DESC_" + (int)(Math.random() * 100.0);
            BleServer.this.mBluetoothGattServer.sendResponse(device, requestId, 0, offset, response.getBytes());
            LogUtils.e(BleServer.this.TAG, "onDescriptorReadRequest:" + response);
        }

        public void onDescriptorWriteRequest(BluetoothDevice device, int requestId, BluetoothGattDescriptor descriptor, boolean preparedWrite, boolean responseNeeded, int offset, byte[] value) {
            String valueStr = Arrays.toString(value);
            LogUtils.e(BleServer.this.TAG, "onDescriptorWriteRequest:" + valueStr);
        }

        public void onExecuteWrite(BluetoothDevice device, int requestId, boolean execute) {
            LogUtils.i(BleServer.this.TAG, String.format("onExecuteWrite:%s,%s,%s,%s", device.getName(), device.getAddress(), requestId, execute));
        }

        public void onNotificationSent(BluetoothDevice device, int status) {
            LogUtils.i(BleServer.this.TAG, String.format("onNotificationSent:%s,%s,%s", device.getName(), device.getAddress(), status));
        }

        public void onMtuChanged(BluetoothDevice device, int mtu) {
            LogUtils.i(BleServer.this.TAG, String.format("onMtuChanged:%s,%s,%s", device.getName(), device.getAddress(), mtu));
        }
    };

    public BleServer(Context applicationContext, BluetoothManager bluetoothManager, BluetoothAdapter bluetoothAdapter, BleScanListener bleScanListener) {
        this.mApplicationContext = applicationContext;
        this.mBluetoothManager = bluetoothManager;
        this.mBluetoothAdapter = bluetoothAdapter;
        this.mBleScanListenerRef = bleScanListener;
        this.mBleCmd = new BleCMD();
        this.createServicesUUID();
        this.mAdvertiseCallback = new AdvertiseCallback(){

            public void onStartSuccess(AdvertiseSettings settingsInEffect) {
                LogUtils.e(BleServer.this.TAG, "BLE\u5e7f\u64ad\u5f00\u542f\u6210\u529f");
            }

            public void onStartFailure(int errorCode) {
                LogUtils.e(BleServer.this.TAG, "BLE\u5e7f\u64ad\u5f00\u542f\u5931\u8d25,\u9519\u8bef\u7801:" + errorCode);
            }
        };
    }

    public void setBleScanListener(BleScanListener bleScanListener) {
        this.mBleScanListenerRef = bleScanListener;
    }

    private void createServicesUUID() {
        this.mServicesUUID = BleConfig.XSHARE_SERVER_UUID;
    }

    public void initBleServer() {
        try {
            LogUtils.e(this.TAG, "initBleServer");
            if (!this.mBluetoothAdapter.isMultipleAdvertisementSupported()) {
                LogUtils.e(this.TAG, "Device does not support Bluetooth LE");
                return;
            }
            AdvertiseSettings settings = new AdvertiseSettings.Builder().setAdvertiseMode(2).setTxPowerLevel(3).setConnectable(true).build();
            AdvertiseData advertiseData = new AdvertiseData.Builder().setIncludeDeviceName(false).setIncludeTxPowerLevel(true).addServiceUuid(new ParcelUuid(this.mServicesUUID)).build();
            AdvertiseData scanResponse = new AdvertiseData.Builder().setIncludeTxPowerLevel(true).addServiceData(new ParcelUuid(this.mServicesUUID), new byte[0]).build();
            this.mBluetoothLeAdvertiser = this.mBluetoothAdapter.getBluetoothLeAdvertiser();
            if (this.mBluetoothLeAdvertiser != null) {
                this.mBluetoothLeAdvertiser.startAdvertising(settings, advertiseData, scanResponse, this.mAdvertiseCallback);
                this.mBluetoothGattService = new BluetoothGattService(this.mServicesUUID, 0);
                BluetoothGattCharacteristic characteristicRead = new BluetoothGattCharacteristic(BleConfig.UUID_CHAR_READ_NOTIFY, 18, 1);
                characteristicRead.addDescriptor(new BluetoothGattDescriptor(BleConfig.UUID_DESC_NOTITY, 16));
                this.mBluetoothGattService.addCharacteristic(characteristicRead);
                BluetoothGattCharacteristic characteristicWrite = new BluetoothGattCharacteristic(BleConfig.UUID_CHAR_WRITE, 8, 16);
                this.mBluetoothGattService.addCharacteristic(characteristicWrite);
                if (this.mBluetoothManager != null) {
                    this.mBluetoothGattServer = this.mBluetoothManager.openGattServer(this.mApplicationContext, this.mBluetoothGattServerCallback);
                    this.mBluetoothGattServer.addService(this.mBluetoothGattService);
                }
                LogUtils.e(this.TAG, " mBluetoothGattServer.addService(service) UUID=" + this.mServicesUUID);
            } else {
                LogUtils.e(this.TAG, " mBluetoothLeAdvertiser=" + this.mBluetoothLeAdvertiser + ", mBluetoothAdapter=" + this.mBluetoothAdapter + ", had BLE Feature(But not Support Advertising):" + BleManager.getInstance().hadLeFeature());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            if (this.mBluetoothGattServer != null && this.mBluetoothGattService != null) {
                this.mBluetoothGattServer.removeService(this.mBluetoothGattService);
            }
            if (this.mBluetoothLeAdvertiser != null && this.mAdvertiseCallback != null) {
                this.mBluetoothLeAdvertiser.stopAdvertising(this.mAdvertiseCallback);
            }
            this.mBleScanListenerRef = null;
            this.mXShareWifiMap.clear();
            this.mDisConnectMap.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setData(String address, byte[] requestBytes) {
        try {
            if (requestBytes != null && requestBytes.length > 0) {
                switch (requestBytes[0]) {
                    case 3: {
                        this.processWifiQueue(address, requestBytes);
                        break;
                    }
                    case 2: {
                        this.updateWifiInfo(address);
                        break;
                    }
                    case 5: {
                        this.processDisconnectQueue(address, requestBytes);
                        break;
                    }
                    case 6: {
                        this.updateDisconnectInfo(address);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processWifiQueue(String address, byte[] requestBytes) {
        try {
            boolean containUUID = this.mXShareWifiMap.containsKey(address);
            LogUtils.e(this.TAG, "processWifiQueue,Contain address=" + containUUID + ", address=" + address.toString());
            LinkedBlockingQueue<Object> wifiQueue = !containUUID ? new LinkedBlockingQueue() : this.mXShareWifiMap.get(address);
            LinkedBlockingQueue linkedBlockingQueue = wifiQueue;
            synchronized (linkedBlockingQueue) {
                byte[] originData = new byte[requestBytes.length - 1];
                System.arraycopy(requestBytes, 1, originData, 0, requestBytes.length - 1);
                try {
                    wifiQueue.put(originData);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!containUUID) {
                    this.mXShareWifiMap.put(address, wifiQueue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processDisconnectQueue(String address, byte[] requestBytes) {
        try {
            boolean containUUID = this.mDisConnectMap.containsKey(address);
            LogUtils.e(this.TAG, "processWifiQueue,Contain address=" + containUUID + ", address=" + address.toString());
            LinkedBlockingQueue<Object> wifiQueue = !containUUID ? new LinkedBlockingQueue() : this.mDisConnectMap.get(address);
            LinkedBlockingQueue linkedBlockingQueue = wifiQueue;
            synchronized (linkedBlockingQueue) {
                byte[] originData = new byte[requestBytes.length - 1];
                System.arraycopy(requestBytes, 1, originData, 0, requestBytes.length - 1);
                try {
                    wifiQueue.put(originData);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!containUUID) {
                    this.mDisConnectMap.put(address, wifiQueue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateWifiInfo(String address) {
        try {
            LinkedBlockingQueue<byte[]> wifiQueue = this.mXShareWifiMap.get(address);
            if (wifiQueue != null) {
                BleDevice bleDevice = BleUtil.covertToBleDevices(this.mBleCmd.covertWifiInfoQueueToString(wifiQueue));
                if (this.mBleScanListenerRef != null) {
                    this.mBleScanListenerRef.onBleFound(bleDevice);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateDisconnectInfo(String address) {
        try {
            LinkedBlockingQueue<byte[]> wifiQueue = this.mDisConnectMap.get(address);
            if (wifiQueue != null) {
                BleDevice bleDevice = BleUtil.covertToBleDevices(this.mBleCmd.covertWifiInfoQueueToString(wifiQueue));
                if (this.mBleScanListenerRef != null) {
                    this.mBleScanListenerRef.onDisConnect(bleDevice);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

