/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.wifi.viewmodel;

import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.xshare.base.BaseApplication;
import com.xshare.base.adapter.single.CommonBindVMAdapter;
import com.xshare.base.util.ToastUtil;
import com.xshare.base.viewmodel.BaseVMViewModel;
import com.xshare.business.bean.wifi.WifiBleDeviceModel;
import com.xshare.business.bean.wifi.WifiInfoModel;
import com.xshare.business.permissions.PermissionsActivity;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.wifi.ConnectCallBack;
import com.xshare.business.wifi.WifiConnection;
import com.xshare.business.wifi.WifiDeviceBean;
import com.xshare.business.wifi.XSWiFiManager;
import com.xshare.trans.BR;
import com.xshare.trans.R;
import com.xshare.webserver.impl.WebServiceImpl;
import com.xshare.wifi.WifiConnectActivity;
import com.xshare.wifi.bluetooth.BleDevice;
import com.xshare.wifi.log.WifiLog;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DelicateCoroutinesApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0018H\u0002J\u0016\u0010*\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0018J\u0016\u0010+\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0018J\u0016\u0010,\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0018J\u0018\u0010-\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0018H\u0002J\u0016\u0010.\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0018J\u0006\u0010/\u001a\u00020\u0004J\b\u00100\u001a\u0004\u0018\u00010\u000bJ\u0010\u00101\u001a\u0004\u0018\u00010\u000b2\u0006\u00102\u001a\u00020\u0004J\u000e\u00103\u001a\u00020#2\u0006\u00104\u001a\u000205R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001d\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001e\u001a\n \u001f*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00066"}, d2={"Lcom/xshare/wifi/viewmodel/WifiConnectViewModel;", "Lcom/xshare/base/viewmodel/BaseVMViewModel;", "()V", "createTime", "", "getCreateTime", "()J", "setCreateTime", "(J)V", "deviceMap", "Ljava/util/HashMap;", "", "Lcom/xshare/business/bean/wifi/WifiBleDeviceModel;", "Lkotlin/collections/HashMap;", "getDeviceMap", "()Ljava/util/HashMap;", "endTime", "isConnect", "", "()Z", "setConnect", "(Z)V", "oneTapAdapter", "Lcom/xshare/base/adapter/single/CommonBindVMAdapter;", "Lcom/xshare/business/bean/wifi/WifiInfoModel;", "getOneTapAdapter", "()Lcom/xshare/base/adapter/single/CommonBindVMAdapter;", "oneTapAdapter$delegate", "Lkotlin/Lazy;", "startTime", "tag", "kotlin.jvm.PlatformType", "getTag", "()Ljava/lang/String;", "connectNetWork", "", "context", "Landroid/content/Context;", "wifiDeviceBean", "Lcom/xshare/business/wifi/WifiDeviceBean;", "connectNetWork2", "wifiInfoModel", "connectWifiWithFourCode", "connectWifiWithOneTap", "connectWifiWithScan", "connectXsWifi", "connectXsWifiOnPermissionAllow", "getGateway", "getLocalIP", "longToIp", "ip", "updateBleList", "bleDevice", "Lcom/xshare/wifi/bluetooth/BleDevice;", "app_release"})
@DelicateCoroutinesApi
public final class WifiConnectViewModel
extends BaseVMViewModel {
    private final String tag = ((Object)((Object)this)).getClass().getSimpleName();
    private boolean isConnect;
    private long startTime;
    private long endTime;
    private long createTime;
    @NotNull
    private final Lazy oneTapAdapter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CommonBindVMAdapter<WifiInfoModel>>(this){
        final /* synthetic */ WifiConnectViewModel this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final CommonBindVMAdapter<WifiInfoModel> invoke() {
            return new CommonBindVMAdapter<WifiInfoModel>(this.this$0, (List)new ArrayList<E>(), R.layout.item_one_tap, BR.wifiViewModel, BR.item);
        }
    }));
    @NotNull
    private final HashMap<String, WifiBleDeviceModel> deviceMap = new HashMap();

    public final String getTag() {
        return this.tag;
    }

    public final boolean isConnect() {
        return this.isConnect;
    }

    public final void setConnect(boolean bl) {
        this.isConnect = bl;
    }

    public final long getCreateTime() {
        return this.createTime;
    }

    public final void setCreateTime(long l) {
        this.createTime = l;
    }

    @NotNull
    public final CommonBindVMAdapter<WifiInfoModel> getOneTapAdapter() {
        Lazy lazy = this.oneTapAdapter$delegate;
        return (CommonBindVMAdapter)((Object)lazy.getValue());
    }

    @NotNull
    public final HashMap<String, WifiBleDeviceModel> getDeviceMap() {
        return this.deviceMap;
    }

    public final void updateBleList(@NotNull BleDevice bleDevice) {
        Intrinsics.checkNotNullParameter((Object)bleDevice, (String)"bleDevice");
        String string2 = bleDevice.getN();
        String string3 = bleDevice.getI();
        String string4 = bleDevice.getW();
        String string5 = bleDevice.getC();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"bleDevice.c");
        int n = Integer.parseInt(string5);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"i");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"w");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"n");
        WifiInfoModel oneTapModel = new WifiInfoModel(0, string3, string4, null, 0, false, false, string2, 0, n, 0, 0, false, 0, null, 32121, null);
        String key = oneTapModel.getWifiSsid() + oneTapModel.getUserName() + oneTapModel.getUserIconIndex();
        if (this.deviceMap.containsKey(key)) {
            return;
        }
        WifiBleDeviceModel bleDevice2 = new WifiBleDeviceModel(key, System.currentTimeMillis(), System.currentTimeMillis());
        ((Map)this.deviceMap).put(key, bleDevice2);
        string4 = this.tag;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tag");
        WifiLog.INSTANCE.d(string4, Intrinsics.stringPlus((String)"ble found cost time = ", (Object)(bleDevice2.getDeviceFoundTime() - this.createTime)));
        this.getOneTapAdapter().addData(oneTapModel);
    }

    public final void connectWifiWithOneTap(@NotNull Context context, @NotNull WifiInfoModel wifiInfoModel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)wifiInfoModel, (String)"wifiInfoModel");
        wifiInfoModel.setLinkType(3);
        this.connectXsWifiOnPermissionAllow(context, wifiInfoModel);
    }

    public final void connectWifiWithScan(@NotNull Context context, @NotNull WifiInfoModel wifiInfoModel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)wifiInfoModel, (String)"wifiInfoModel");
        wifiInfoModel.setLinkType(1);
        this.connectXsWifiOnPermissionAllow(context, wifiInfoModel);
    }

    public final void connectWifiWithFourCode(@NotNull Context context, @NotNull WifiInfoModel wifiInfoModel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)wifiInfoModel, (String)"wifiInfoModel");
        wifiInfoModel.setLinkType(2);
        this.connectXsWifiOnPermissionAllow(context, wifiInfoModel);
    }

    public final void connectXsWifiOnPermissionAllow(@NotNull Context context, @NotNull WifiInfoModel wifiInfoModel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)wifiInfoModel, (String)"wifiInfoModel");
        PermissionsActivity.Companion.startPermissionsActivity(context, WifiConnectActivity.Companion.getPermissionList(), (Function0<Unit>)((Function0)new Function0<Unit>(this, context, wifiInfoModel){
            final /* synthetic */ WifiConnectViewModel this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ WifiInfoModel $wifiInfoModel;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$wifiInfoModel = $wifiInfoModel;
                super(0);
            }

            public final void invoke() {
                WifiConnectViewModel.access$connectXsWifi(this.this$0, this.$context, this.$wifiInfoModel);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            public final void invoke() {
                ToastUtil.INSTANCE.show(this.$context, "\u6743\u9650\u88ab\u62d2");
            }
        }));
    }

    private final void connectXsWifi(Context context, WifiInfoModel wifiInfoModel) {
        if (this.isConnect) {
            return;
        }
        wifiInfoModel.setSender(false);
        this.isConnect = true;
        this.startTime = System.currentTimeMillis();
        WiFiLog.getInstance().d(this.tag, "\u4ee5\u83b7\u53d6\u8db3\u591f\u6743\u9650");
        if (!this.connectNetWork2(context, wifiInfoModel)) {
            WifiDeviceBean wifiDeviceBean = new WifiDeviceBean();
            wifiDeviceBean.setClientId("gpa");
            wifiDeviceBean.setWifiSSID(wifiInfoModel.getWifiSsid());
            wifiDeviceBean.setPassword(wifiInfoModel.getWifiPwd());
            wifiDeviceBean.setChannel(wifiInfoModel.isUse5G() ? "5G" : "2.4G");
            this.connectNetWork(context, wifiDeviceBean);
        }
    }

    private final boolean connectNetWork2(Context context, WifiInfoModel wifiInfoModel) {
        WiFiLog.getInstance().d(this.tag, Intrinsics.stringPlus((String)"connectNetWork2, 2 Prama, wifiDeviceBean=", (Object)wifiInfoModel));
        WifiConnection connection = WifiConnection.getInstance(context);
        return connection.connect(wifiInfoModel.getWifiSsid(), wifiInfoModel.getWifiPwd(), new WifiConnection.Listener(this, connection, context){
            final /* synthetic */ WifiConnectViewModel this$0;
            final /* synthetic */ WifiConnection $connection;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
                this.$context = $context;
            }

            public void onStart() {
                String string2 = this.this$0.getTag();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                WifiLog.INSTANCE.d(string2, "connectNetWork2 onStart");
            }

            public void onFail(int reason) {
                this.this$0.setConnect(false);
                String string2 = this.this$0.getTag();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                WifiLog.INSTANCE.d(string2, Intrinsics.stringPlus((String)"connectNetWork2 onFail reason ", (Object)reason));
            }

            public void onSuccess(@Nullable InetAddress address) {
                this.this$0.setConnect(false);
                if (address != null) {
                    String string2 = this.this$0.getTag();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                    WifiLog.INSTANCE.d(string2, "connectNetWork2 onSuccess address = " + address.getHostAddress() + ' ');
                    WifiConnectViewModel.access$setEndTime$p(this.this$0, System.currentTimeMillis());
                    string2 = this.this$0.getTag();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                    WifiLog.INSTANCE.d(string2, Intrinsics.stringPlus((String)"wifi link cost time = ", (Object)(WifiConnectViewModel.access$getEndTime$p(this.this$0) - WifiConnectViewModel.access$getStartTime$p(this.this$0))));
                    this.$connection.stop();
                    String string3 = address.getHostAddress();
                    Intrinsics.checkNotNull((Object)string3);
                    WebServiceImpl.INSTANCE.setConnectIp(this.$context, string3, 6688);
                } else {
                    String gateWayAddress = this.this$0.longToIp(this.this$0.getGateway());
                    if (gateWayAddress != null) {
                        String string4 = this.this$0.getTag();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tag");
                        WifiLog.INSTANCE.d(string4, "connectNetWork2 onSuccess gateWayAddress = " + gateWayAddress + ' ');
                        this.$connection.stop();
                        WifiConnectViewModel.access$setEndTime$p(this.this$0, System.currentTimeMillis());
                        string4 = this.this$0.getTag();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tag");
                        WifiLog.INSTANCE.d(string4, Intrinsics.stringPlus((String)"wifi link cost time = ", (Object)(WifiConnectViewModel.access$getEndTime$p(this.this$0) - WifiConnectViewModel.access$getStartTime$p(this.this$0))));
                        WebServiceImpl.INSTANCE.setConnectIp(this.$context, gateWayAddress, 6688);
                    } else {
                        String string5 = this.this$0.getTag();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"tag");
                        WifiLog.INSTANCE.d(string5, "connectNetWork2 onFail reason address == null && gateWayAddress == null");
                    }
                }
            }
        });
    }

    private final synchronized void connectNetWork(Context context, WifiDeviceBean wifiDeviceBean) {
        WiFiLog.getInstance().d(this.tag, "connectNetWork");
        long netWorkStartTime = System.currentTimeMillis();
        XSWiFiManager.getInstance().releaseDefaultNetwork();
        XSWiFiManager.getInstance().addNetWork(wifiDeviceBean, new ConnectCallBack(this, context){
            final /* synthetic */ WifiConnectViewModel this$0;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void addNetSucceed(int netId) {
                String gateWayAddress;
                this.this$0.setConnect(false);
                String string2 = this.this$0.getTag();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                WifiLog.INSTANCE.d(string2, "connectNetWork addNetSucceed");
                String string3 = gateWayAddress = this.this$0.longToIp(this.this$0.getGateway());
                if (string3 != null) {
                    String string4 = string3;
                    Context context = this.$context;
                    String it = string4;
                    boolean bl = false;
                    WebServiceImpl.INSTANCE.setConnectIp(context, it, 6688);
                }
            }

            public void addNetFailed(@Nullable String msg) {
                this.this$0.setConnect(false);
                String string2 = this.this$0.getTag();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                WifiLog.INSTANCE.d(string2, Intrinsics.stringPlus((String)"connectNetWork addNetFailed msg = ", (Object)msg));
            }
        });
    }

    @Nullable
    public final String getLocalIP() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en != null && en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr != null && enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    String string2 = inetAddress.getHostAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"inetAddress.hostAddress");
                    if (!StringsKt.startsWith$default((String)string2, (String)"192.168", (boolean)false, (int)2, null)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)this.tag, (String)Intrinsics.stringPlus((String)"Can't getIP SocketException:", (Object)ex));
        }
        return "null";
    }

    public final long getGateway() {
        try {
            Context context;
            Context context2 = context = BaseApplication.Companion.getBaseApplication().getApplicationContext();
            if (context2 != null) {
                Context it = context2;
                boolean bl = false;
                Object object = it.getSystemService("wifi");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
                }
                WifiManager mWifiManager = (WifiManager)object;
                DhcpInfo dhcpInfo = mWifiManager.getDhcpInfo();
                Intrinsics.checkNotNullExpressionValue((Object)dhcpInfo, (String)"mWifiManager.getDhcpInfo()");
                DhcpInfo di = dhcpInfo;
                long gatewayIP = di.gateway;
                if (gatewayIP != 0L) {
                    return gatewayIP;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    @Nullable
    public final String longToIp(long ip) {
        StringBuffer sb = new StringBuffer();
        sb.append((int)(ip & 0xFFL));
        sb.append('.');
        sb.append((int)(ip >> 8 & 0xFFL));
        sb.append('.');
        sb.append((int)(ip >> 16 & 0xFFL));
        sb.append('.');
        sb.append((int)(ip >> 24 & 0xFFL));
        return sb.toString();
    }

    public static final /* synthetic */ void access$connectXsWifi(WifiConnectViewModel $this, Context context, WifiInfoModel wifiInfoModel) {
        $this.connectXsWifi(context, wifiInfoModel);
    }

    public static final /* synthetic */ void access$setEndTime$p(WifiConnectViewModel $this, long l) {
        $this.endTime = l;
    }

    public static final /* synthetic */ long access$getEndTime$p(WifiConnectViewModel $this) {
        return $this.endTime;
    }

    public static final /* synthetic */ long access$getStartTime$p(WifiConnectViewModel $this) {
        return $this.startTime;
    }
}

