/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.wifi.viewmodel;

import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.util.Log;
import androidx.databinding.ObservableInt;
import androidx.lifecycle.MutableLiveData;
import com.xshare.base.BaseApplication;
import com.xshare.base.viewmodel.BaseVMViewModel;
import com.xshare.business.bean.wifi.WifiInfoModel;
import com.xshare.business.utils.WiFiLog;
import com.xshare.business.wifi.ConnectCallBack;
import com.xshare.business.wifi.DirectConnect;
import com.xshare.business.wifi.WifiConnection;
import com.xshare.business.wifi.WifiDeviceBean;
import com.xshare.business.wifi.XSWiFiManager;
import com.xshare.wifi.WifiCreateManager;
import com.xshare.wifi.log.WifiLog;
import com.xshare.wifi.viewmodel.WifiCreateViewModel;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.DelicateCoroutinesApi;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u001aH\u0002J\u0016\u0010'\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u001aJ\u0016\u0010(\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020\fJ\u0006\u0010*\u001a\u00020\nJ\b\u0010+\u001a\u0004\u0018\u00010\u0013J\u0006\u0010,\u001a\u00020 J\u0010\u0010-\u001a\u0004\u0018\u00010\u00132\u0006\u0010.\u001a\u00020\nJ\u0006\u0010/\u001a\u00020 J'\u00100\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u001a2\f\u00101\u001a\b\u0012\u0004\u0012\u00020 02H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00064"}, d2={"Lcom/xshare/wifi/viewmodel/WifiCreateViewModel;", "Lcom/xshare/base/viewmodel/BaseVMViewModel;", "()V", "currentChannel", "Landroidx/databinding/ObservableInt;", "getCurrentChannel", "()Landroidx/databinding/ObservableInt;", "setCurrentChannel", "(Landroidx/databinding/ObservableInt;)V", "endTime", "", "isConnect", "", "()Z", "setConnect", "(Z)V", "startTime", "stopScan", "tag", "", "kotlin.jvm.PlatformType", "use5GChannel", "getUse5GChannel", "setUse5GChannel", "wifiInfoModel", "Landroidx/lifecycle/MutableLiveData;", "Lcom/xshare/business/bean/wifi/WifiInfoModel;", "getWifiInfoModel", "()Landroidx/lifecycle/MutableLiveData;", "setWifiInfoModel", "(Landroidx/lifecycle/MutableLiveData;)V", "changeFreqModel", "", "connectNetWork", "wifiDeviceBean", "Lcom/xshare/business/wifi/WifiDeviceBean;", "connectNetWork2", "context", "Landroid/content/Context;", "connectXsWifi", "createWifi", "use5G", "getGateway", "getLocalIP", "initDevice", "longToIp", "ip", "releaseWifi", "scanReceiver5GWifi", "findFun", "Lkotlin/Function0;", "(Lcom/xshare/business/bean/wifi/WifiInfoModel;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "app_release"})
@DelicateCoroutinesApi
public final class WifiCreateViewModel
extends BaseVMViewModel {
    private final String tag = ((Object)((Object)this)).getClass().getSimpleName();
    @NotNull
    private ObservableInt use5GChannel = new ObservableInt(2);
    @NotNull
    private ObservableInt currentChannel = new ObservableInt(2);
    @NotNull
    private MutableLiveData<WifiInfoModel> wifiInfoModel = new MutableLiveData();
    private boolean isConnect;
    private long startTime;
    private long endTime;
    private boolean stopScan;

    @NotNull
    public final ObservableInt getUse5GChannel() {
        return this.use5GChannel;
    }

    public final void setUse5GChannel(@NotNull ObservableInt observableInt) {
        Intrinsics.checkNotNullParameter((Object)observableInt, (String)"<set-?>");
        this.use5GChannel = observableInt;
    }

    @NotNull
    public final ObservableInt getCurrentChannel() {
        return this.currentChannel;
    }

    public final void setCurrentChannel(@NotNull ObservableInt observableInt) {
        Intrinsics.checkNotNullParameter((Object)observableInt, (String)"<set-?>");
        this.currentChannel = observableInt;
    }

    @NotNull
    public final MutableLiveData<WifiInfoModel> getWifiInfoModel() {
        return this.wifiInfoModel;
    }

    public final void setWifiInfoModel(@NotNull MutableLiveData<WifiInfoModel> mutableLiveData) {
        Intrinsics.checkNotNullParameter(mutableLiveData, (String)"<set-?>");
        this.wifiInfoModel = mutableLiveData;
    }

    public final boolean isConnect() {
        return this.isConnect;
    }

    public final void setConnect(boolean bl) {
        this.isConnect = bl;
    }

    public final void initDevice() {
        WifiCreateManager.INSTANCE.init();
        if (WifiCreateManager.INSTANCE.isDeviceSupport5G()) {
            this.use5GChannel.set(5);
            this.currentChannel.set(5);
        }
    }

    public final void changeFreqModel() {
        this.currentChannel.set(this.currentChannel.get() == 5 ? 2 : 5);
    }

    public final void createWifi(@NotNull Context context, boolean use5G) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WifiInfoModel sendWifiModel = new WifiInfoModel(0, null, null, null, 0, false, false, null, 0, 0, 0, 0, false, 0, null, Short.MAX_VALUE, null);
        sendWifiModel.initSenderCreateModel(use5G);
        WifiCreateManager.INSTANCE.createWifi(sendWifiModel, (Function1<? super WifiInfoModel, Unit>)((Function1)new Function1<WifiInfoModel, Unit>(this){
            final /* synthetic */ WifiCreateViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull WifiInfoModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getWifiInfoModel().postValue((Object)it);
            }
        }), (Function1<? super Integer, Unit>)((Function1)createWifi.2.INSTANCE));
    }

    public final void releaseWifi() {
        WifiCreateManager.INSTANCE.releaseWifi();
    }

    public final void connectXsWifi(@NotNull Context context, @NotNull WifiInfoModel wifiInfoModel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)wifiInfoModel, (String)"wifiInfoModel");
        if (this.isConnect) {
            return;
        }
        DirectConnect.retryCount = Integer.MAX_VALUE;
        this.isConnect = true;
        this.startTime = System.currentTimeMillis();
        WiFiLog.getInstance().d(this.tag, "\u4ee5\u83b7\u53d6\u8db3\u591f\u6743\u9650");
        if (!this.connectNetWork2(context, wifiInfoModel)) {
            WifiDeviceBean wifiDeviceBean = new WifiDeviceBean();
            wifiDeviceBean.setClientId("gpa");
            wifiDeviceBean.setWifiSSID(wifiInfoModel.getWifiSsid());
            wifiDeviceBean.setPassword(wifiInfoModel.getWifiPwd());
            wifiDeviceBean.setChannel(wifiInfoModel.isUse5G() ? "5G" : "2.4G");
            this.connectNetWork(new WifiDeviceBean());
        }
    }

    private final boolean connectNetWork2(Context context, WifiInfoModel wifiInfoModel) {
        WiFiLog.getInstance().d(this.tag, Intrinsics.stringPlus((String)"connectNetWork2, 2 Prama, wifiDeviceBean=", (Object)wifiInfoModel));
        WifiConnection connection = WifiConnection.getInstance(context);
        return connection.connect(wifiInfoModel.getWifiSsid(), wifiInfoModel.getWifiPwd(), new WifiConnection.Listener(this, connection){
            final /* synthetic */ WifiCreateViewModel this$0;
            final /* synthetic */ WifiConnection $connection;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
            }

            public void onStart() {
                String string2 = WifiCreateViewModel.access$getTag$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                WifiLog.INSTANCE.d(string2, "connectNetWork2 onStart");
            }

            public void onFail(int reason) {
                this.this$0.setConnect(false);
                String string2 = WifiCreateViewModel.access$getTag$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                WifiLog.INSTANCE.d(string2, Intrinsics.stringPlus((String)"connectNetWork2 onFail reason ", (Object)reason));
            }

            public void onSuccess(@Nullable InetAddress address) {
                this.this$0.setConnect(false);
                if (address != null) {
                    String string2 = WifiCreateViewModel.access$getTag$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                    WifiLog.INSTANCE.d(string2, "connectNetWork2 onSuccess address = " + address.getHostAddress() + ' ');
                    WifiCreateViewModel.access$setEndTime$p(this.this$0, System.currentTimeMillis());
                    string2 = WifiCreateViewModel.access$getTag$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                    WifiLog.INSTANCE.d(string2, Intrinsics.stringPlus((String)"wifi link cost time = ", (Object)(WifiCreateViewModel.access$getEndTime$p(this.this$0) - WifiCreateViewModel.access$getStartTime$p(this.this$0))));
                    this.$connection.stop();
                } else {
                    String gateWayAddress = this.this$0.longToIp(this.this$0.getGateway());
                    if (gateWayAddress != null) {
                        String string3 = WifiCreateViewModel.access$getTag$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"tag");
                        WifiLog.INSTANCE.d(string3, "connectNetWork2 onSuccess gateWayAddress = " + gateWayAddress + ' ');
                        this.$connection.stop();
                        WifiCreateViewModel.access$setEndTime$p(this.this$0, System.currentTimeMillis());
                        string3 = WifiCreateViewModel.access$getTag$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"tag");
                        WifiLog.INSTANCE.d(string3, Intrinsics.stringPlus((String)"wifi link cost time = ", (Object)(WifiCreateViewModel.access$getEndTime$p(this.this$0) - WifiCreateViewModel.access$getStartTime$p(this.this$0))));
                    } else {
                        String string4 = WifiCreateViewModel.access$getTag$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tag");
                        WifiLog.INSTANCE.d(string4, "connectNetWork2 onFail reason address == null && gateWayAddress == null");
                    }
                }
            }
        });
    }

    private final synchronized void connectNetWork(WifiDeviceBean wifiDeviceBean) {
        WiFiLog.getInstance().d(this.tag, "connectNetWork");
        long netWorkStartTime = System.currentTimeMillis();
        XSWiFiManager.getInstance().releaseDefaultNetwork();
        XSWiFiManager.getInstance().addNetWork(wifiDeviceBean, new ConnectCallBack(this){
            final /* synthetic */ WifiCreateViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void addNetSucceed(int netId) {
                this.this$0.setConnect(false);
                String string2 = WifiCreateViewModel.access$getTag$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                WifiLog.INSTANCE.d(string2, "connectNetWork addNetSucceed");
            }

            public void addNetFailed(@Nullable String msg) {
                this.this$0.setConnect(false);
                String string2 = WifiCreateViewModel.access$getTag$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
                WifiLog.INSTANCE.d(string2, Intrinsics.stringPlus((String)"connectNetWork addNetFailed msg = ", (Object)msg));
            }
        });
    }

    private final Object scanReceiver5GWifi(WifiInfoModel wifiInfoModel, Function0<Unit> findFun, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, wifiInfoModel, findFun, null){
            int label;
            final /* synthetic */ WifiCreateViewModel this$0;
            final /* synthetic */ WifiInfoModel $wifiInfoModel;
            final /* synthetic */ Function0<Unit> $findFun;
            {
                this.this$0 = $receiver;
                this.$wifiInfoModel = $wifiInfoModel;
                this.$findFun = $findFun;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                        // 2 sources

                        while (!WifiCreateViewModel.access$getStopScan$p(this.this$0)) {
                            XSWiFiManager.getInstance().getWifiManager().startScan();
                            this.label = 1;
                            v0 = DelayKt.delay((long)4000L, (Continuation)((Continuation)this));
                            if (v0 == var12_2) {
                                return var12_2;
                            }
                            ** GOTO lbl17
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        scanResults = XSWiFiManager.getInstance().getWifiManager().getScanResults();
                        Intrinsics.checkNotNullExpressionValue((Object)scanResults, (String)"scanResults");
                        var3_4 = scanResults;
                        var4_5 = this.$wifiInfoModel;
                        var5_6 = this.this$0;
                        var6_7 = this.$findFun;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (ScanResult)element$iv;
                            $i$a$-forEach-WifiCreateViewModel$scanReceiver5GWifi$2$1 = false;
                            if (!Intrinsics.areEqual((Object)var4_5.getWifiSsid(), (Object)it.SSID)) continue;
                            WifiCreateViewModel.access$setStopScan$p(var5_6, true);
                            var6_7.invoke();
                            XSWiFiManager.getInstance().releaseWifiP2P();
                            return Unit.INSTANCE;
                        }
                        ** GOTO lbl5
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final String getLocalIP() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en != null && en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr != null && enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    String string2 = inetAddress.getHostAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"inetAddress.hostAddress");
                    if (!StringsKt.startsWith$default((String)string2, (String)"192.168", (boolean)false, (int)2, null)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)this.tag, (String)Intrinsics.stringPlus((String)"Can't getIP SocketException:", (Object)ex));
        }
        return "null";
    }

    public final long getGateway() {
        try {
            Context context;
            Context context2 = context = BaseApplication.Companion.getBaseApplication().getApplicationContext();
            if (context2 != null) {
                Context it = context2;
                boolean bl = false;
                Object object = it.getSystemService("wifi");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
                }
                WifiManager mWifiManager = (WifiManager)object;
                DhcpInfo dhcpInfo = mWifiManager.getDhcpInfo();
                Intrinsics.checkNotNullExpressionValue((Object)dhcpInfo, (String)"mWifiManager.getDhcpInfo()");
                DhcpInfo di = dhcpInfo;
                long gatewayIP = di.gateway;
                if (gatewayIP != 0L) {
                    return gatewayIP;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    @Nullable
    public final String longToIp(long ip) {
        StringBuffer sb = new StringBuffer();
        sb.append((int)(ip & 0xFFL));
        sb.append('.');
        sb.append((int)(ip >> 8 & 0xFFL));
        sb.append('.');
        sb.append((int)(ip >> 16 & 0xFFL));
        sb.append('.');
        sb.append((int)(ip >> 24 & 0xFFL));
        return sb.toString();
    }

    public static final /* synthetic */ String access$getTag$p(WifiCreateViewModel $this) {
        return $this.tag;
    }

    public static final /* synthetic */ void access$setEndTime$p(WifiCreateViewModel $this, long l) {
        $this.endTime = l;
    }

    public static final /* synthetic */ long access$getEndTime$p(WifiCreateViewModel $this) {
        return $this.endTime;
    }

    public static final /* synthetic */ long access$getStartTime$p(WifiCreateViewModel $this) {
        return $this.startTime;
    }

    public static final /* synthetic */ Object access$scanReceiver5GWifi(WifiCreateViewModel $this, WifiInfoModel wifiInfoModel, Function0 findFun, Continuation $completion) {
        return $this.scanReceiver5GWifi(wifiInfoModel, (Function0<Unit>)findFun, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ boolean access$getStopScan$p(WifiCreateViewModel $this) {
        return $this.stopScan;
    }

    public static final /* synthetic */ void access$setStopScan$p(WifiCreateViewModel $this, boolean bl) {
        $this.stopScan = bl;
    }
}

