/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.body;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.ResponseBody;
import com.yanzhenjie.andserver.util.IOUtils;
import com.yanzhenjie.andserver.util.MediaType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileBody
implements ResponseBody {
    private File mBody;
    private String directoryPath;

    public FileBody(File body) {
        if (body == null) {
            throw new IllegalArgumentException("The file cannot be null.");
        }
        this.mBody = body;
    }

    public FileBody(File body, String directoryPath) {
        if (body == null) {
            throw new IllegalArgumentException("The file cannot be null.");
        }
        this.mBody = body;
        this.directoryPath = directoryPath;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long contentLength() {
        return this.mBody.length();
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return MediaType.getFileMediaType(this.mBody.getName());
    }

    @Override
    public void writeTo(@NonNull OutputStream output) throws IOException {
        FileInputStream is = new FileInputStream(this.mBody);
        if (!TextUtils.isEmpty((CharSequence)this.directoryPath)) {
            IOUtils.write(this.directoryPath, is, output, this.contentLength());
        } else {
            IOUtils.write(this.mBody.getAbsolutePath(), is, output, this.contentLength());
        }
        IOUtils.closeQuietly(is);
    }
}

