/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.body;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.ResponseBody;
import com.yanzhenjie.andserver.util.IOUtils;
import com.yanzhenjie.andserver.util.MediaType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamBody
implements ResponseBody {
    private InputStream mStream;
    private long mLength;
    private MediaType mMediaType;
    private String path;

    public StreamBody(String filePath, InputStream stream, long totalSize) {
        this(stream, MediaType.APPLICATION_OCTET_STREAM);
        this.mLength = totalSize;
        this.path = filePath;
    }

    public StreamBody(InputStream stream, long length) {
        this(stream, length, MediaType.APPLICATION_OCTET_STREAM);
    }

    public StreamBody(InputStream stream, MediaType mediaType) {
        this(stream, 0L, mediaType);
    }

    public StreamBody(InputStream stream, long length, MediaType mediaType) {
        this.mStream = stream;
        this.mLength = length;
        this.mMediaType = mediaType;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public long contentLength() {
        if (this.mLength == 0L && this.mStream instanceof FileInputStream) {
            try {
                this.mLength = ((FileInputStream)this.mStream).getChannel().size();
                return this.mLength;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.mLength;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.mMediaType;
    }

    @Override
    public void writeTo(@NonNull OutputStream output) throws IOException {
        if (TextUtils.isEmpty((CharSequence)this.path)) {
            IOUtils.write(this.mStream, output);
        } else {
            IOUtils.write(this.path, this.mStream, output, this.contentLength());
        }
        IOUtils.closeQuietly(this.mStream);
    }
}

