/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.handler;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.error.ContentNotAcceptableException;
import com.yanzhenjie.andserver.error.ContentNotSupportedException;
import com.yanzhenjie.andserver.error.HeaderValidateException;
import com.yanzhenjie.andserver.error.MethodNotSupportException;
import com.yanzhenjie.andserver.error.ParamValidateException;
import com.yanzhenjie.andserver.framework.handler.HandlerAdapter;
import com.yanzhenjie.andserver.framework.handler.OptionsHandler;
import com.yanzhenjie.andserver.framework.handler.RequestHandler;
import com.yanzhenjie.andserver.framework.mapping.Mapping;
import com.yanzhenjie.andserver.framework.mapping.Mime;
import com.yanzhenjie.andserver.framework.mapping.Pair;
import com.yanzhenjie.andserver.framework.mapping.Path;
import com.yanzhenjie.andserver.http.HttpMethod;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.util.MediaType;
import com.yanzhenjie.andserver.util.Patterns;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class MappingAdapter
implements HandlerAdapter,
Patterns {
    @Override
    public boolean intercept(@NonNull HttpRequest request) {
        Mime produce;
        Mime consume;
        Pair header;
        List<Path.Segment> pathSegments = Path.pathToList(request.getPath());
        List<Mapping> mappings = this.getExactMappings(pathSegments);
        if (mappings.isEmpty()) {
            mappings = this.getBlurredMappings(pathSegments);
        }
        if (mappings.isEmpty()) {
            return false;
        }
        HttpMethod method = request.getMethod();
        if (method.equals((Object)HttpMethod.OPTIONS)) {
            return true;
        }
        Mapping mapping = MappingAdapter.findMappingByMethod(mappings, method);
        if (mapping == null) {
            MethodNotSupportException exception = new MethodNotSupportException(method);
            List<HttpMethod> methods = MappingAdapter.findSupportMethods(mappings);
            exception.setMethods(methods);
            throw exception;
        }
        Pair param = mapping.getParam();
        if (param != null) {
            this.validateParams(param, request);
        }
        if ((header = mapping.getHeader()) != null) {
            this.validateHeaders(header, request);
        }
        if ((consume = mapping.getConsume()) != null) {
            this.validateConsume(consume, request);
        }
        if ((produce = mapping.getProduce()) != null) {
            this.validateProduce(produce, request);
        }
        return true;
    }

    @Override
    @Nullable
    public RequestHandler getHandler(@NonNull HttpRequest request) {
        List<Path.Segment> pathSegments = Path.pathToList(request.getPath());
        List<Mapping> mappings = this.getExactMappings(pathSegments);
        if (mappings.isEmpty()) {
            mappings = this.getBlurredMappings(pathSegments);
        }
        HttpMethod method = request.getMethod();
        Mapping mapping = MappingAdapter.findMappingByMethod(mappings, method);
        if (method.equals((Object)HttpMethod.OPTIONS) && mapping == null) {
            return new OptionsHandler(request, mappings, this.getMappingMap());
        }
        if (mapping == null) {
            return null;
        }
        Mime mime = mapping.getProduce();
        if (mime != null) {
            List<Mime.Rule> produces = mime.getRuleList();
            Mime.Rule mediaType = null;
            for (Mime.Rule produce : produces) {
                String text = produce.toString();
                if (text.startsWith("!")) continue;
                mediaType = produce;
                break;
            }
            request.setAttribute("http.response.Produce", mediaType);
        }
        return this.getMappingMap().get(mapping);
    }

    private List<Mapping> getExactMappings(List<Path.Segment> httpSegments) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        Map<Mapping, RequestHandler> mappingMap = this.getMappingMap();
        for (Mapping mapping : mappingMap.keySet()) {
            Path path = mapping.getPath();
            List<Path.Rule> rules = path.getRuleList();
            for (Path.Rule rule : rules) {
                if (!this.matchExactPath(rule.getSegments(), httpSegments)) continue;
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    private boolean matchExactPath(List<Path.Segment> segments, List<Path.Segment> httpSegments) {
        if (httpSegments.size() != segments.size()) {
            return false;
        }
        return Path.listToPath(segments).equals(Path.listToPath(httpSegments));
    }

    private List<Mapping> getBlurredMappings(List<Path.Segment> httpSegments) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        Map<Mapping, RequestHandler> mappingMap = this.getMappingMap();
        for (Mapping mapping : mappingMap.keySet()) {
            Path path = mapping.getPath();
            List<Path.Rule> rules = path.getRuleList();
            for (Path.Rule rule : rules) {
                if (!this.matchBlurredPath(rule.getSegments(), httpSegments)) continue;
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    private boolean matchBlurredPath(List<Path.Segment> segments, List<Path.Segment> httpSegments) {
        if (httpSegments.size() != segments.size()) {
            return false;
        }
        for (int i = 0; i < segments.size(); ++i) {
            Path.Segment segment = segments.get(i);
            if (segment.equals(httpSegments.get(i)) || segment.isBlurred()) continue;
            return false;
        }
        return true;
    }

    private void validateParams(Pair param, HttpRequest request) {
        List<Pair.Rule> rules = param.getRuleList();
        for (Pair.Rule rule : rules) {
            String key = rule.getKey();
            List<String> keys = request.getParameterNames();
            String value = rule.getValue();
            List<String> values = request.getParameters(key);
            if (rule.isNoKey()) {
                if (!keys.contains(key)) continue;
                throw new ParamValidateException(String.format("The parameter [%s] is not allowed.", key));
            }
            if (rule.isNoValue()) {
                if (!values.contains(value)) continue;
                throw new ParamValidateException(String.format("The value of parameter %s cannot be %s.", key, value));
            }
            if (!TextUtils.isEmpty((CharSequence)key) && !TextUtils.isEmpty((CharSequence)value)) {
                if (keys.contains(key) && values.contains(value)) continue;
                throw new ParamValidateException(String.format("The value of parameter %s is missing or wrong.", key));
            }
            if (TextUtils.isEmpty((CharSequence)key) || !TextUtils.isEmpty((CharSequence)value) || keys.contains(key)) continue;
            throw new ParamValidateException(String.format("The parameter %s is missing.", key));
        }
    }

    private void validateHeaders(Pair header, HttpRequest request) {
        List<Pair.Rule> rules = header.getRuleList();
        for (Pair.Rule rule : rules) {
            String key = rule.getKey();
            List<String> keys = request.getHeaderNames();
            String value = rule.getValue();
            List<String> values = request.getHeaders(key);
            if (rule.isNoKey()) {
                if (!keys.contains(key)) continue;
                throw new HeaderValidateException(String.format("The header [%s] is not allowed.", key));
            }
            if (rule.isNoValue()) {
                if (!values.contains(value)) continue;
                throw new HeaderValidateException(String.format("The value of header %s cannot be %s.", key, value));
            }
            if (!(TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value) || keys.contains(key) && values.contains(value))) {
                throw new HeaderValidateException(String.format("The value of header %s is missing or wrong.", key));
            }
            if (TextUtils.isEmpty((CharSequence)key) || !TextUtils.isEmpty((CharSequence)value) || keys.contains(key)) continue;
            throw new HeaderValidateException(String.format("The header %s is missing.", key));
        }
    }

    private void validateConsume(Mime mime, HttpRequest request) {
        List<Mime.Rule> rules = mime.getRuleList();
        MediaType contentType = request.getContentType();
        ArrayList<MediaType> includeType = new ArrayList<MediaType>();
        for (Mime.Rule rule : rules) {
            String type = rule.getType();
            boolean nonContent = type.startsWith("!");
            if (nonContent) {
                type = type.substring(1);
            }
            MediaType consume = new MediaType(type, rule.getSubtype());
            if (nonContent) {
                if (!consume.equalsExcludeParameter(contentType)) continue;
                throw new ContentNotSupportedException(contentType);
            }
            includeType.add(consume);
        }
        boolean included = false;
        for (MediaType mediaType : includeType) {
            if (!mediaType.includes(contentType)) continue;
            included = true;
            break;
        }
        if (!included) {
            throw new ContentNotSupportedException(contentType);
        }
    }

    private void validateProduce(Mime mime, HttpRequest request) {
        List<Mime.Rule> rules = mime.getRuleList();
        List<MediaType> accepts = request.getAccepts();
        for (Mime.Rule rule : rules) {
            String type = rule.getType();
            boolean nonContent = type.startsWith("!");
            if (nonContent) {
                type = type.substring(1);
            }
            MediaType produce = new MediaType(type, rule.getSubtype());
            boolean exclude = false;
            for (MediaType accept : accepts) {
                if (!accept.includes(produce)) continue;
                exclude = true;
            }
            if (nonContent && exclude) {
                throw new ContentNotAcceptableException();
            }
            if (nonContent || exclude) continue;
            throw new ContentNotAcceptableException();
        }
    }

    @NonNull
    protected abstract Map<Mapping, RequestHandler> getMappingMap();

    @NonNull
    protected abstract Object getHost();

    public static List<HttpMethod> findSupportMethods(List<Mapping> mappings) {
        ArrayList<HttpMethod> methods = new ArrayList<HttpMethod>();
        for (Mapping child : mappings) {
            methods.addAll(child.getMethod().getRuleList());
        }
        return methods;
    }

    public static Mapping findMappingByMethod(List<Mapping> mappings, HttpMethod method) {
        for (Mapping child : mappings) {
            if (!child.getMethod().getRuleList().contains((Object)method)) continue;
            return child;
        }
        return null;
    }
}

