/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.website;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yanzhenjie.andserver.framework.website.Website;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.util.Assert;
import com.yanzhenjie.andserver.util.MultiValueMap;
import java.io.File;
import java.util.List;
import java.util.Map;

public abstract class BasicWebsite
extends Website {
    public static final String DEFAULT_INDEX = "index.html";
    private final String mIndexFileName;

    public BasicWebsite() {
        this(DEFAULT_INDEX);
    }

    public BasicWebsite(@NonNull String indexFileName) {
        Assert.isTrue(!TextUtils.isEmpty((CharSequence)indexFileName), "The indexFileName cannot be empty.");
        this.mIndexFileName = indexFileName;
    }

    @Override
    public String getETag(@NonNull HttpRequest request) throws Throwable {
        return null;
    }

    @Override
    public long getLastModified(@NonNull HttpRequest request) throws Throwable {
        return -1L;
    }

    @NonNull
    protected final String getIndexFileName() {
        return this.mIndexFileName;
    }

    protected String addStartSlash(@NonNull String target) {
        if (!target.startsWith(File.separator)) {
            target = File.separator + target;
        }
        return target;
    }

    protected String addEndSlash(@NonNull String target) {
        if (!target.endsWith(File.separator)) {
            target = target + File.separator;
        }
        return target;
    }

    protected String trimStartSlash(@NonNull String target) {
        while (target.startsWith(File.separator)) {
            target = target.substring(1);
        }
        return target;
    }

    protected String trimEndSlash(@NonNull String target) {
        while (target.endsWith(File.separator)) {
            target = target.substring(0, target.length() - 1);
        }
        return target;
    }

    protected String trimSlash(@NonNull String target) {
        target = this.trimStartSlash(target);
        target = this.trimEndSlash(target);
        return target;
    }

    protected String queryString(HttpRequest request) {
        MultiValueMap<String, String> query = request.getQuery();
        if (query.isEmpty()) {
            return "";
        }
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry entry : query.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (values == null || values.isEmpty()) continue;
            for (int i = 0; i < values.size(); ++i) {
                queryString.append("&").append(key).append("=").append((String)values.get(i));
            }
        }
        if (queryString.length() > 0) {
            queryString.deleteCharAt(0);
        }
        return queryString.toString();
    }
}

