/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http;

import java.util.Locale;

public enum HttpMethod {
    GET("GET"),
    HEAD("HEAD"),
    POST("POST"),
    PUT("PUT"),
    PATCH("PATCH"),
    DELETE("DELETE"),
    OPTIONS("OPTIONS"),
    TRACE("TRACE");

    private String value;

    private HttpMethod(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public boolean allowBody() {
        switch (this) {
            case POST: 
            case PUT: 
            case PATCH: 
            case DELETE: {
                return true;
            }
        }
        return false;
    }

    public static HttpMethod reverse(String method) {
        switch (method = method.toUpperCase(Locale.ENGLISH)) {
            case "GET": {
                return GET;
            }
            case "HEAD": {
                return HEAD;
            }
            case "POST": {
                return POST;
            }
            case "PUT": {
                return PUT;
            }
            case "PATCH": {
                return PATCH;
            }
            case "DELETE": {
                return DELETE;
            }
            case "OPTIONS": {
                return OPTIONS;
            }
            case "TRACE": {
                return TRACE;
            }
        }
        String message = String.format("The value %1$s is not supported.", method);
        throw new UnsupportedOperationException(message);
    }

    public String toString() {
        return this.value;
    }
}

