/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.HttpResponse;
import com.yanzhenjie.andserver.http.ResponseBody;
import com.yanzhenjie.andserver.http.cookie.Cookie;
import com.yanzhenjie.andserver.http.cookie.CookieProcessor;
import com.yanzhenjie.andserver.http.cookie.StandardCookieProcessor;
import com.yanzhenjie.andserver.util.HttpDateFormat;
import com.yanzhenjie.andserver.util.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.httpcore.Header;
import org.apache.httpcore.HttpEntity;
import org.apache.httpcore.message.BasicHeader;

public class StandardResponse
implements HttpResponse {
    private static final CookieProcessor COOKIE_PROCESSOR = new StandardCookieProcessor();
    private org.apache.httpcore.HttpResponse mResponse;

    public StandardResponse(org.apache.httpcore.HttpResponse response) {
        this.mResponse = response;
    }

    @Override
    public void setStatus(int sc) {
        this.mResponse.setStatusCode(sc);
    }

    @Override
    public int getStatus() {
        return this.mResponse.getStatusLine().getStatusCode();
    }

    @Override
    public void setHeader(@NonNull String name, @NonNull String value) {
        this.mResponse.setHeader(name, value);
    }

    @Override
    public void addHeader(@NonNull String name, @NonNull String value) {
        this.mResponse.addHeader(name, value);
    }

    @Override
    @Nullable
    public String getHeader(@NonNull String name) {
        Header header = this.mResponse.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    @Override
    public void setDateHeader(@NonNull String name, long date) {
        this.setHeader(name, HttpDateFormat.formatDate(date));
    }

    @Override
    public void addDateHeader(@NonNull String name, long date) {
        this.addHeader(name, HttpDateFormat.formatDate(date));
    }

    @Override
    public void setIntHeader(@NonNull String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    @Override
    public void addIntHeader(@NonNull String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    @Override
    public boolean containsHeader(@NonNull String name) {
        return this.mResponse.containsHeader(name);
    }

    @Override
    @NonNull
    public List<String> getHeaders(@NonNull String name) {
        Header[] headers = this.mResponse.getHeaders(name);
        if (headers == null || headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Header header : headers) {
            list.add(header.getValue());
        }
        return list;
    }

    @Override
    @NonNull
    public List<String> getHeaderNames() {
        Header[] headers = this.mResponse.getAllHeaders();
        if (headers == null || headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Header header : headers) {
            list.add(header.getName());
        }
        return list;
    }

    @Override
    public void addCookie(@NonNull Cookie cookie) {
        this.addHeader("Set-Cookie", COOKIE_PROCESSOR.generateHeader(cookie));
    }

    @Override
    public void sendRedirect(@NonNull String location) {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    @Override
    public void setBody(ResponseBody body) {
        this.mResponse.setEntity((HttpEntity)new BodyToEntity(body));
    }

    private static class BodyToEntity
    implements HttpEntity {
        private ResponseBody mBody;

        private BodyToEntity(ResponseBody body) {
            this.mBody = body;
        }

        public boolean isRepeatable() {
            return false;
        }

        public boolean isChunked() {
            return false;
        }

        public long getContentLength() {
            return this.mBody.contentLength();
        }

        public Header getContentType() {
            MediaType mimeType = this.mBody.contentType();
            if (mimeType == null) {
                return null;
            }
            return new BasicHeader("Content-Type", mimeType.toString());
        }

        public Header getContentEncoding() {
            return null;
        }

        public InputStream getContent() throws IOException {
            return null;
        }

        public void writeTo(OutputStream out) throws IOException {
            this.mBody.writeTo(out);
        }

        public boolean isStreaming() {
            return false;
        }

        public void consumeContent() {
        }
    }
}

