/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http.session;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.session.Session;
import com.yanzhenjie.andserver.util.Assert;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StandardSession
implements Session {
    private static final String[] EMPTY_ARRAY = new String[0];
    private String id;
    private long createdTime;
    private long lastAccessedTime;
    private int maxInactiveInterval = -1;
    private Map<String, Object> mAttributes = new ConcurrentHashMap<String, Object>();
    private boolean isNew;
    private boolean isValid;

    public void setId(@NonNull String id2) {
        if (TextUtils.isEmpty((CharSequence)id2)) {
            throw new IllegalArgumentException("The id can not be empty or null.");
        }
        this.id = id2;
    }

    @Override
    @NonNull
    public String getId() {
        return this.id;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    @Override
    public long getLastAccessedTime() {
        this.validate();
        return this.lastAccessedTime;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public Object getAttribute(@Nullable String name) {
        this.validate();
        if (name == null) {
            return null;
        }
        return this.mAttributes.get(name);
    }

    @Override
    @NonNull
    public Enumeration<String> getAttributeNames() {
        this.validate();
        return Collections.enumeration(new HashSet<String>(this.mAttributes.keySet()));
    }

    @Override
    public void setAttribute(@NonNull String name, @Nullable Object value) {
        this.validate();
        Assert.notNull(name, "The name cannot be null.");
        if (value == null) {
            return;
        }
        this.mAttributes.put(name, value);
    }

    @Override
    public void removeAttribute(@Nullable String name) {
        this.validate();
        if (name == null) {
            return;
        }
        this.mAttributes.remove(name);
    }

    @Override
    public void invalidate() {
        this.validate();
        this.isValid = false;
    }

    public void setNew(boolean aNew) {
        this.isNew = aNew;
    }

    @Override
    public boolean isNew() {
        this.validate();
        return this.isNew;
    }

    private void validate() {
        if (!this.isValid()) {
            throw new IllegalStateException("This session is invalid.");
        }
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    @Override
    public boolean isValid() {
        if (!this.isValid) {
            return false;
        }
        if (this.maxInactiveInterval > 0) {
            long inactiveInterval = System.currentTimeMillis() - this.lastAccessedTime;
            int timeIdle = (int)(inactiveInterval / 1000L);
            if (timeIdle >= this.maxInactiveInterval) {
                this.isValid = false;
            }
        } else {
            this.isValid = true;
        }
        return this.isValid;
    }

    public void writeObject(@NonNull ObjectOutputStream stream) throws IOException {
        String[] keys;
        stream.writeObject(this.id);
        stream.writeLong(this.createdTime);
        stream.writeLong(this.lastAccessedTime);
        stream.writeInt(this.maxInactiveInterval);
        stream.writeBoolean(this.isNew);
        stream.writeBoolean(this.isValid);
        stream.writeInt(this.mAttributes.size());
        for (String key : keys = this.mAttributes.keySet().toArray(EMPTY_ARRAY)) {
            Object value = this.mAttributes.get(key);
            if (value == null || !(value instanceof Serializable)) continue;
            stream.writeObject(key);
            stream.writeObject(value);
        }
    }

    public void readObject(@NonNull ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.id = (String)stream.readObject();
        this.createdTime = stream.readLong();
        this.lastAccessedTime = stream.readLong();
        this.maxInactiveInterval = stream.readInt();
        this.isNew = stream.readBoolean();
        this.isValid = stream.readBoolean();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            String name = (String)stream.readObject();
            Object value = stream.readObject();
            this.mAttributes.put(name, value);
        }
    }
}

