/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http.session;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.session.IdGenerator;
import com.yanzhenjie.andserver.http.session.Session;
import com.yanzhenjie.andserver.http.session.SessionManager;
import com.yanzhenjie.andserver.http.session.StandardIdGenerator;
import com.yanzhenjie.andserver.http.session.StandardSession;
import com.yanzhenjie.andserver.http.session.StandardStore;
import com.yanzhenjie.andserver.http.session.Store;
import java.io.File;
import java.io.IOException;

public class StandardSessionManager
implements SessionManager {
    private IdGenerator mIdGenerator = new StandardIdGenerator();
    private Store mStore;

    public StandardSessionManager(Context context) {
        File sessionDir = new File(context.getCacheDir(), "_andserver_session_");
        this.mStore = new StandardStore(sessionDir);
    }

    @Override
    public void add(@NonNull Session session) throws IOException {
        if (session instanceof StandardSession && session.isNew()) {
            StandardSession standardSession = (StandardSession)session;
            standardSession.setNew(false);
            this.mStore.replace(standardSession);
        }
    }

    @Override
    public void changeSessionId(@NonNull Session session) {
        if (session instanceof StandardSession) {
            StandardSession standardSession = (StandardSession)session;
            standardSession.setId(this.mIdGenerator.generateId());
        }
    }

    @Override
    @NonNull
    public Session createSession() {
        StandardSession session = this.newSession();
        session.setId(this.mIdGenerator.generateId());
        return session;
    }

    @Override
    @Nullable
    public Session findSession(@NonNull String id2) throws IOException, ClassNotFoundException {
        StandardSession session = this.mStore.getSession(id2);
        if (session != null) {
            session.setLastAccessedTime(System.currentTimeMillis());
        }
        return session;
    }

    @Override
    public void remove(@NonNull Session session) {
        if (session instanceof StandardSession) {
            this.mStore.remove((StandardSession)session);
        }
    }

    private StandardSession newSession() {
        StandardSession session = new StandardSession();
        long currentTime = System.currentTimeMillis();
        session.setCreatedTime(currentTime);
        session.setLastAccessedTime(currentTime);
        session.setNew(true);
        session.setValid(true);
        return session;
    }
}

