/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http.session;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.session.StandardSession;
import com.yanzhenjie.andserver.http.session.Store;
import com.yanzhenjie.andserver.util.Assert;
import com.yanzhenjie.andserver.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class StandardStore
implements Store {
    private File mDirectory;

    public StandardStore(File directory) {
        this.mDirectory = directory;
    }

    @Override
    public boolean replace(@NonNull StandardSession session) throws IOException {
        Assert.notNull(session, "The session can not be null.");
        String id2 = session.getId();
        if (TextUtils.isEmpty((CharSequence)id2)) {
            throw new IllegalStateException("The session id can not be empty or null.");
        }
        ObjectOutputStream writer = null;
        try {
            if (!IOUtils.createFolder(this.mDirectory)) {
                boolean bl = false;
                return bl;
            }
            File file = new File(this.mDirectory, id2);
            if (!IOUtils.createNewFile(file)) {
                boolean bl = false;
                return bl;
            }
            writer = new ObjectOutputStream(new FileOutputStream(file));
            session.writeObject(writer);
            boolean bl = true;
            IOUtils.closeQuietly(writer);
            return bl;
        }
        catch (IOException e) {
            IOUtils.delFileOrFolder(new File(this.mDirectory, id2));
            throw e;
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    @Override
    @Nullable
    public StandardSession getSession(@NonNull String id2) throws IOException, ClassNotFoundException {
        if (TextUtils.isEmpty((CharSequence)id2)) {
            throw new IllegalArgumentException("The id can not be empty or null.");
        }
        ObjectInputStream reader = null;
        try {
            File file = new File(this.mDirectory, id2);
            if (!file.exists() || file.isDirectory()) {
                StandardSession standardSession = null;
                return standardSession;
            }
            reader = new ObjectInputStream(new FileInputStream(file));
            StandardSession session = new StandardSession();
            session.readObject(reader);
            StandardSession standardSession = session;
            IOUtils.closeQuietly(reader);
            return standardSession;
        }
        catch (IOException e) {
            IOUtils.delFileOrFolder(new File(this.mDirectory, id2));
            throw e;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    @Override
    public boolean remove(@NonNull StandardSession session) {
        String id2 = session.getId();
        if (TextUtils.isEmpty((CharSequence)id2)) {
            throw new IllegalStateException("The session id can not be empty or null.");
        }
        return IOUtils.delFileOrFolder(new File(this.mDirectory, session.getId()));
    }
}

