/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.server;

import androidx.annotation.NonNull;
import com.yanzhenjie.andserver.AndServer;
import com.yanzhenjie.andserver.ProxyHandler;
import com.yanzhenjie.andserver.SSLSocketInitializer;
import com.yanzhenjie.andserver.Server;
import com.yanzhenjie.andserver.server.BasicServer;
import com.yanzhenjie.andserver.util.Executors;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import org.apache.httpcore.ConnectionClosedException;
import org.apache.httpcore.HttpException;
import org.apache.httpcore.HttpHost;
import org.apache.httpcore.HttpResponseInterceptor;
import org.apache.httpcore.HttpServerConnection;
import org.apache.httpcore.impl.DefaultBHttpClientConnection;
import org.apache.httpcore.impl.DefaultBHttpServerConnection;
import org.apache.httpcore.protocol.BasicHttpContext;
import org.apache.httpcore.protocol.HttpContext;
import org.apache.httpcore.protocol.HttpCoreContext;
import org.apache.httpcore.protocol.HttpProcessor;
import org.apache.httpcore.protocol.HttpRequestHandler;
import org.apache.httpcore.protocol.HttpRequestHandlerMapper;
import org.apache.httpcore.protocol.HttpService;
import org.apache.httpcore.protocol.ImmutableHttpProcessor;
import org.apache.httpcore.protocol.ResponseConnControl;
import org.apache.httpcore.protocol.ResponseContent;
import org.apache.httpcore.protocol.ResponseDate;
import org.apache.httpcore.protocol.ResponseServer;
import org.apache.httpcore.protocol.UriHttpRequestHandlerMapper;

public class ProxyServer
extends BasicServer<Builder> {
    public static final String PROXY_CONN_CLIENT = "http.proxy.conn.client";
    public static final String PROXY_CONN_ALIVE = "http.proxy.conn.alive";
    private final InetAddress mInetAddress;
    private final int mPort;
    private final int mTimeout;
    private final ServerSocketFactory mSocketFactory;
    private final SSLContext mSSLContext;
    private final SSLSocketInitializer mSSLSocketInitializer;
    private final Server.ServerListener mListener;
    private Map<String, HttpHost> mHostList;
    private HttpServer mHttpServer;
    private boolean isRunning;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ProxyServer(Builder builder) {
        super(builder);
        this.mInetAddress = builder.inetAddress;
        this.mPort = builder.port;
        this.mTimeout = builder.timeout;
        this.mSocketFactory = builder.mSocketFactory;
        this.mSSLContext = builder.sslContext;
        this.mSSLSocketInitializer = builder.mSSLSocketInitializer;
        this.mListener = builder.listener;
        this.mHostList = builder.mHostList;
    }

    @Override
    protected HttpRequestHandler requestHandler() {
        return new ProxyHandler(this.mHostList);
    }

    @Override
    public void startup() {
        if (this.isRunning) {
            return;
        }
        Executors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                ServerSocketFactory socketFactory = ProxyServer.this.mSocketFactory;
                if (socketFactory == null) {
                    socketFactory = ProxyServer.this.mSSLContext != null ? ProxyServer.this.mSSLContext.getServerSocketFactory() : ServerSocketFactory.getDefault();
                }
                ProxyServer.this.mHttpServer = new HttpServer(ProxyServer.this.mInetAddress, ProxyServer.this.mPort, ProxyServer.this.mTimeout, socketFactory, ProxyServer.this.mSSLSocketInitializer, ProxyServer.this.requestHandler());
                try {
                    ProxyServer.this.mHttpServer.startServer();
                    ProxyServer.this.isRunning = true;
                    Executors.getInstance().post(new Runnable(){

                        @Override
                        public void run() {
                            if (ProxyServer.this.mListener != null) {
                                ProxyServer.this.mListener.onStarted();
                            }
                        }
                    });
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            ProxyServer.this.mHttpServer.stopServer();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void shutdown() {
        if (!this.isRunning) {
            return;
        }
        Executors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (ProxyServer.this.mHttpServer != null) {
                    ProxyServer.this.mHttpServer.stopServer();
                    ProxyServer.this.isRunning = false;
                    Executors.getInstance().post(new Runnable(){

                        @Override
                        public void run() {
                            if (ProxyServer.this.mListener != null) {
                                ProxyServer.this.mListener.onStopped();
                            }
                        }
                    });
                }
            }
        });
    }

    private static class ThreadFactoryImpl
    implements ThreadFactory {
        private final String mPrefix;
        private final ThreadGroup mGroup;
        private final AtomicLong mCount;

        ThreadFactoryImpl(String prefix, ThreadGroup group) {
            this.mPrefix = prefix;
            this.mGroup = group;
            this.mCount = new AtomicLong();
        }

        ThreadFactoryImpl(String mPrefix) {
            this(mPrefix, null);
        }

        @Override
        public Thread newThread(@NonNull Runnable target) {
            return new Thread(this.mGroup, target, this.mPrefix + "-" + this.mCount.incrementAndGet());
        }
    }

    private static class Worker
    implements Runnable {
        private final HttpService mHttpService;
        private final DefaultBHttpServerConnection mServerConn;
        private final DefaultBHttpClientConnection mClientConn;

        public Worker(HttpService httpservice, DefaultBHttpServerConnection serverConn, DefaultBHttpClientConnection clientConn) {
            this.mHttpService = httpservice;
            this.mServerConn = serverConn;
            this.mClientConn = clientConn;
        }

        public DefaultBHttpServerConnection getServerConn() {
            return this.mServerConn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BasicHttpContext localContext = new BasicHttpContext();
            HttpCoreContext context = HttpCoreContext.adapt((HttpContext)localContext);
            context.setAttribute(ProxyServer.PROXY_CONN_CLIENT, (Object)this.mClientConn);
            try {
                while (!Thread.interrupted()) {
                    if (!this.mServerConn.isOpen()) {
                        this.mClientConn.close();
                    } else {
                        this.mHttpService.handleRequest((HttpServerConnection)this.mServerConn, (HttpContext)context);
                        Boolean keepAlive = (Boolean)context.getAttribute(ProxyServer.PROXY_CONN_ALIVE);
                        if (Boolean.TRUE.equals(keepAlive)) continue;
                        this.mClientConn.close();
                        this.mServerConn.close();
                    }
                    break;
                }
            }
            catch (ConnectionClosedException ex) {
                System.err.println("Client closed connection.");
            }
            catch (IOException ex) {
                System.err.println("I/O error: " + ex.getMessage());
            }
            catch (HttpException ex) {
                System.err.println("Unrecoverable HTTP protocol violation: " + ex.getMessage());
            }
            finally {
                try {
                    this.mServerConn.shutdown();
                }
                catch (IOException ex) {}
                try {
                    this.mClientConn.shutdown();
                }
                catch (IOException ex) {}
            }
        }
    }

    private static class HttpServer
    implements Runnable {
        private final InetAddress mInetAddress;
        private final int mPort;
        private final int mTimeout;
        private final ServerSocketFactory mSocketFactory;
        private final SSLSocketInitializer mSSLSocketInitializer;
        private final HttpRequestHandler mHandler;
        private final ThreadPoolExecutor mServerExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryImpl("HTTP-Server-"));
        private final ThreadGroup mWorkerThreads = new ThreadGroup("HTTP-workers");
        private final ThreadPoolExecutor mWorkerExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue(), new ThreadFactoryImpl("HTTP-Handlers-", this.mWorkerThreads)){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                if (r instanceof Worker) {
                    mWorkerSet.put((Worker)r, Boolean.TRUE);
                }
            }

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                if (r instanceof Worker) {
                    mWorkerSet.remove(r);
                }
            }
        };
        private final Map<Worker, Boolean> mWorkerSet = new ConcurrentHashMap<Worker, Boolean>();
        private HttpService mHttpService;
        private ServerSocket mServerSocket;

        public HttpServer(InetAddress inetAddress, int port, int timeout, ServerSocketFactory socketFactory, SSLSocketInitializer sslSocketInitializer, HttpRequestHandler handler) {
            this.mInetAddress = inetAddress;
            this.mPort = port;
            this.mTimeout = timeout;
            this.mSocketFactory = socketFactory;
            this.mSSLSocketInitializer = sslSocketInitializer;
            this.mHandler = handler;
            ImmutableHttpProcessor inProcessor = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(AndServer.INFO), new ResponseContent(), new ResponseConnControl()});
            UriHttpRequestHandlerMapper mapper = new UriHttpRequestHandlerMapper();
            mapper.register("*", this.mHandler);
            this.mHttpService = new HttpService((HttpProcessor)inProcessor, (HttpRequestHandlerMapper)mapper);
        }

        public void startServer() throws IOException {
            this.mServerSocket = this.mSocketFactory.createServerSocket();
            this.mServerSocket.setReuseAddress(true);
            this.mServerSocket.bind(new InetSocketAddress(this.mInetAddress, this.mPort), 8192);
            this.mServerSocket.setReceiveBufferSize(8192);
            if (this.mSSLSocketInitializer != null && this.mServerSocket instanceof SSLServerSocket) {
                this.mSSLSocketInitializer.onCreated((SSLServerSocket)this.mServerSocket);
            }
            this.mServerExecutor.execute(this);
        }

        public void stopServer() {
            this.mServerExecutor.shutdown();
            this.mWorkerExecutor.shutdown();
            try {
                this.mServerSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mWorkerThreads.interrupt();
            try {
                this.mWorkerExecutor.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            Set<Worker> workers = this.mWorkerSet.keySet();
            for (Worker worker : workers) {
                DefaultBHttpServerConnection conn = worker.getServerConn();
                try {
                    conn.shutdown();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    Socket socket = this.mServerSocket.accept();
                    socket.setSoTimeout(this.mTimeout);
                    socket.setKeepAlive(true);
                    socket.setTcpNoDelay(true);
                    socket.setReceiveBufferSize(8192);
                    socket.setSendBufferSize(8192);
                    socket.setSoLinger(true, 0);
                    DefaultBHttpServerConnection serverConn = new DefaultBHttpServerConnection(8192);
                    serverConn.bind(socket);
                    DefaultBHttpClientConnection clientConn = new DefaultBHttpClientConnection(8192);
                    Worker worker = new Worker(this.mHttpService, serverConn, clientConn);
                    this.mWorkerExecutor.execute(worker);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class Builder
    extends BasicServer.Builder<Builder, ProxyServer>
    implements Server.ProxyBuilder<Builder, ProxyServer> {
        private Map<String, HttpHost> mHostList = new HashMap<String, HttpHost>();

        @Override
        public Builder addProxy(String hostName, String proxyHost) {
            this.mHostList.put(hostName.toLowerCase(Locale.ROOT), HttpHost.create((String)proxyHost));
            return this;
        }

        @Override
        public ProxyServer build() {
            return new ProxyServer(this);
        }
    }
}

