/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class HttpDateFormat {
    private static final String RFC1123_DATE = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final SimpleDateFormat[] FORMATS_TEMPLATE = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    private static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentDate() {
        SimpleDateFormat simpleDateFormat = FORMAT;
        synchronized (simpleDateFormat) {
            long now = System.currentTimeMillis();
            return FORMAT.format(new Date(now));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(long value) {
        Class<HttpDateFormat> clazz = HttpDateFormat.class;
        synchronized (HttpDateFormat.class) {
            Date dateValue = new Date(value);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return FORMAT.format(dateValue);
        }
    }

    public static long parseDate(String value) {
        Date date = null;
        for (SimpleDateFormat format : FORMATS_TEMPLATE) {
            try {
                date = format.parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            return -1L;
        }
        return date.getTime();
    }

    static {
        FORMAT.setTimeZone(GMT_ZONE);
    }
}

