/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.util;

import android.os.Build;
import android.os.StatFs;
import android.text.TextUtils;
import androidx.lifecycle.MutableLiveData;
import com.yanzhenjie.andserver.bean.ProgressBean;
import com.yanzhenjie.andserver.util.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class IOUtils {
    private static final byte[] EMPTY_CONTENT = new byte[0];
    public static MutableLiveData<ProgressBean> progress = new MutableLiveData();

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void flushQuietly(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static BufferedInputStream toBufferedInputStream(InputStream inputStream) {
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public static BufferedOutputStream toBufferedOutputStream(OutputStream outputStream) {
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedWriter toBufferedWriter(Writer writer) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public static InputStream toInputStream(CharSequence input) {
        return new ByteArrayInputStream(input.toString().getBytes());
    }

    public static InputStream toInputStream(CharSequence input, String charset) {
        return IOUtils.toInputStream(input, Charset.forName(charset));
    }

    public static InputStream toInputStream(CharSequence input, Charset charset) {
        byte[] bytes = input.toString().getBytes(charset);
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream createEmptyInput() {
        return new ByteArrayInputStream(EMPTY_CONTENT);
    }

    public static InputStream toNonClosing(InputStream in) {
        Assert.notNull(in, "No InputStream specified");
        return new NonClosingInputStream(in);
    }

    public static OutputStream toNonClosing(OutputStream out) {
        Assert.notNull(out, "No OutputStream specified.");
        return new NonClosingOutputStream(out);
    }

    public static String toString(InputStream input) throws IOException {
        return new String(IOUtils.toByteArray(input));
    }

    public static String toString(InputStream input, String charset) throws IOException {
        return new String(IOUtils.toByteArray(input), charset);
    }

    public static String toString(InputStream input, Charset charset) throws IOException {
        return new String(IOUtils.toByteArray(input), charset);
    }

    public static String toString(Reader input) throws IOException {
        return new String(IOUtils.toByteArray(input));
    }

    public static String toString(Reader input, String charset) throws IOException {
        return new String(IOUtils.toByteArray(input), charset);
    }

    public static String toString(Reader input, Charset charset) throws IOException {
        return new String(IOUtils.toByteArray(input), charset);
    }

    public static String toString(byte[] byteArray) {
        return new String(byteArray);
    }

    public static String toString(byte[] byteArray, String charset) {
        return IOUtils.toString(byteArray, Charset.forName(charset));
    }

    public static String toString(byte[] byteArray, Charset charset) {
        return new String(byteArray, charset);
    }

    public static byte[] toByteArray(CharSequence input) {
        if (input == null) {
            return new byte[0];
        }
        return input.toString().getBytes();
    }

    public static byte[] toByteArray(CharSequence input, String charset) {
        return IOUtils.toByteArray(input, Charset.forName(charset));
    }

    public static byte[] toByteArray(CharSequence input, Charset charset) {
        if (input == null) {
            return new byte[0];
        }
        return input.toString().getBytes(charset);
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.write(input, (OutputStream)output);
        output.close();
        return output.toByteArray();
    }

    public static byte[] toByteArray(InputStream input, int size) throws IOException {
        int offset;
        int byteCount;
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return new byte[0];
        }
        byte[] data = new byte[size];
        for (offset = 0; offset < size && (byteCount = input.read(data, offset, size - offset)) != -1; offset += byteCount) {
        }
        if (offset != size) {
            throw new IOException("Unexpected byte count size. current: " + offset + ", excepted: " + size);
        }
        return data;
    }

    public static byte[] toByteArray(Reader input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.write(input, (OutputStream)output);
        output.close();
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input, String charset) throws IOException {
        return IOUtils.toByteArray(input, Charset.forName(charset));
    }

    public static byte[] toByteArray(Reader input, Charset charset) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.write(input, (OutputStream)output, charset);
        output.close();
        return output.toByteArray();
    }

    public static char[] toCharArray(CharSequence input) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.write((Writer)output, input);
        return output.toCharArray();
    }

    public static char[] toCharArray(InputStream input) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.write(input, (Writer)output);
        return output.toCharArray();
    }

    public static char[] toCharArray(InputStream input, String charset) throws IOException {
        return IOUtils.toCharArray(input, Charset.forName(charset));
    }

    public static char[] toCharArray(InputStream input, Charset charset) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.write(input, (Writer)output, charset);
        return output.toCharArray();
    }

    public static char[] toCharArray(Reader input) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.write(input, (Writer)output);
        return output.toCharArray();
    }

    public static List<String> readLines(InputStream input, String charset) throws IOException {
        return IOUtils.readLines(input, Charset.forName(charset));
    }

    public static List<String> readLines(InputStream input, Charset charset) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, charset);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = IOUtils.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static void write(OutputStream output, byte[] data) throws IOException {
        if (data != null) {
            output.write(data);
            output.flush();
        }
    }

    public static void write(Writer output, byte[] data) throws IOException {
        if (data != null) {
            output.write(new String(data));
            output.flush();
        }
    }

    public static void write(Writer output, byte[] data, String charset) throws IOException {
        IOUtils.write(output, data, Charset.forName(charset));
    }

    public static void write(Writer output, byte[] data, Charset charset) throws IOException {
        if (data != null) {
            output.write(new String(data, charset));
            output.flush();
        }
    }

    public static void write(Writer output, char[] data) throws IOException {
        if (data != null) {
            output.write(data);
            output.flush();
        }
    }

    public static void write(OutputStream output, char[] data) throws IOException {
        if (data != null) {
            output.write(new String(data).getBytes());
            output.flush();
        }
    }

    public static void write(OutputStream output, char[] data, String charset) throws IOException {
        IOUtils.write(output, data, Charset.forName(charset));
    }

    public static void write(OutputStream output, char[] data, Charset charset) throws IOException {
        if (data != null) {
            output.write(new String(data).getBytes(charset));
            output.flush();
        }
    }

    public static void write(Writer output, CharSequence data) throws IOException {
        if (data != null) {
            output.write(data.toString());
            output.flush();
        }
    }

    public static void write(OutputStream output, CharSequence data) throws IOException {
        if (data != null) {
            output.write(data.toString().getBytes());
            output.flush();
        }
    }

    public static void write(OutputStream output, CharSequence data, String charset) throws IOException {
        IOUtils.write(output, data, Charset.forName(charset));
    }

    public static void write(OutputStream output, CharSequence data, Charset charset) throws IOException {
        if (data != null) {
            output.write(data.toString().getBytes(charset));
            output.flush();
        }
    }

    public static void write(Reader input, OutputStream output) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtils.write(input, (Writer)out);
    }

    public static void write(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
            output.flush();
        }
    }

    public static void write(String path, InputStream input, OutputStream output, long totalSize) throws IOException {
        long downloadByte = 0L;
        byte[] buffer = new byte[16384];
        BufferedInputStream inbuff = null;
        BufferedOutputStream bos = null;
        inbuff = new BufferedInputStream(input, buffer.length);
        bos = new BufferedOutputStream(output, buffer.length);
        ProgressBean progressBean = new ProgressBean();
        progressBean.setPath(path);
        progressBean.setTotalSize(totalSize);
        while (true) {
            int len;
            if ((len = inbuff.read(buffer)) == -1) {
                if (progressBean.getProgress() == 100) break;
                progressBean.setProgress(100);
                progressBean.setCurrentTotalBytes(totalSize);
                progress.postValue((Object)progressBean);
                break;
            }
            bos.write(buffer, 0, len);
            progressBean.setCurrentTotalBytes(downloadByte += (long)len);
            int pg = (int)(downloadByte * 100L / totalSize);
            progressBean.setProgress(pg);
            progress.postValue((Object)progressBean);
        }
        bos.flush();
        bos.close();
        inbuff.close();
    }

    public static void write(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IOUtils.write((Reader)in, output);
    }

    public static void write(Reader input, OutputStream output, String charset) throws IOException {
        IOUtils.write(input, output, Charset.forName(charset));
    }

    public static void write(Reader input, OutputStream output, Charset charset) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output, charset);
        IOUtils.write(input, (Writer)out);
    }

    public static void write(InputStream input, OutputStream output, String charset) throws IOException {
        IOUtils.write(input, output, Charset.forName(charset));
    }

    public static void write(InputStream input, OutputStream output, Charset charset) throws IOException {
        InputStreamReader in = new InputStreamReader(input, charset);
        IOUtils.write((Reader)in, output);
    }

    public static void write(InputStream input, Writer output, String charset) throws IOException {
        IOUtils.write(input, output, Charset.forName(charset));
    }

    public static void write(InputStream input, Writer output, Charset charset) throws IOException {
        InputStreamReader in = new InputStreamReader(input, charset);
        IOUtils.write((Reader)in, output);
    }

    public static void write(Reader input, Writer output) throws IOException {
        int len;
        char[] buffer = new char[4096];
        while (-1 != (len = input.read(buffer))) {
            output.write(buffer, 0, len);
            output.flush();
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        input1 = IOUtils.toBufferedInputStream(input1);
        input2 = IOUtils.toBufferedInputStream(input2);
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IOException {
        int ch2;
        input1 = IOUtils.toBufferedReader(input1);
        input2 = IOUtils.toBufferedReader(input2);
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEqualsIgnoreEOL(Reader input1, Reader input2) throws IOException {
        BufferedReader br1 = IOUtils.toBufferedReader(input1);
        BufferedReader br2 = IOUtils.toBufferedReader(input2);
        String line1 = br1.readLine();
        String line2 = br2.readLine();
        while (line1 != null && line2 != null && line1.equals(line2)) {
            line1 = br1.readLine();
            line2 = br2.readLine();
        }
        return line1 != null && (line2 == null || line1.equals(line2));
    }

    public static long getDirSize(String path) {
        StatFs stat;
        try {
            stat = new StatFs(path);
        }
        catch (Exception e) {
            return 0L;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            return stat.getBlockSizeLong() * stat.getAvailableBlocksLong();
        }
        return (long)stat.getBlockSize() * (long)stat.getAvailableBlocks();
    }

    public static boolean canWrite(String path) {
        return new File(path).canWrite();
    }

    public static boolean canRead(String path) {
        return new File(path).canRead();
    }

    public static boolean createFolder(String folderPath) {
        if (!TextUtils.isEmpty((CharSequence)folderPath)) {
            File folder = new File(folderPath);
            return IOUtils.createFolder(folder);
        }
        return false;
    }

    public static boolean createFolder(File targetFolder) {
        if (targetFolder.exists()) {
            if (targetFolder.isDirectory()) {
                return true;
            }
            targetFolder.delete();
        }
        return targetFolder.mkdirs();
    }

    public static boolean createNewFolder(String folderPath) {
        return IOUtils.delFileOrFolder(folderPath) && IOUtils.createFolder(folderPath);
    }

    public static boolean createNewFolder(File targetFolder) {
        return IOUtils.delFileOrFolder(targetFolder) && IOUtils.createFolder(targetFolder);
    }

    public static boolean createFile(String filePath) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            File file = new File(filePath);
            return IOUtils.createFile(file);
        }
        return false;
    }

    public static boolean createFile(File targetFile) {
        if (targetFile.exists()) {
            if (targetFile.isFile()) {
                return true;
            }
            IOUtils.delFileOrFolder(targetFile);
        }
        try {
            return targetFile.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean createNewFile(String filePath) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            File file = new File(filePath);
            return IOUtils.createNewFile(file);
        }
        return false;
    }

    public static boolean createNewFile(File targetFile) {
        if (targetFile.exists()) {
            IOUtils.delFileOrFolder(targetFile);
        }
        try {
            return targetFile.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean delFileOrFolder(String path) {
        return IOUtils.delFileOrFolder(new File(path));
    }

    public static boolean delFileOrFolder(File file) {
        if (file != null && file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File sonFile : files) {
                        IOUtils.delFileOrFolder(sonFile);
                    }
                }
                file.delete();
            }
        }
        return true;
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        public NonClosingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int let) throws IOException {
            this.out.write(b, off, let);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class NonClosingInputStream
    extends FilterInputStream {
        public NonClosingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

