/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.util;

import androidx.annotation.NonNull;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LinkedCaseInsensitiveMap<V>
implements Map<String, V>,
Serializable,
Cloneable {
    private final LinkedHashMap<String, V> mSource;
    private final HashMap<String, String> mCaseInsensitiveKeys;
    private final Locale mLocale;

    public LinkedCaseInsensitiveMap() {
        this((Locale)null);
    }

    public LinkedCaseInsensitiveMap(Locale locale) {
        this(16, locale);
    }

    public LinkedCaseInsensitiveMap(int initialCapacity) {
        this(initialCapacity, null);
    }

    public LinkedCaseInsensitiveMap(int initialCapacity, Locale locale) {
        this.mSource = new LinkedHashMap<String, V>(initialCapacity){

            @Override
            public boolean containsKey(Object key) {
                return LinkedCaseInsensitiveMap.this.containsKey(key);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, V> eldest) {
                boolean isRemoved = LinkedCaseInsensitiveMap.this.removeEldestEntry(eldest);
                if (isRemoved) {
                    LinkedCaseInsensitiveMap.this.mCaseInsensitiveKeys.remove(LinkedCaseInsensitiveMap.this.convertKey(eldest.getKey()));
                }
                return isRemoved;
            }
        };
        this.mCaseInsensitiveKeys = new HashMap(initialCapacity);
        this.mLocale = locale != null ? locale : Locale.getDefault();
    }

    private LinkedCaseInsensitiveMap(LinkedCaseInsensitiveMap<V> other) {
        this.mSource = (LinkedHashMap)other.mSource.clone();
        this.mCaseInsensitiveKeys = (HashMap)other.mCaseInsensitiveKeys.clone();
        this.mLocale = other.mLocale;
    }

    @Override
    public int size() {
        return this.mSource.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mSource.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.mCaseInsensitiveKeys.containsKey(this.convertKey((String)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mSource.containsValue(value);
    }

    @Override
    public V get(Object key) {
        String caseInsensitiveKey;
        if (key instanceof String && (caseInsensitiveKey = this.mCaseInsensitiveKeys.get(this.convertKey((String)key))) != null) {
            return this.mSource.get(caseInsensitiveKey);
        }
        return null;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        String caseInsensitiveKey;
        if (key instanceof String && (caseInsensitiveKey = this.mCaseInsensitiveKeys.get(this.convertKey((String)key))) != null) {
            return this.mSource.get(caseInsensitiveKey);
        }
        return defaultValue;
    }

    @Override
    public V put(String key, V value) {
        String oldKey = this.mCaseInsensitiveKeys.put(this.convertKey(key), key);
        if (oldKey != null && !oldKey.equals(key)) {
            this.mSource.remove(oldKey);
        }
        return this.mSource.put(key, value);
    }

    @Override
    public void putAll(@NonNull Map<? extends String, ? extends V> map) {
        if (map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        String caseInsensitiveKey;
        if (key instanceof String && (caseInsensitiveKey = this.mCaseInsensitiveKeys.remove(this.convertKey((String)key))) != null) {
            return this.mSource.remove(caseInsensitiveKey);
        }
        return null;
    }

    @Override
    public void clear() {
        this.mCaseInsensitiveKeys.clear();
        this.mSource.clear();
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return this.mSource.keySet();
    }

    @Override
    @NonNull
    public Collection<V> values() {
        return this.mSource.values();
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, V>> entrySet() {
        return this.mSource.entrySet();
    }

    public LinkedCaseInsensitiveMap<V> clone() {
        return new LinkedCaseInsensitiveMap<V>(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this.mSource.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.mSource.hashCode();
    }

    public String toString() {
        return this.mSource.toString();
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    protected String convertKey(String key) {
        return key.toLowerCase(this.getLocale());
    }

    protected boolean removeEldestEntry(Map.Entry<String, V> eldest) {
        return false;
    }
}

