/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.yanzhenjie.andserver.annotation.AppInfo;
import com.yanzhenjie.andserver.annotation.Config;
import com.yanzhenjie.andserver.processor.BaseProcessor;
import com.yanzhenjie.andserver.processor.util.Logger;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class ConfigProcessor
extends BaseProcessor {
    private Filer mFiler;
    private Elements mElements;
    private Logger mLog;
    private TypeName mContext;
    private TypeName mOnRegisterType;
    private TypeName mRegisterType;
    private TypeName mConfig;
    private TypeName mDelegate;
    private TypeName mWebsite;
    private TypeName mMultipart;
    private TypeName mString;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.mFiler = processingEnv.getFiler();
        this.mElements = processingEnv.getElementUtils();
        this.mLog = new Logger(processingEnv.getMessager());
        this.mContext = TypeName.get((TypeMirror)this.mElements.getTypeElement("android.content.Context").asType());
        this.mOnRegisterType = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.register.OnRegister").asType());
        this.mRegisterType = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.register.Register").asType());
        this.mConfig = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.config.WebConfig").asType());
        this.mDelegate = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.config.Delegate").asType());
        this.mWebsite = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.website.Website").asType());
        this.mMultipart = TypeName.get((TypeMirror)this.mElements.getTypeElement("com.yanzhenjie.andserver.framework.config.Multipart").asType());
        this.mString = TypeName.get(String.class);
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnv) {
        if (CollectionUtils.isEmpty(set)) {
            return false;
        }
        Set<? extends Element> appSet = roundEnv.getElementsAnnotatedWith(AppInfo.class);
        String registerPackageName = this.getRegisterPackageName(appSet);
        Map<String, TypeElement> configMap = this.findAnnotation(roundEnv);
        this.createRegister(registerPackageName, configMap);
        return true;
    }

    private Map<String, TypeElement> findAnnotation(RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(Config.class);
        HashMap<String, TypeElement> configMap = new HashMap<String, TypeElement>();
        block0: for (Element element : set) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            Set<Modifier> modifiers = typeElement.getModifiers();
            Validate.isTrue((boolean)modifiers.contains((Object)Modifier.PUBLIC), (String)"The modifier public is missing on %s.", (Object[])new Object[]{typeElement.getQualifiedName()});
            List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
            if (CollectionUtils.isEmpty(interfaces)) {
                this.mLog.w(String.format("The com.yanzhenjie.andserver.annotation Converter must be used in a subclass of [WebConfig] on %s.", typeElement.getQualifiedName()));
                continue;
            }
            for (TypeMirror typeMirror : interfaces) {
                if (this.mConfig.equals((Object)TypeName.get((TypeMirror)typeMirror))) {
                    configMap.put(this.getGroup(typeElement), typeElement);
                    continue block0;
                }
                this.mLog.w(String.format("The com.yanzhenjie.andserver.annotation Config must be used in a subclass of [WebConfig] on %s.", typeElement.getQualifiedName()));
            }
        }
        return configMap;
    }

    private void createRegister(String registerPackageName, Map<String, TypeElement> configMap) {
        ParameterizedTypeName typeName = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.mString, this.mConfig});
        FieldSpec mapField = FieldSpec.builder((TypeName)typeName, (String)"mMap", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        CodeBlock.Builder rootCode = CodeBlock.builder().addStatement("this.mMap = new $T<>()", new Object[]{HashMap.class});
        for (Map.Entry<String, TypeElement> entry : configMap.entrySet()) {
            String group = entry.getKey();
            TypeElement config = entry.getValue();
            this.mLog.i(String.format("------ Processing %s ------", config.getSimpleName()));
            rootCode.addStatement("this.mMap.put($S, new $T())", new Object[]{group, config});
        }
        MethodSpec rootMethod = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(rootCode.build()).build();
        ParameterizedTypeName listType = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.mWebsite});
        MethodSpec registerMethod = MethodSpec.methodBuilder((String)"onRegister").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.mContext, "context", new Modifier[0]).addParameter(this.mString, "group", new Modifier[0]).addParameter(this.mRegisterType, "register", new Modifier[0]).addStatement("$T config = mMap.get(group)", new Object[]{this.mConfig}).beginControlFlow("if(config == null)", new Object[0]).addStatement("config = mMap.get($S)", new Object[]{"default"}).endControlFlow().beginControlFlow("if(config != null)", new Object[0]).addStatement("$T delegate = $T.newInstance()", new Object[]{this.mDelegate, this.mDelegate}).addStatement("config.onConfig(context, delegate)", new Object[0]).addStatement("$T list = delegate.getWebsites()", new Object[]{listType}).beginControlFlow("if(list != null && !list.isEmpty())", new Object[0]).beginControlFlow("for ($T website : list)", new Object[]{this.mWebsite}).addStatement("register.addAdapter(website)", new Object[0]).endControlFlow().endControlFlow().addStatement("$T multipart = delegate.getMultipart()", new Object[]{this.mMultipart}).addStatement("register.setMultipart(multipart)", new Object[0]).endControlFlow().build();
        TypeSpec adapterClass = TypeSpec.classBuilder((String)"ConfigRegister").addJavadoc("This file was generated by AndServer automatically and you should NOT edit it.", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(this.mOnRegisterType).addField(mapField).addMethod(rootMethod).addMethod(registerMethod).build();
        JavaFile javaFile = JavaFile.builder((String)registerPackageName, (TypeSpec)adapterClass).build();
        try {
            javaFile.writeTo(this.mFiler);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getGroup(TypeElement type) {
        Config config = type.getAnnotation(Config.class);
        if (config != null) {
            return config.value();
        }
        throw new IllegalStateException(String.format("The type is not a Config: %1$s.", type));
    }

    @Override
    protected void addAnnotation(Set<Class<? extends Annotation>> classSet) {
        classSet.add(Config.class);
        classSet.add(AppInfo.class);
    }
}

