/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ObserverList<E>
implements Iterable<E> {
    private final List<E> mObservers = new ArrayList();
    private int mIterationDepth;
    private int mCount;
    private boolean mNeedsCompact;

    public boolean addObserver(E obs) {
        if (obs == null || this.mObservers.contains(obs)) {
            return false;
        }
        boolean result = this.mObservers.add(obs);
        assert (result);
        ++this.mCount;
        return true;
    }

    public boolean removeObserver(E obs) {
        if (obs == null) {
            return false;
        }
        int index = this.mObservers.indexOf(obs);
        if (index == -1) {
            return false;
        }
        if (this.mIterationDepth == 0) {
            this.mObservers.remove(index);
        } else {
            this.mNeedsCompact = true;
            this.mObservers.set(index, null);
        }
        --this.mCount;
        assert (this.mCount >= 0);
        return true;
    }

    public boolean hasObserver(E obs) {
        return this.mObservers.contains(obs);
    }

    public void clear() {
        this.mCount = 0;
        if (this.mIterationDepth == 0) {
            this.mObservers.clear();
            return;
        }
        int size = this.mObservers.size();
        this.mNeedsCompact |= size != 0;
        for (int i = 0; i < size; ++i) {
            this.mObservers.set(i, null);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new ObserverListIterator();
    }

    public RewindableIterator<E> rewindableIterator() {
        return new ObserverListIterator();
    }

    public int size() {
        return this.mCount;
    }

    public boolean isEmpty() {
        return this.mCount == 0;
    }

    private void compact() {
        assert (this.mIterationDepth == 0);
        for (int i = this.mObservers.size() - 1; i >= 0; --i) {
            if (this.mObservers.get(i) != null) continue;
            this.mObservers.remove(i);
        }
    }

    private void incrementIterationDepth() {
        ++this.mIterationDepth;
    }

    private void decrementIterationDepthAndCompactIfNeeded() {
        --this.mIterationDepth;
        assert (this.mIterationDepth >= 0);
        if (this.mIterationDepth > 0) {
            return;
        }
        if (!this.mNeedsCompact) {
            return;
        }
        this.mNeedsCompact = false;
        this.compact();
    }

    private int capacity() {
        return this.mObservers.size();
    }

    private E getObserverAt(int index) {
        return this.mObservers.get(index);
    }

    public RewindableIterator<E> reverseIterator() {
        return new ObserverListReversedIterator();
    }

    private class ObserverListIterator
    implements RewindableIterator<E> {
        private int mListEndMarker;
        private int mIndex;
        private boolean mIsExhausted;

        private ObserverListIterator() {
            ObserverList.this.incrementIterationDepth();
            this.mListEndMarker = ObserverList.this.capacity();
        }

        @Override
        public void rewind() {
            this.compactListIfNeeded();
            ObserverList.this.incrementIterationDepth();
            this.mListEndMarker = ObserverList.this.capacity();
            this.mIsExhausted = false;
            this.mIndex = 0;
        }

        @Override
        public boolean hasNext() {
            int lookupIndex;
            for (lookupIndex = this.mIndex; lookupIndex < this.mListEndMarker && ObserverList.this.getObserverAt(lookupIndex) == null; ++lookupIndex) {
            }
            if (lookupIndex < this.mListEndMarker) {
                return true;
            }
            this.compactListIfNeeded();
            return false;
        }

        @Override
        public E next() {
            while (this.mIndex < this.mListEndMarker && ObserverList.this.getObserverAt(this.mIndex) == null) {
                ++this.mIndex;
            }
            if (this.mIndex < this.mListEndMarker) {
                return ObserverList.this.getObserverAt(this.mIndex++);
            }
            this.compactListIfNeeded();
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void compactListIfNeeded() {
            if (!this.mIsExhausted) {
                this.mIsExhausted = true;
                ObserverList.this.decrementIterationDepthAndCompactIfNeeded();
            }
        }
    }

    private class ObserverListReversedIterator
    implements RewindableIterator<E> {
        private int mIndex;
        private boolean mIsExhausted;

        private ObserverListReversedIterator() {
            ObserverList.this.incrementIterationDepth();
            this.mIndex = ObserverList.this.capacity() - 1;
        }

        @Override
        public void rewind() {
            this.compactListIfNeeded();
            ObserverList.this.incrementIterationDepth();
            this.mIsExhausted = false;
            this.mIndex = ObserverList.this.capacity() - 1;
        }

        @Override
        public boolean hasNext() {
            int lookupIndex;
            for (lookupIndex = this.mIndex; lookupIndex >= 0 && ObserverList.this.getObserverAt(lookupIndex) == null; --lookupIndex) {
            }
            if (lookupIndex >= 0) {
                return true;
            }
            this.compactListIfNeeded();
            return false;
        }

        @Override
        public E next() {
            while (this.mIndex >= 0 && ObserverList.this.getObserverAt(this.mIndex) == null) {
                --this.mIndex;
            }
            if (this.mIndex >= 0) {
                return ObserverList.this.getObserverAt(this.mIndex--);
            }
            this.compactListIfNeeded();
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void compactListIfNeeded() {
            if (!this.mIsExhausted) {
                this.mIsExhausted = true;
                ObserverList.this.decrementIterationDepthAndCompactIfNeeded();
            }
        }
    }

    public static interface RewindableIterator<E>
    extends Iterator<E> {
        public void rewind();
    }
}

