/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.core.font;

import android.graphics.Typeface;
import android.os.Build;
import androidx.annotation.Nullable;
import com.yandex.div.core.annotations.PublicApi;

@PublicApi
public interface DivTypefaceProvider {
    public static final DivTypefaceProvider DEFAULT = new DivTypefaceProvider(){

        @Override
        @Nullable
        public Typeface getRegular() {
            return null;
        }

        @Override
        @Nullable
        public Typeface getMedium() {
            return null;
        }

        @Override
        @Nullable
        public Typeface getLight() {
            return null;
        }

        @Override
        @Nullable
        public Typeface getBold() {
            return null;
        }

        @Override
        @Nullable
        public Typeface getTypefaceFor(int weight) {
            if (Build.VERSION.SDK_INT >= 28) {
                return Typeface.create((Typeface)Typeface.DEFAULT, (int)weight, (boolean)false);
            }
            return DivTypefaceProvider.super.getTypefaceFor(weight);
        }

        @Override
        @Nullable
        public Typeface getRegularLegacy() {
            return null;
        }
    };

    @Nullable
    public Typeface getRegular();

    @Nullable
    public Typeface getMedium();

    @Nullable
    public Typeface getLight();

    @Nullable
    public Typeface getBold();

    @Nullable
    default public Typeface getTypefaceFor(int weight) {
        if (weight >= 0 && weight < 350) {
            return this.getLight();
        }
        if (weight >= 350 && weight < 450) {
            return this.getRegular();
        }
        if (weight >= 450 && weight < 600) {
            return this.getMedium();
        }
        return this.getBold();
    }

    @Deprecated
    @Nullable
    default public Typeface getRegularLegacy() {
        return this.getRegular();
    }
}

