/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.core.images;

import android.graphics.Bitmap;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.div.core.annotations.PublicApi;
import com.yandex.div.core.images.BitmapSource;

@PublicApi
public class CachedBitmap {
    @NonNull
    private final Bitmap mBitmap;
    @Nullable
    private final Uri mCacheUri;
    @Nullable
    private final byte[] mBytes;
    @NonNull
    private final BitmapSource mFrom;

    public CachedBitmap(@NonNull Bitmap bitmap, @Nullable Uri cacheUri, @NonNull BitmapSource from) {
        this(bitmap, null, cacheUri, from);
    }

    public CachedBitmap(@NonNull Bitmap bitmap, @Nullable byte[] bytes, @Nullable Uri cacheUri, @NonNull BitmapSource from) {
        this.mBitmap = bitmap;
        this.mCacheUri = cacheUri;
        this.mBytes = bytes;
        this.mFrom = from;
    }

    @NonNull
    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Nullable
    public byte[] getBytes() {
        return this.mBytes;
    }

    @Nullable
    public Uri getCacheUri() {
        return this.mCacheUri;
    }

    @NonNull
    public BitmapSource getFrom() {
        return this.mFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedBitmap that = (CachedBitmap)o;
        if (!this.mBitmap.equals(that.getBitmap())) {
            return false;
        }
        if (this.mFrom != that.getFrom()) {
            return false;
        }
        Uri thatCacheUri = that.getCacheUri();
        return this.mCacheUri != null ? this.mCacheUri.equals((Object)thatCacheUri) : thatCacheUri == null;
    }

    public int hashCode() {
        int result = this.mBitmap.hashCode();
        result = 31 * result + this.mFrom.hashCode();
        result = 31 * result + (this.mCacheUri != null ? this.mCacheUri.hashCode() : 0);
        return result;
    }
}

