/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal.parser;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.div.internal.parser.JsonParsers;
import com.yandex.div.internal.parser.ListValidator;
import com.yandex.div.internal.parser.TypeHelper;
import com.yandex.div.internal.parser.TypeHelpersKt;
import com.yandex.div.internal.parser.ValueValidator;
import com.yandex.div.json.ParsingErrorLogger;
import com.yandex.div.json.ParsingExceptionKt;
import com.yandex.div.json.expressions.ConstantExpressionList;
import com.yandex.div.json.expressions.Expression;
import com.yandex.div.json.expressions.ExpressionList;
import com.yandex.div.json.expressions.ExpressionResolver;
import com.yandex.div.json.expressions.MutableExpressionList;
import com.yandex.div.serialization.ParsingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonExpressionParser {
    private static final ExpressionList<?> EMPTY_EXPRESSION_LIST = new ConstantExpressionList(Collections.emptyList());

    private JsonExpressionParser() {
    }

    @NonNull
    public static <V> Expression<V> readExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper) {
        return JsonExpressionParser.readExpression(context, jsonObject, key, typeHelper, JsonParsers.doNotConvert(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> Expression<V> readExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter) {
        return JsonExpressionParser.readExpression(context, jsonObject, key, typeHelper, converter, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> Expression<V> readExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ValueValidator<V> validator) {
        return JsonExpressionParser.readExpression(context, jsonObject, key, typeHelper, JsonParsers.doNotConvert(), validator);
    }

    @NonNull
    public static <R, V> Expression<V> readExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        Object value;
        Object intermediate = JsonExpressionParser.optSafe(jsonObject, key);
        if (intermediate == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        if (Expression.mayBeExpression(intermediate)) {
            return new Expression.MutableExpression<R, V>(key, intermediate.toString(), converter, validator, context.getLogger(), typeHelper, null);
        }
        try {
            value = converter.invoke(intermediate);
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate);
        }
        catch (Exception e) {
            throw ParsingExceptionKt.invalidValue(jsonObject, key, intermediate, (Throwable)e);
        }
        if (value == null) {
            throw ParsingExceptionKt.invalidValue(jsonObject, key, intermediate);
        }
        if (!typeHelper.isTypeValid(value)) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate);
        }
        try {
            if (!validator.isValid(value)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, intermediate);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate);
        }
        return Expression.constant(value);
    }

    @Nullable
    public static Expression<String> readOptionalExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<String> typeHelper) {
        return JsonExpressionParser.readOptionalExpression(context, jsonObject, key, typeHelper, JsonParsers.doNotConvert(), JsonParsers.alwaysValidString(), null);
    }

    @Nullable
    public static <V> Expression<V> readOptionalExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @Nullable Expression<V> defaultValue) {
        return JsonExpressionParser.readOptionalExpression(context, jsonObject, key, typeHelper, JsonParsers.doNotConvert(), JsonParsers.alwaysValid(), defaultValue);
    }

    @Nullable
    public static <R, V> Expression<V> readOptionalExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter) {
        return JsonExpressionParser.readOptionalExpression(context, jsonObject, key, typeHelper, converter, JsonParsers.alwaysValid(), null);
    }

    @Nullable
    public static <R, V> Expression<V> readOptionalExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @Nullable Expression<V> defaultValue) {
        return JsonExpressionParser.readOptionalExpression(context, jsonObject, key, typeHelper, converter, JsonParsers.alwaysValid(), defaultValue);
    }

    @Nullable
    public static <V> Expression<V> readOptionalExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ValueValidator<V> validator) {
        return JsonExpressionParser.readOptionalExpression(context, jsonObject, key, typeHelper, JsonParsers.doNotConvert(), validator, null);
    }

    @Nullable
    public static <V> Expression<V> readOptionalExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ValueValidator<V> validator, @Nullable Expression<V> defaultValue) {
        return JsonExpressionParser.readOptionalExpression(context, jsonObject, key, typeHelper, JsonParsers.doNotConvert(), validator, defaultValue);
    }

    @Nullable
    public static <R, V> Expression<V> readOptionalExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        return JsonExpressionParser.readOptionalExpression(context, jsonObject, key, typeHelper, converter, validator, null);
    }

    @Nullable
    public static <R, V> Expression<V> readOptionalExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator, @Nullable Expression<V> defaultValue) {
        Object value;
        Object intermediate = JsonExpressionParser.optSafe(jsonObject, key);
        if (intermediate == null) {
            return null;
        }
        if (Expression.mayBeExpression(intermediate)) {
            return new Expression.MutableExpression<R, V>(key, intermediate.toString(), converter, validator, context.getLogger(), typeHelper, defaultValue);
        }
        try {
            value = converter.invoke(intermediate);
        }
        catch (ClassCastException castException) {
            context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate));
            return null;
        }
        catch (Exception e) {
            context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate, (Throwable)e));
            return null;
        }
        if (value == null) {
            context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate));
            return null;
        }
        if (!typeHelper.isTypeValid(value)) {
            context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate));
            return null;
        }
        try {
            if (!validator.isValid(value)) {
                context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate));
                return null;
            }
        }
        catch (ClassCastException castException) {
            context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate));
            return null;
        }
        return Expression.constant(value);
    }

    @NonNull
    public static ExpressionList<String> readExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull ListValidator<String> listValidator) {
        return JsonExpressionParser.readExpressionList(context, jsonObject, key, TypeHelpersKt.TYPE_HELPER_STRING, JsonParsers.doNotConvert(), listValidator, JsonParsers.alwaysValidString());
    }

    @NonNull
    public static <R, V> ExpressionList<V> readExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter) {
        return JsonExpressionParser.readExpressionList(context, jsonObject, key, typeHelper, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static ExpressionList<String> readExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<String> typeHelper, @NonNull ListValidator<String> listValidator) {
        return JsonExpressionParser.readExpressionList(context, jsonObject, key, typeHelper, JsonParsers.doNotConvert(), listValidator, JsonParsers.alwaysValidString());
    }

    @NonNull
    public static <R, V> ExpressionList<V> readExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonExpressionParser.readExpressionList(context, jsonObject, key, typeHelper, converter, listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> ExpressionList<V> readExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        return JsonExpressionParser.readExpressionList(context, jsonObject, key, typeHelper, JsonParsers.doNotConvert(), listValidator, itemValidator);
    }

    @NonNull
    public static <R, V> ExpressionList<V> readExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        Object item;
        JSONArray array = jsonObject.optJSONArray(key);
        if (array == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        int length = array.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!listValidator.isValid(emptyList)) {
                    context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return JsonExpressionParser.emptyExpressionList();
                }
            }
            catch (ClassCastException castException) {
                context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return JsonExpressionParser.emptyExpressionList();
            }
            return JsonExpressionParser.emptyExpressionList();
        }
        ArrayList<Object> untypedList = new ArrayList<Object>(length);
        boolean containsExpressions = false;
        ParsingErrorLogger logger = null;
        for (int i = 0; i < length; ++i) {
            block20: {
                Object intermediate = JsonExpressionParser.optSafe(array, i);
                if (intermediate == null) continue;
                if (Expression.mayBeExpression(intermediate)) {
                    if (logger == null) {
                        logger = context.getLogger();
                    }
                    containsExpressions = true;
                    untypedList.add(new Expression.MutableExpression<R, V>(key + "[" + i + "]", intermediate.toString(), converter, itemValidator, logger, typeHelper, null));
                    continue;
                }
                try {
                    item = converter.invoke(intermediate);
                }
                catch (ClassCastException castException) {
                    context.getLogger().logError(ParsingExceptionKt.typeMismatch(array, key, i, intermediate));
                    continue;
                }
                catch (Exception e) {
                    context.getLogger().logError(ParsingExceptionKt.invalidValue(array, key, i, intermediate, e));
                    continue;
                }
                if (item == null) continue;
                if (!typeHelper.isTypeValid(item)) {
                    context.getLogger().logError(ParsingExceptionKt.typeMismatch(array, key, i, intermediate));
                    continue;
                }
                try {
                    if (!itemValidator.isValid(item)) {
                        context.getLogger().logError(ParsingExceptionKt.invalidValue(array, key, i, item));
                    }
                    break block20;
                }
                catch (ClassCastException castException) {
                    context.getLogger().logError(ParsingExceptionKt.typeMismatch(array, key, i, item));
                }
                continue;
            }
            untypedList.add(item);
        }
        if (containsExpressions) {
            int untypedLength = untypedList.size();
            for (int i = 0; i < untypedLength; ++i) {
                item = untypedList.get(i);
                if (item instanceof Expression) continue;
                untypedList.set(i, Expression.constant(item));
            }
            ArrayList<Object> list = untypedList;
            return new MutableExpressionList<V>(key, list, listValidator, context.getLogger());
        }
        ArrayList<Object> list = untypedList;
        try {
            if (!listValidator.isValid(list)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, list);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, list);
        }
        return new ConstantExpressionList(list);
    }

    @Nullable
    public static <R, V> ExpressionList<V> readOptionalExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter) {
        return JsonExpressionParser.readOptionalExpressionList(context, jsonObject, key, typeHelper, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @Nullable
    public static <V> ExpressionList<V> readOptionalExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ListValidator<V> listValidator) {
        return JsonExpressionParser.readOptionalExpressionList(context, jsonObject, key, typeHelper, JsonParsers.doNotConvert(), listValidator, JsonParsers.alwaysValid());
    }

    @Nullable
    public static <R, V> ExpressionList<V> readOptionalExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonExpressionParser.readOptionalExpressionList(context, jsonObject, key, typeHelper, converter, listValidator, JsonParsers.alwaysValid());
    }

    @Nullable
    public static <V> ExpressionList<V> readOptionalExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        return JsonExpressionParser.readOptionalExpressionList(context, jsonObject, key, typeHelper, JsonParsers.doNotConvert(), listValidator, itemValidator);
    }

    @Nullable
    public static <R, V> ExpressionList<V> readOptionalExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        Object item;
        JSONArray array = jsonObject.optJSONArray(key);
        if (array == null) {
            return null;
        }
        int length = array.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!listValidator.isValid(emptyList)) {
                    context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return JsonExpressionParser.emptyExpressionList();
                }
            }
            catch (ClassCastException castException) {
                context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return JsonExpressionParser.emptyExpressionList();
            }
            return JsonExpressionParser.emptyExpressionList();
        }
        ArrayList<Object> untypedList = new ArrayList<Object>(length);
        boolean containsExpressions = false;
        ParsingErrorLogger logger = null;
        for (int i = 0; i < length; ++i) {
            block20: {
                Object intermediate = JsonExpressionParser.optSafe(array, i);
                if (intermediate == null) continue;
                if (Expression.mayBeExpression(intermediate)) {
                    if (logger == null) {
                        logger = context.getLogger();
                    }
                    containsExpressions = true;
                    untypedList.add(new Expression.MutableExpression<R, V>(key + "[" + i + "]", intermediate.toString(), converter, itemValidator, logger, typeHelper, null));
                    continue;
                }
                try {
                    item = converter.invoke(intermediate);
                }
                catch (ClassCastException castException) {
                    context.getLogger().logError(ParsingExceptionKt.typeMismatch(array, key, i, intermediate));
                    continue;
                }
                catch (Exception e) {
                    context.getLogger().logError(ParsingExceptionKt.invalidValue(array, key, i, intermediate, e));
                    continue;
                }
                if (item == null) continue;
                if (!typeHelper.isTypeValid(item)) {
                    context.getLogger().logError(ParsingExceptionKt.typeMismatch(array, key, i, intermediate));
                    continue;
                }
                try {
                    if (!itemValidator.isValid(item)) {
                        context.getLogger().logError(ParsingExceptionKt.invalidValue(array, key, i, item));
                    }
                    break block20;
                }
                catch (ClassCastException castException) {
                    context.getLogger().logError(ParsingExceptionKt.typeMismatch(array, key, i, item));
                }
                continue;
            }
            untypedList.add(item);
        }
        if (containsExpressions) {
            int untypedLength = untypedList.size();
            for (int i = 0; i < untypedLength; ++i) {
                item = untypedList.get(i);
                if (item instanceof Expression) continue;
                untypedList.set(i, Expression.constant(item));
            }
            ArrayList<Object> list = untypedList;
            return new MutableExpressionList<V>(key, list, listValidator, context.getLogger());
        }
        ArrayList<Object> list = untypedList;
        try {
            if (!listValidator.isValid(list)) {
                context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, list));
                return null;
            }
        }
        catch (ClassCastException castException) {
            context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, list));
            return null;
        }
        return new ConstantExpressionList(list);
    }

    @Nullable
    private static <T> T optSafe(JSONObject json, String key) {
        Object value = json.opt(key);
        if (value == JSONObject.NULL) {
            return null;
        }
        return (T)value;
    }

    @Nullable
    private static <T> T optSafe(JSONArray json, int index) {
        Object value = json.opt(index);
        if (value == JSONObject.NULL) {
            return null;
        }
        return (T)value;
    }

    @NonNull
    private static <V> ExpressionList<V> emptyExpressionList() {
        return EMPTY_EXPRESSION_LIST;
    }

    public static <V> void writeExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Expression<V> expression) {
        JsonExpressionParser.writeExpression(context, jsonObject, key, expression, JsonParsers.doNotConvert());
    }

    public static <R, V> void writeExpression(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Expression<V> expression, @NonNull Function1<V, R> converter) {
        if (expression == null) {
            return;
        }
        Object rawExpression = expression.getRawValue();
        boolean needsConversion = !(expression instanceof Expression.MutableExpression);
        try {
            if (needsConversion) {
                jsonObject.put(key, converter.invoke(rawExpression));
            } else {
                jsonObject.put(key, rawExpression);
            }
        }
        catch (JSONException e) {
            context.getLogger().logError((Exception)((Object)e));
        }
    }

    public static <V> void writeExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable ExpressionList<V> expressionList) {
        JsonExpressionParser.writeExpressionList(context, jsonObject, key, expressionList, JsonParsers.doNotConvert());
    }

    public static <R, V> void writeExpressionList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable ExpressionList<V> expressionList, @NonNull Function1<V, R> converter) {
        if (expressionList == null) {
            return;
        }
        if (expressionList instanceof ConstantExpressionList) {
            List<V> list = expressionList.evaluate(ExpressionResolver.EMPTY);
            int length = list.size();
            JSONArray array = new JSONArray();
            for (int i = 0; i < length; ++i) {
                V item = list.get(i);
                array.put(converter.invoke(item));
            }
            try {
                jsonObject.put(key, (Object)array);
            }
            catch (JSONException e) {
                context.getLogger().logError((Exception)((Object)e));
            }
            return;
        }
        if (expressionList instanceof MutableExpressionList) {
            List rawExpressions = ((MutableExpressionList)expressionList).getExpressionsInternal();
            if (rawExpressions.isEmpty()) {
                return;
            }
            int length = rawExpressions.size();
            JSONArray array = new JSONArray();
            for (int i = 0; i < length; ++i) {
                Expression expression = rawExpressions.get(i);
                if (expression instanceof Expression.ConstantExpression) {
                    array.put(converter.invoke(expression.evaluate(ExpressionResolver.EMPTY)));
                    continue;
                }
                array.put(expression.getRawValue());
            }
            try {
                jsonObject.put(key, (Object)array);
            }
            catch (JSONException e) {
                context.getLogger().logError((Exception)((Object)e));
            }
        }
    }
}

