/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal.parser;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.div.internal.parser.JsonExpressionParser;
import com.yandex.div.internal.parser.JsonParsers;
import com.yandex.div.internal.parser.JsonPropertyParser;
import com.yandex.div.internal.parser.JsonTemplateParserKt;
import com.yandex.div.internal.parser.ListValidator;
import com.yandex.div.internal.parser.TypeHelper;
import com.yandex.div.internal.parser.ValueValidator;
import com.yandex.div.internal.template.Field;
import com.yandex.div.internal.template.FieldKt;
import com.yandex.div.json.ParsingException;
import com.yandex.div.json.expressions.Expression;
import com.yandex.div.json.expressions.ExpressionList;
import com.yandex.div.serialization.Deserializer;
import com.yandex.div.serialization.ParsingContext;
import com.yandex.div.serialization.Serializer;
import java.util.List;
import kotlin.Lazy;
import kotlin.jvm.functions.Function1;
import org.json.JSONObject;

public class JsonFieldParser {
    private static final ValueValidator<String> IS_NOT_EMPTY = value -> !value.isEmpty();

    @NonNull
    public static <V> Field<V> readField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<V> fallback) {
        return JsonFieldParser.readField(context, json, key, overridable, fallback, JsonParsers.doNotConvert(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> Field<V> readField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<V> fallback, @NonNull Function1<R, V> converter) {
        return JsonFieldParser.readField(context, json, key, overridable, fallback, converter, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> Field<V> readField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<V> fallback, @NonNull ValueValidator<V> validator) {
        return JsonFieldParser.readField(context, json, key, overridable, fallback, JsonParsers.doNotConvert(), validator);
    }

    @NonNull
    public static <R, V> Field<V> readField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<V> fallback, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        try {
            V value = JsonPropertyParser.read(context, json, key, converter, validator);
            return new Field.Value<V>(overridable, value);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            String reference = JsonFieldParser.readReference(context, json, key);
            Field<V> referenceOrFallback = JsonFieldParser.referenceOrFallback(overridable, reference, fallback);
            if (referenceOrFallback != null) {
                return referenceOrFallback;
            }
            throw e;
        }
    }

    @NonNull
    public static <V> Field<V> readField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<V> fallback, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        try {
            V result = JsonPropertyParser.read(context, json, key, deserializer);
            return new Field.Value<V>(overridable, result);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            String reference = JsonFieldParser.readReference(context, json, key);
            Field<V> referenceOrFallback = JsonFieldParser.referenceOrFallback(overridable, reference, fallback);
            if (referenceOrFallback != null) {
                return referenceOrFallback;
            }
            throw e;
        }
    }

    @NonNull
    public static <V> Field<V> readOptionalField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<V> fallback) {
        return JsonFieldParser.readOptionalField(context, json, key, overridable, fallback, JsonParsers.doNotConvert(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> Field<V> readOptionalField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<V> fallback, @NonNull Function1<R, V> converter) {
        return JsonFieldParser.readOptionalField(context, json, key, overridable, fallback, converter, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> Field<V> readOptionalField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<V> fallback, @NonNull ValueValidator<V> validator) {
        return JsonFieldParser.readOptionalField(context, json, key, overridable, fallback, JsonParsers.doNotConvert(), validator);
    }

    @NonNull
    public static <R, V> Field<V> readOptionalField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<V> fallback, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        V opt = JsonPropertyParser.readOptional(context, json, key, converter, validator);
        if (opt != null) {
            return new Field.Value<V>(overridable, opt);
        }
        String reference = JsonFieldParser.readReference(context, json, key);
        if (reference != null) {
            return new Field.Reference(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <V> Field<V> readOptionalField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<V> fallback, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        V opt = JsonPropertyParser.readOptional(context, json, key, deserializer);
        if (opt != null) {
            return new Field.Value<V>(overridable, opt);
        }
        String reference = JsonFieldParser.readReference(context, json, key);
        if (reference != null) {
            return new Field.Reference(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <V> Field<Expression<V>> readFieldWithExpression(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<Expression<V>> fallback) {
        return JsonFieldParser.readFieldWithExpression(context, json, key, typeHelper, overridable, fallback, JsonParsers.doNotConvert(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> Field<Expression<V>> readFieldWithExpression(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<Expression<V>> fallback, @NonNull Function1<R, V> converter) {
        return JsonFieldParser.readFieldWithExpression(context, json, key, typeHelper, overridable, fallback, converter, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> Field<Expression<V>> readFieldWithExpression(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<Expression<V>> fallback, @NonNull ValueValidator<V> validator) {
        return JsonFieldParser.readFieldWithExpression(context, json, key, typeHelper, overridable, fallback, JsonParsers.doNotConvert(), validator);
    }

    @NonNull
    public static <R, V> Field<Expression<V>> readFieldWithExpression(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<Expression<V>> fallback, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        try {
            Expression<V> expression = JsonExpressionParser.readExpression(context, json, key, typeHelper, converter, validator);
            return new Field.Value<Expression<V>>(overridable, expression);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            Field<Expression<V>> referenceOrFallback = JsonFieldParser.referenceOrFallback(overridable, JsonFieldParser.readReference(context, json, key), fallback);
            if (referenceOrFallback != null) {
                return referenceOrFallback;
            }
            throw e;
        }
    }

    @NonNull
    public static Field<Expression<String>> readOptionalFieldWithExpression(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<String> typeHelper, boolean overridable, @Nullable Field<Expression<String>> fallback) {
        return JsonFieldParser.readOptionalFieldWithExpression(context, json, key, typeHelper, overridable, fallback, JsonParsers.doNotConvert(), JsonParsers.alwaysValidString());
    }

    @NonNull
    public static <R, V> Field<Expression<V>> readOptionalFieldWithExpression(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<Expression<V>> fallback, @NonNull Function1<R, V> converter) {
        return JsonFieldParser.readOptionalFieldWithExpression(context, json, key, typeHelper, overridable, fallback, converter, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> Field<Expression<V>> readOptionalFieldWithExpression(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<Expression<V>> fallback, @NonNull ValueValidator<V> validator) {
        return JsonFieldParser.readOptionalFieldWithExpression(context, json, key, typeHelper, overridable, fallback, JsonParsers.doNotConvert(), validator);
    }

    @NonNull
    public static <R, V> Field<Expression<V>> readOptionalFieldWithExpression(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<Expression<V>> fallback, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        Expression<V> opt = JsonExpressionParser.readOptionalExpression(context, json, key, typeHelper, converter, validator, null);
        if (opt != null) {
            return new Field.Value<Expression<V>>(overridable, opt);
        }
        String reference = JsonFieldParser.readReference(context, json, key);
        if (reference != null) {
            return new Field.Reference<Expression<V>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <R, V> Field<List<V>> readListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<V>> fallback, @NonNull Function1<R, V> converter) {
        return JsonFieldParser.readListField(context, json, key, overridable, fallback, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> Field<List<V>> readListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<V>> fallback, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonFieldParser.readListField(context, json, key, overridable, fallback, converter, listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> Field<List<V>> readListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<V>> fallback, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        try {
            List<V> opt = JsonPropertyParser.readList(context, json, key, converter, listValidator, itemValidator);
            return new Field.Value<List<V>>(overridable, opt);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            String reference = JsonFieldParser.readReference(context, json, key);
            Field<List<V>> result = JsonFieldParser.referenceOrFallback(overridable, reference, fallback);
            if (result != null) {
                return result;
            }
            throw e;
        }
    }

    @NonNull
    public static <V> Field<List<V>> readListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<V>> fallback, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        try {
            List<V> opt = JsonPropertyParser.readList(context, json, key, deserializer);
            return new Field.Value<List<V>>(overridable, opt);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            String reference = JsonFieldParser.readReference(context, json, key);
            Field<List<V>> result = JsonFieldParser.referenceOrFallback(overridable, reference, fallback);
            if (result != null) {
                return result;
            }
            throw e;
        }
    }

    @NonNull
    public static <V> Field<List<V>> readListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<V>> fallback, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer, @NonNull ListValidator<V> listValidator) {
        try {
            List<V> opt = JsonPropertyParser.readList(context, json, key, deserializer, listValidator);
            return new Field.Value<List<V>>(overridable, opt);
        }
        catch (ParsingException e) {
            JsonTemplateParserKt.suppressMissingValueOrThrow(e);
            String reference = JsonFieldParser.readReference(context, json, key);
            Field<List<V>> result = JsonFieldParser.referenceOrFallback(overridable, reference, fallback);
            if (result != null) {
                return result;
            }
            throw e;
        }
    }

    @NonNull
    public static <R, V> Field<List<V>> readOptionalListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<V>> fallback, @NonNull Function1<R, V> converter) {
        return JsonFieldParser.readOptionalListField(context, json, key, overridable, fallback, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> Field<List<V>> readOptionalListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<V>> fallback, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonFieldParser.readOptionalListField(context, json, key, overridable, fallback, converter, listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> Field<List<V>> readOptionalListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<V>> fallback, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        return JsonFieldParser.readOptionalListField(context, json, key, overridable, fallback, JsonParsers.doNotConvert(), listValidator, itemValidator);
    }

    @NonNull
    public static <R, V> Field<List<V>> readOptionalListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<V>> fallback, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        List<V> opt = JsonPropertyParser.readOptionalList(context, json, key, converter, listValidator, itemValidator);
        if (opt != null) {
            return new Field.Value<List<V>>(overridable, opt);
        }
        String reference = JsonFieldParser.readReference(context, json, key);
        if (reference != null) {
            return new Field.Reference<List<V>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <V> Field<List<V>> readOptionalListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<V>> fallback, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        List<V> opt = JsonPropertyParser.readOptionalList(context, json, key, deserializer);
        if (opt != null) {
            return new Field.Value<List<V>>(overridable, opt);
        }
        String reference = JsonFieldParser.readReference(context, json, key);
        if (reference != null) {
            return new Field.Reference<List<V>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <V> Field<List<V>> readOptionalListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, boolean overridable, @Nullable Field<List<V>> fallback, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer, @NonNull ListValidator<V> listValidator) {
        List<V> opt = JsonPropertyParser.readOptionalList(context, json, key, deserializer, listValidator);
        if (opt != null) {
            return new Field.Value<List<V>>(overridable, opt);
        }
        String reference = JsonFieldParser.readReference(context, json, key);
        if (reference != null) {
            return new Field.Reference<List<V>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <R, V> Field<ExpressionList<V>> readExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<ExpressionList<V>> fallback, @NonNull Function1<R, V> converter) {
        return JsonFieldParser.readExpressionListField(context, json, key, typeHelper, overridable, fallback, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> Field<ExpressionList<V>> readExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<ExpressionList<V>> fallback, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonFieldParser.readExpressionListField(context, json, key, typeHelper, overridable, fallback, converter, listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> Field<ExpressionList<V>> readExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<ExpressionList<V>> fallback, @NonNull ListValidator<V> listValidator) {
        return JsonFieldParser.readExpressionListField(context, json, key, typeHelper, overridable, fallback, JsonParsers.doNotConvert(), listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> Field<ExpressionList<V>> readExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<ExpressionList<V>> fallback, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        return JsonFieldParser.readExpressionListField(context, json, key, typeHelper, overridable, fallback, JsonParsers.doNotConvert(), listValidator, itemValidator);
    }

    @NonNull
    public static <R, V> Field<ExpressionList<V>> readExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<ExpressionList<V>> fallback, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        ExpressionList<V> opt = JsonExpressionParser.readOptionalExpressionList(context, json, key, typeHelper, converter, listValidator, itemValidator);
        if (opt != null) {
            return new Field.Value<ExpressionList<V>>(overridable, opt);
        }
        String reference = JsonFieldParser.readReference(context, json, key);
        if (reference != null) {
            return new Field.Reference<ExpressionList<V>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @NonNull
    public static <R, V> Field<ExpressionList<V>> readOptionalExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<ExpressionList<V>> fallback, @NonNull Function1<R, V> converter) {
        return JsonFieldParser.readOptionalExpressionListField(context, json, key, typeHelper, overridable, fallback, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> Field<ExpressionList<V>> readOptionalExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<ExpressionList<V>> fallback, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonFieldParser.readOptionalExpressionListField(context, json, key, typeHelper, overridable, fallback, converter, listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> Field<ExpressionList<V>> readOptionalExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<ExpressionList<V>> fallback, @NonNull ListValidator<V> listValidator) {
        return JsonFieldParser.readOptionalExpressionListField(context, json, key, typeHelper, overridable, fallback, JsonParsers.doNotConvert(), listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> Field<ExpressionList<V>> readOptionalExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<ExpressionList<V>> fallback, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        return JsonFieldParser.readOptionalExpressionListField(context, json, key, typeHelper, overridable, fallback, JsonParsers.doNotConvert(), listValidator, itemValidator);
    }

    @NonNull
    public static <R, V> Field<ExpressionList<V>> readOptionalExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key, @NonNull TypeHelper<V> typeHelper, boolean overridable, @Nullable Field<ExpressionList<V>> fallback, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        ExpressionList<V> opt = JsonExpressionParser.readOptionalExpressionList(context, json, key, typeHelper, converter, listValidator, itemValidator);
        if (opt != null) {
            return new Field.Value<ExpressionList<V>>(overridable, opt);
        }
        String reference = JsonFieldParser.readReference(context, json, key);
        if (reference != null) {
            return new Field.Reference<ExpressionList<V>>(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return Field.Companion.nullField(overridable);
    }

    @Nullable
    public static String readReference(@NonNull ParsingContext context, @NonNull JSONObject json, @NonNull String key) {
        return JsonPropertyParser.readOptional(context, json, '$' + key, IS_NOT_EMPTY);
    }

    @Nullable
    public static <V> Field<V> referenceOrFallback(boolean overridable, @Nullable String reference, @Nullable Field<V> fallback) {
        if (reference != null) {
            return new Field.Reference(overridable, reference);
        }
        if (fallback != null) {
            return FieldKt.clone(fallback, overridable);
        }
        return overridable ? Field.Companion.nullField(overridable) : null;
    }

    public static <V> void writeField(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Field<V> field) {
        JsonFieldParser.writeField(context, jsonObject, key, field, JsonParsers.doNotConvert());
    }

    public static <R, V> void writeField(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Field<V> field, @NonNull Function1<V, R> converter) {
        if (field instanceof Field.Value) {
            JsonPropertyParser.write(context, jsonObject, key, ((Field.Value)field).value, converter);
        } else if (field instanceof Field.Reference) {
            JsonPropertyParser.write(context, jsonObject, "$" + key, ((Field.Reference)field).reference);
        }
    }

    public static <V> void writeField(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Field<V> field, @NonNull Lazy<Serializer<JSONObject, V>> serializer) {
        if (field instanceof Field.Value) {
            JsonPropertyParser.write(context, jsonObject, key, ((Field.Value)field).value, serializer);
        } else if (field instanceof Field.Reference) {
            JsonPropertyParser.write(context, jsonObject, "$" + key, ((Field.Reference)field).reference);
        }
    }

    public static <V> void writeListField(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Field<List<V>> field) {
        JsonFieldParser.writeListField(context, jsonObject, key, field, JsonParsers.doNotConvert());
    }

    public static <R, V> void writeListField(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Field<List<V>> field, @NonNull Function1<V, R> converter) {
        if (field instanceof Field.Value) {
            JsonPropertyParser.writeList(context, jsonObject, key, (List)((Field.Value)field).value, converter);
        } else if (field instanceof Field.Reference) {
            JsonPropertyParser.write(context, jsonObject, "$" + key, ((Field.Reference)field).reference);
        }
    }

    public static <V> void writeListField(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Field<List<V>> field, @NonNull Lazy<Serializer<JSONObject, V>> serializer) {
        if (field instanceof Field.Value) {
            JsonPropertyParser.writeList(context, jsonObject, key, (List)((Field.Value)field).value, serializer);
        } else if (field instanceof Field.Reference) {
            JsonPropertyParser.write(context, jsonObject, "$" + key, ((Field.Reference)field).reference);
        }
    }

    public static <V> void writeExpressionField(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Field<Expression<V>> field) {
        JsonFieldParser.writeExpressionField(context, jsonObject, key, field, JsonParsers.doNotConvert());
    }

    public static <R, V> void writeExpressionField(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Field<Expression<V>> field, @NonNull Function1<V, R> converter) {
        if (field instanceof Field.Value) {
            JsonExpressionParser.writeExpression(context, jsonObject, key, (Expression)((Field.Value)field).value, converter);
        } else if (field instanceof Field.Reference) {
            JsonPropertyParser.write(context, jsonObject, "$" + key, ((Field.Reference)field).reference);
        }
    }

    public static <V> void writeExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Field<ExpressionList<V>> field) {
        JsonFieldParser.writeExpressionListField(context, jsonObject, key, field, JsonParsers.doNotConvert());
    }

    public static <R, V> void writeExpressionListField(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable Field<ExpressionList<V>> field, @NonNull Function1<V, R> converter) {
        if (field instanceof Field.Value) {
            JsonExpressionParser.writeExpressionList(context, jsonObject, key, (ExpressionList)((Field.Value)field).value, converter);
        } else if (field instanceof Field.Reference) {
            JsonPropertyParser.write(context, jsonObject, "$" + key, ((Field.Reference)field).reference);
        }
    }
}

