/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal.parser;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.div.data.EntityTemplate;
import com.yandex.div.internal.parser.JsonExpressionParser;
import com.yandex.div.internal.parser.JsonParsers;
import com.yandex.div.internal.parser.JsonPropertyParser;
import com.yandex.div.internal.parser.ListValidator;
import com.yandex.div.internal.parser.TypeHelper;
import com.yandex.div.internal.parser.ValueValidator;
import com.yandex.div.internal.template.Field;
import com.yandex.div.json.ParsingException;
import com.yandex.div.json.ParsingExceptionKt;
import com.yandex.div.json.expressions.Expression;
import com.yandex.div.json.expressions.ExpressionList;
import com.yandex.div.serialization.Deserializer;
import com.yandex.div.serialization.ParsingContext;
import com.yandex.div.serialization.TemplateResolver;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.jvm.functions.Function1;
import org.json.JSONObject;

public class JsonFieldResolver {
    @NonNull
    public static <V> V resolve(@NonNull ParsingContext context, @NonNull Field<V> field, @NonNull JSONObject data, @NonNull String key) {
        return JsonFieldResolver.resolve(context, field, data, key, JsonParsers.doNotConvert(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> V resolve(@NonNull ParsingContext context, @NonNull Field<V> field, @NonNull JSONObject data, @NonNull String key, @NonNull Function1<R, V> converter) {
        return JsonFieldResolver.resolve(context, field, data, key, converter, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> V resolve(@NonNull ParsingContext context, @NonNull Field<V> field, @NonNull JSONObject data, @NonNull String key, @NonNull ValueValidator<V> validator) {
        return JsonFieldResolver.resolve(context, field, data, key, JsonParsers.doNotConvert(), validator);
    }

    @NonNull
    public static <R, V> V resolve(@NonNull ParsingContext context, @NonNull Field<V> field, @NonNull JSONObject data, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        if (field.overridable && data.has(key)) {
            return JsonPropertyParser.read(context, data, key, converter, validator);
        }
        if (field.type == 2) {
            return (V)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonPropertyParser.read(context, data, reference, converter, validator);
        }
        throw ParsingExceptionKt.missingValue(data, key);
    }

    @NonNull
    public static <T extends EntityTemplate<V>, V> V resolve(@NonNull ParsingContext context, @NonNull Field<T> field, @NonNull JSONObject data, @NonNull String key, @NonNull Lazy<TemplateResolver<JSONObject, T, V>> resolver, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        if (field.overridable && data.has(key)) {
            return JsonPropertyParser.read(context, data, key, deserializer);
        }
        if (field.type == 2) {
            return JsonFieldResolver.resolveDependency(context, (EntityTemplate)((Field.Value)field).value, data, key, (TemplateResolver)resolver.getValue());
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonPropertyParser.read(context, data, reference, deserializer);
        }
        throw ParsingExceptionKt.missingValue(data, key);
    }

    @Nullable
    public static <V> V resolveOptional(@NonNull ParsingContext context, @NonNull Field<V> field, @NonNull JSONObject data, @NonNull String key) {
        return JsonFieldResolver.resolveOptional(context, field, data, key, JsonParsers.doNotConvert(), JsonParsers.alwaysValid());
    }

    @Nullable
    public static <R, V> V resolveOptional(@NonNull ParsingContext context, @NonNull Field<V> field, @NonNull JSONObject data, @NonNull String key, @NonNull Function1<R, V> converter) {
        return JsonFieldResolver.resolveOptional(context, field, data, key, converter, JsonParsers.alwaysValid());
    }

    @Nullable
    public static <V> V resolveOptional(@NonNull ParsingContext context, @NonNull Field<V> field, @NonNull JSONObject data, @NonNull String key, @NonNull ValueValidator<V> validator) {
        return JsonFieldResolver.resolveOptional(context, field, data, key, JsonParsers.doNotConvert(), validator);
    }

    @Nullable
    public static <R, V> V resolveOptional(@NonNull ParsingContext context, @NonNull Field<V> field, @NonNull JSONObject data, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        if (field.overridable && data.has(key)) {
            return JsonPropertyParser.readOptional(context, data, key, converter, validator);
        }
        if (field.type == 2) {
            return (V)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonPropertyParser.readOptional(context, data, reference, converter, validator);
        }
        return null;
    }

    @Nullable
    public static <T extends EntityTemplate<V>, V> V resolveOptional(@NonNull ParsingContext context, @NonNull Field<T> field, @NonNull JSONObject data, @NonNull String key, @NonNull Lazy<TemplateResolver<JSONObject, T, V>> resolver, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        if (field.overridable && data.has(key)) {
            return JsonPropertyParser.readOptional(context, data, key, deserializer);
        }
        if (field.type == 2) {
            return JsonFieldResolver.resolveOptionalDependency(context, (EntityTemplate)((Field.Value)field).value, data, (TemplateResolver)resolver.getValue());
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonPropertyParser.readOptional(context, data, reference, deserializer);
        }
        return null;
    }

    @NonNull
    public static <V> Expression<V> resolveExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readExpression(context, data, key, typeHelper);
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readExpression(context, data, reference, typeHelper);
        }
        throw ParsingExceptionKt.missingValue(data, key);
    }

    @NonNull
    public static <R, V> Expression<V> resolveExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readExpression(context, data, key, typeHelper, converter);
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readExpression(context, data, reference, typeHelper, converter);
        }
        throw ParsingExceptionKt.missingValue(data, key);
    }

    @NonNull
    public static <V> Expression<V> resolveExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ValueValidator<V> validator) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readExpression(context, data, key, typeHelper, validator);
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readExpression(context, data, reference, typeHelper, validator);
        }
        throw ParsingExceptionKt.missingValue(data, key);
    }

    @NonNull
    public static <R, V> Expression<V> resolveExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readExpression(context, data, key, typeHelper, converter, validator);
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readExpression(context, data, reference, typeHelper, converter, validator);
        }
        throw ParsingExceptionKt.missingValue(data, key);
    }

    @Nullable
    public static <V> Expression<V> resolveOptionalExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readOptionalExpression(context, data, key, typeHelper, JsonParsers.doNotConvert());
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readOptionalExpression(context, data, reference, typeHelper, JsonParsers.doNotConvert());
        }
        return null;
    }

    @Nullable
    public static <V> Expression<V> resolveOptionalExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @Nullable Expression<V> defaultValue) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readOptionalExpression(context, data, key, typeHelper, JsonParsers.doNotConvert(), defaultValue);
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readOptionalExpression(context, data, reference, typeHelper, JsonParsers.doNotConvert(), defaultValue);
        }
        return null;
    }

    @Nullable
    public static <R, V> Expression<V> resolveOptionalExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readOptionalExpression(context, data, key, typeHelper, converter);
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readOptionalExpression(context, data, reference, typeHelper, converter);
        }
        return null;
    }

    @Nullable
    public static <R, V> Expression<V> resolveOptionalExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @Nullable Expression<V> defaultValue) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readOptionalExpression(context, data, key, typeHelper, converter, defaultValue);
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readOptionalExpression(context, data, reference, typeHelper, converter, defaultValue);
        }
        return null;
    }

    @Nullable
    public static <V> Expression<V> resolveOptionalExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ValueValidator<V> validator) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readOptionalExpression(context, data, key, typeHelper, validator);
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readOptionalExpression(context, data, reference, typeHelper, validator);
        }
        return null;
    }

    @Nullable
    public static <V> Expression<V> resolveOptionalExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ValueValidator<V> validator, @Nullable Expression<V> defaultValue) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readOptionalExpression(context, data, key, typeHelper, validator, defaultValue);
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readOptionalExpression(context, data, reference, typeHelper, validator, defaultValue);
        }
        return null;
    }

    @Nullable
    public static <R, V> Expression<V> resolveOptionalExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readOptionalExpression(context, data, key, typeHelper, converter, validator, null);
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readOptionalExpression(context, data, reference, typeHelper, converter, validator, null);
        }
        return null;
    }

    @Nullable
    public static <R, V> Expression<V> resolveOptionalExpression(@NonNull ParsingContext context, @NonNull Field<Expression<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator, @Nullable Expression<V> defaultValue) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readOptionalExpression(context, data, key, typeHelper, converter, validator, defaultValue);
        }
        if (field.type == 2) {
            return (Expression)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readOptionalExpression(context, data, reference, typeHelper, converter, validator, defaultValue);
        }
        return null;
    }

    @NonNull
    public static <R, V> List<V> resolveList(@NonNull ParsingContext context, @NonNull Field<List<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull Function1<R, V> converter) {
        return JsonFieldResolver.resolveList(context, field, data, key, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> List<V> resolveList(@NonNull ParsingContext context, @NonNull Field<List<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonFieldResolver.resolveList(context, field, data, key, converter, listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> List<V> resolveList(@NonNull ParsingContext context, @NonNull Field<List<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull ListValidator<V> listValidator) {
        return JsonFieldResolver.resolveList(context, field, data, key, JsonParsers.doNotConvert(), listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> List<V> resolveList(@NonNull ParsingContext context, @NonNull Field<List<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        return JsonFieldResolver.resolveList(context, field, data, key, JsonParsers.doNotConvert(), listValidator, itemValidator);
    }

    @NonNull
    public static <R, V> List<V> resolveList(@NonNull ParsingContext context, @NonNull Field<List<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        if (field.overridable && data.has(key)) {
            return JsonPropertyParser.readList(context, data, key, converter, listValidator, itemValidator);
        }
        if (field.type == 2) {
            return (List)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonPropertyParser.readList(context, data, reference, converter, listValidator, itemValidator);
        }
        throw ParsingExceptionKt.missingValue(data, key);
    }

    @NonNull
    public static <T extends EntityTemplate<V>, V> List<V> resolveList(@NonNull ParsingContext context, @NonNull Field<List<T>> field, @NonNull JSONObject data, @NonNull String key, @NonNull Lazy<TemplateResolver<JSONObject, T, V>> resolver, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        if (field.overridable && data.has(key)) {
            return JsonPropertyParser.readList(context, data, key, deserializer);
        }
        if (field.type == 2) {
            List templates = (List)((Field.Value)field).value;
            int length = templates.size();
            ArrayList<V> result = new ArrayList<V>(length);
            TemplateResolver resolverLocal = (TemplateResolver)resolver.getValue();
            for (int i = 0; i < length; ++i) {
                EntityTemplate template = (EntityTemplate)templates.get(i);
                V value = JsonFieldResolver.resolveOptionalDependency(context, template, data, resolverLocal);
                if (value == null) continue;
                result.add(value);
            }
            return result;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonPropertyParser.readList(context, data, reference, deserializer);
        }
        throw ParsingExceptionKt.missingValue(data, key);
    }

    @NonNull
    public static <T extends EntityTemplate<V>, V> List<V> resolveList(@NonNull ParsingContext context, @NonNull Field<List<T>> field, @NonNull JSONObject data, @NonNull String key, @NonNull Lazy<TemplateResolver<JSONObject, T, V>> resolver, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer, @NonNull ListValidator<V> listValidator) {
        if (field.overridable && data.has(key)) {
            return JsonPropertyParser.readList(context, data, key, deserializer, listValidator);
        }
        if (field.type == 2) {
            List templates = (List)((Field.Value)field).value;
            int length = templates.size();
            ArrayList<V> result = new ArrayList<V>(length);
            TemplateResolver resolverLocal = (TemplateResolver)resolver.getValue();
            for (int i = 0; i < length; ++i) {
                EntityTemplate template = (EntityTemplate)templates.get(i);
                V value = JsonFieldResolver.resolveOptionalDependency(context, template, data, resolverLocal);
                if (value == null) continue;
                result.add(value);
            }
            if (!listValidator.isValid(result)) {
                throw ParsingExceptionKt.invalidValue(data, key, result);
            }
            return result;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonPropertyParser.readList(context, data, reference, deserializer, listValidator);
        }
        throw ParsingExceptionKt.missingValue(data, key);
    }

    @Nullable
    public static <R, V> List<V> resolveOptionalList(@NonNull ParsingContext context, @NonNull Field<List<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull Function1<R, V> converter) {
        return JsonFieldResolver.resolveOptionalList(context, field, data, key, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @Nullable
    public static <R, V> List<V> resolveOptionalList(@NonNull ParsingContext context, @NonNull Field<List<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonFieldResolver.resolveOptionalList(context, field, data, key, converter, listValidator, JsonParsers.alwaysValid());
    }

    @Nullable
    public static <V> List<V> resolveOptionalList(@NonNull ParsingContext context, @NonNull Field<List<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull ListValidator<V> listValidator) {
        return JsonFieldResolver.resolveOptionalList(context, field, data, key, JsonParsers.doNotConvert(), listValidator, JsonParsers.alwaysValid());
    }

    @Nullable
    public static <V> List<V> resolveOptionalList(@NonNull ParsingContext context, @NonNull Field<List<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        return JsonFieldResolver.resolveOptionalList(context, field, data, key, JsonParsers.doNotConvert(), listValidator, itemValidator);
    }

    @Nullable
    public static <R, V> List<V> resolveOptionalList(@NonNull ParsingContext context, @NonNull Field<List<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        Object result = null;
        if (field.overridable && data.has(key)) {
            return JsonPropertyParser.readOptionalList(context, data, key, converter, listValidator, itemValidator);
        }
        if (field.type == 2) {
            return (List)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonPropertyParser.readOptionalList(context, data, reference, converter, listValidator, itemValidator);
        }
        return null;
    }

    @Nullable
    public static <T extends EntityTemplate<V>, V> List<V> resolveOptionalList(@NonNull ParsingContext context, @NonNull Field<List<T>> field, @NonNull JSONObject data, @NonNull String key, @NonNull Lazy<TemplateResolver<JSONObject, T, V>> resolver, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        if (field.overridable && data.has(key)) {
            return JsonPropertyParser.readOptionalList(context, data, key, deserializer);
        }
        if (field.type == 2) {
            List templates = (List)((Field.Value)field).value;
            int length = templates.size();
            ArrayList<V> result = new ArrayList<V>(length);
            TemplateResolver resolverLocal = (TemplateResolver)resolver.getValue();
            for (int i = 0; i < length; ++i) {
                EntityTemplate template = (EntityTemplate)templates.get(i);
                V value = JsonFieldResolver.resolveOptionalDependency(context, template, data, resolverLocal);
                if (value == null) continue;
                result.add(value);
            }
            return result;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonPropertyParser.readOptionalList(context, data, reference, deserializer);
        }
        return null;
    }

    @Nullable
    public static <T extends EntityTemplate<V>, V> List<V> resolveOptionalList(@NonNull ParsingContext context, @NonNull Field<List<T>> field, @NonNull JSONObject data, @NonNull String key, @NonNull Lazy<TemplateResolver<JSONObject, T, V>> resolver, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer, @NonNull ListValidator<V> listValidator) {
        if (field.overridable && data.has(key)) {
            return JsonPropertyParser.readOptionalList(context, data, key, deserializer, listValidator);
        }
        if (field.type == 2) {
            List templates = (List)((Field.Value)field).value;
            int length = templates.size();
            ArrayList<V> result = new ArrayList<V>(length);
            TemplateResolver resolverLocal = (TemplateResolver)resolver.getValue();
            for (int i = 0; i < length; ++i) {
                EntityTemplate template = (EntityTemplate)templates.get(i);
                V value = JsonFieldResolver.resolveOptionalDependency(context, template, data, resolverLocal);
                if (value == null) continue;
                result.add(value);
            }
            if (!listValidator.isValid(result)) {
                context.getLogger().logError(ParsingExceptionKt.invalidValue(data, key, result));
                return null;
            }
            return result;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonPropertyParser.readOptionalList(context, data, reference, deserializer, listValidator);
        }
        return null;
    }

    @NonNull
    public static <V> ExpressionList<V> resolveExpressionList(@NonNull ParsingContext context, @NonNull Field<ExpressionList<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper) {
        return JsonFieldResolver.resolveExpressionList(context, field, data, key, typeHelper, JsonParsers.doNotConvert(), JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> ExpressionList<V> resolveExpressionList(@NonNull ParsingContext context, @NonNull Field<ExpressionList<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter) {
        return JsonFieldResolver.resolveExpressionList(context, field, data, key, typeHelper, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> ExpressionList<V> resolveExpressionList(@NonNull ParsingContext context, @NonNull Field<ExpressionList<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonFieldResolver.resolveExpressionList(context, field, data, key, typeHelper, converter, listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> ExpressionList<V> resolveExpressionList(@NonNull ParsingContext context, @NonNull Field<ExpressionList<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ListValidator<V> listValidator) {
        return JsonFieldResolver.resolveExpressionList(context, field, data, key, typeHelper, JsonParsers.doNotConvert(), listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> ExpressionList<V> resolveExpressionList(@NonNull ParsingContext context, @NonNull Field<ExpressionList<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readExpressionList(context, data, key, typeHelper, converter, listValidator, itemValidator);
        }
        if (field.type == 2) {
            return (ExpressionList)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readExpressionList(context, data, reference, typeHelper, converter, listValidator, itemValidator);
        }
        throw ParsingExceptionKt.missingValue(data, key);
    }

    @Nullable
    public static <V> ExpressionList<V> resolveOptionalExpressionList(@NonNull ParsingContext context, @NonNull Field<ExpressionList<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper) {
        return JsonFieldResolver.resolveOptionalExpressionList(context, field, data, key, typeHelper, JsonParsers.doNotConvert(), JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @Nullable
    public static <R, V> ExpressionList<V> resolveOptionalExpressionList(@NonNull ParsingContext context, @NonNull Field<ExpressionList<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter) {
        return JsonFieldResolver.resolveOptionalExpressionList(context, field, data, key, typeHelper, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @Nullable
    public static <R, V> ExpressionList<V> resolveOptionalExpressionList(@NonNull ParsingContext context, @NonNull Field<ExpressionList<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonFieldResolver.resolveOptionalExpressionList(context, field, data, key, typeHelper, converter, listValidator, JsonParsers.alwaysValid());
    }

    @Nullable
    public static <V> ExpressionList<V> resolveOptionalExpressionList(@NonNull ParsingContext context, @NonNull Field<ExpressionList<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ListValidator<V> listValidator) {
        return JsonFieldResolver.resolveOptionalExpressionList(context, field, data, key, typeHelper, JsonParsers.doNotConvert(), listValidator, JsonParsers.alwaysValid());
    }

    @Nullable
    public static <V> ExpressionList<V> resolveOptionalExpressionList(@NonNull ParsingContext context, @NonNull Field<ExpressionList<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        return JsonFieldResolver.resolveOptionalExpressionList(context, field, data, key, typeHelper, JsonParsers.doNotConvert(), listValidator, itemValidator);
    }

    @Nullable
    public static <R, V> ExpressionList<V> resolveOptionalExpressionList(@NonNull ParsingContext context, @NonNull Field<ExpressionList<V>> field, @NonNull JSONObject data, @NonNull String key, @NonNull TypeHelper<V> typeHelper, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        if (field.overridable && data.has(key)) {
            return JsonExpressionParser.readOptionalExpressionList(context, data, key, typeHelper, converter, listValidator, itemValidator);
        }
        if (field.type == 2) {
            return (ExpressionList)((Field.Value)field).value;
        }
        if (field.type == 3) {
            String reference = ((Field.Reference)field).reference;
            return JsonExpressionParser.readOptionalExpressionList(context, data, reference, typeHelper, converter, listValidator, itemValidator);
        }
        return null;
    }

    @NonNull
    private static <T extends EntityTemplate<V>, V> V resolveDependency(@NonNull ParsingContext context, @NonNull T template, @NonNull JSONObject data, @NonNull String key, @NonNull TemplateResolver<JSONObject, T, V> resolver) {
        try {
            return resolver.resolve(context, template, data);
        }
        catch (ParsingException e) {
            throw ParsingExceptionKt.dependencyFailed(data, key, e);
        }
    }

    @Nullable
    private static <T extends EntityTemplate<V>, V> V resolveOptionalDependency(@NonNull ParsingContext context, @NonNull T template, @NonNull JSONObject data, @NonNull TemplateResolver<JSONObject, T, V> resolver) {
        try {
            return resolver.resolve(context, template, data);
        }
        catch (ParsingException e) {
            context.getLogger().logError(e);
            return null;
        }
    }
}

