/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal.parser;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yandex.div.internal.parser.JsonParsers;
import com.yandex.div.internal.parser.ListValidator;
import com.yandex.div.internal.parser.ValueValidator;
import com.yandex.div.json.ParsingExceptionKt;
import com.yandex.div.serialization.Deserializer;
import com.yandex.div.serialization.ParsingContext;
import com.yandex.div.serialization.Serializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Lazy;
import kotlin.jvm.functions.Function1;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonPropertyParser {
    private JsonPropertyParser() {
    }

    @NonNull
    public static String readString(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key) {
        String result;
        Object value = JsonPropertyParser.optSafe(jsonObject, key);
        if (value == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        try {
            result = (String)value;
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, value);
        }
        catch (Exception e) {
            throw ParsingExceptionKt.invalidValue(jsonObject, key, value, (Throwable)e);
        }
        return result;
    }

    @Nullable
    public static String readOptionalString(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key) {
        Object value = JsonPropertyParser.optSafe(jsonObject, key);
        if (value == null) {
            return null;
        }
        String result = null;
        try {
            result = (String)value;
        }
        catch (ClassCastException castException) {
            context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, value));
        }
        catch (Exception e) {
            context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, value, (Throwable)e));
        }
        return result;
    }

    @NonNull
    public static <V> V read(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key) {
        return (V)JsonPropertyParser.read(context, jsonObject, key, JsonParsers.doNotConvert(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> V read(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, V> converter) {
        return JsonPropertyParser.read(context, jsonObject, key, converter, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <V> V read(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull ValueValidator<V> validator) {
        return (V)JsonPropertyParser.read(context, jsonObject, key, JsonParsers.doNotConvert(), validator);
    }

    @NonNull
    public static <R, V> V read(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        Object result;
        Object intermediate = JsonPropertyParser.optSafe(jsonObject, key);
        if (intermediate == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        try {
            result = converter.invoke(intermediate);
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate);
        }
        catch (Exception e) {
            throw ParsingExceptionKt.invalidValue(jsonObject, key, intermediate, (Throwable)e);
        }
        if (result == null) {
            throw ParsingExceptionKt.invalidValue(jsonObject, key, intermediate);
        }
        try {
            if (!validator.isValid(result)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, result);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, result);
        }
        return (V)result;
    }

    @NonNull
    public static <V> V read(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        Object result;
        JSONObject json = jsonObject.optJSONObject(key);
        if (json == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        try {
            result = ((Deserializer)deserializer.getValue()).deserialize(context, json);
        }
        catch (Exception e) {
            throw ParsingExceptionKt.dependencyFailed(jsonObject, key, e);
        }
        if (result == null) {
            throw ParsingExceptionKt.invalidValue(jsonObject, key, null);
        }
        return result;
    }

    @Nullable
    public static <V> V readOptional(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key) {
        return (V)JsonPropertyParser.readOptional(context, jsonObject, key, JsonParsers.doNotConvert(), JsonParsers.alwaysValid());
    }

    @Nullable
    public static <R, V> V readOptional(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, V> converter) {
        return JsonPropertyParser.readOptional(context, jsonObject, key, converter, JsonParsers.alwaysValid());
    }

    @Nullable
    public static <V> V readOptional(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull ValueValidator<V> validator) {
        return (V)JsonPropertyParser.readOptional(context, jsonObject, key, JsonParsers.doNotConvert(), validator);
    }

    @Nullable
    public static <R, V> V readOptional(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ValueValidator<V> validator) {
        Object intermediate = JsonPropertyParser.optSafe(jsonObject, key);
        if (intermediate == null) {
            return null;
        }
        Object result = null;
        try {
            result = converter.invoke(intermediate);
        }
        catch (ClassCastException castException) {
            context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate));
            return null;
        }
        catch (Exception e) {
            context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate, (Throwable)e));
            return null;
        }
        if (result == null) {
            context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate));
            return null;
        }
        try {
            if (!validator.isValid(result)) {
                context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, intermediate));
                return null;
            }
        }
        catch (ClassCastException castException) {
            context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, intermediate));
            return null;
        }
        return (V)result;
    }

    @Nullable
    public static <V> V readOptional(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        JSONObject json = jsonObject.optJSONObject(key);
        if (json == null) {
            return null;
        }
        try {
            return ((Deserializer)deserializer.getValue()).deserialize(context, json);
        }
        catch (Exception e) {
            context.getLogger().logError(ParsingExceptionKt.dependencyFailed(jsonObject, key, e));
            return null;
        }
    }

    @NonNull
    public static <R, V> List<V> readList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, V> converter) {
        return JsonPropertyParser.readList(context, jsonObject, key, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @NonNull
    public static List<String> readList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull ListValidator<String> listValidator) {
        return JsonPropertyParser.readList(context, jsonObject, key, JsonParsers.doNotConvert(), listValidator, JsonParsers.alwaysValidString());
    }

    @NonNull
    public static <R, V> List<V> readList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonPropertyParser.readList(context, jsonObject, key, converter, listValidator, JsonParsers.alwaysValid());
    }

    @NonNull
    public static <R, V> List<V> readList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        JSONArray array = jsonObject.optJSONArray(key);
        if (array == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        int length = array.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!listValidator.isValid(emptyList)) {
                    context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return emptyList;
                }
            }
            catch (ClassCastException castException) {
                context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return emptyList;
            }
            return emptyList;
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            block15: {
                Object intermediate = JsonPropertyParser.optSafe(array, i);
                if (intermediate == null) continue;
                try {
                    item = converter.invoke(intermediate);
                }
                catch (ClassCastException castException) {
                    context.getLogger().logError(ParsingExceptionKt.typeMismatch(array, key, i, intermediate));
                    continue;
                }
                catch (Exception e) {
                    context.getLogger().logError(ParsingExceptionKt.invalidValue(array, key, i, intermediate, e));
                    continue;
                }
                if (item == null) continue;
                try {
                    if (!itemValidator.isValid(item)) {
                        context.getLogger().logError(ParsingExceptionKt.invalidValue(array, key, i, item));
                    }
                    break block15;
                }
                catch (ClassCastException castException) {
                    context.getLogger().logError(ParsingExceptionKt.typeMismatch(array, key, i, item));
                }
                continue;
            }
            list.add(item);
        }
        try {
            if (!listValidator.isValid(list)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, list);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, list);
        }
        return list;
    }

    @NonNull
    public static <V> List<V> readList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        JSONArray array = jsonObject.optJSONArray(key);
        if (array == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        int length = array.length();
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            JSONObject json = JsonPropertyParser.nullable(array.optJSONObject(i));
            if (json == null) continue;
            try {
                item = ((Deserializer)deserializer.getValue()).deserialize(context, json);
            }
            catch (Exception e) {
                context.getLogger().logError(ParsingExceptionKt.dependencyFailed(array, key, i, e));
                continue;
            }
            if (item == null) continue;
            list.add(item);
        }
        return list;
    }

    @NonNull
    public static <V> List<V> readList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer, @NonNull ListValidator<V> listValidator) {
        JSONArray array = jsonObject.optJSONArray(key);
        if (array == null) {
            throw ParsingExceptionKt.missingValue(jsonObject, key);
        }
        int length = array.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!listValidator.isValid(emptyList)) {
                    context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return emptyList;
                }
            }
            catch (ClassCastException castException) {
                context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return emptyList;
            }
            return emptyList;
        }
        ArrayList list = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            JSONObject json = JsonPropertyParser.nullable(array.optJSONObject(i));
            if (json == null) continue;
            try {
                item = ((Deserializer)deserializer.getValue()).deserialize(context, json);
            }
            catch (Exception e) {
                context.getLogger().logError(ParsingExceptionKt.dependencyFailed(array, key, i, e));
                continue;
            }
            if (item == null) continue;
            list.add(item);
        }
        try {
            if (!listValidator.isValid(list)) {
                throw ParsingExceptionKt.invalidValue(jsonObject, key, list);
            }
        }
        catch (ClassCastException castException) {
            throw ParsingExceptionKt.typeMismatch(jsonObject, key, list);
        }
        return list;
    }

    @Nullable
    public static <R, V> List<V> readOptionalList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, V> converter) {
        return JsonPropertyParser.readOptionalList(context, jsonObject, key, converter, JsonParsers.alwaysValidList(), JsonParsers.alwaysValid());
    }

    @Nullable
    public static <R, V> List<V> readOptionalList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator) {
        return JsonPropertyParser.readOptionalList(context, jsonObject, key, converter, listValidator, JsonParsers.alwaysValid());
    }

    @Nullable
    public static <R, V> List<V> readOptionalList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Function1<R, V> converter, @NonNull ListValidator<V> listValidator, @NonNull ValueValidator<V> itemValidator) {
        JSONArray array = jsonObject.optJSONArray(key);
        if (array == null) {
            return null;
        }
        int length = array.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!listValidator.isValid(emptyList)) {
                    context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return null;
                }
            }
            catch (ClassCastException castException) {
                context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return null;
            }
            return emptyList;
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            block15: {
                Object intermediate = JsonPropertyParser.optSafe(array, i);
                if (intermediate == null) continue;
                try {
                    item = converter.invoke(intermediate);
                }
                catch (ClassCastException castException) {
                    context.getLogger().logError(ParsingExceptionKt.typeMismatch(array, key, i, intermediate));
                    continue;
                }
                catch (Exception e) {
                    context.getLogger().logError(ParsingExceptionKt.invalidValue(array, key, i, intermediate, e));
                    continue;
                }
                if (item == null) continue;
                try {
                    if (!itemValidator.isValid(item)) {
                        context.getLogger().logError(ParsingExceptionKt.invalidValue(array, key, i, item));
                    }
                    break block15;
                }
                catch (ClassCastException castException) {
                    context.getLogger().logError(ParsingExceptionKt.typeMismatch(array, key, i, item));
                }
                continue;
            }
            list.add(item);
        }
        try {
            if (!listValidator.isValid(list)) {
                context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, list));
                return null;
            }
        }
        catch (ClassCastException castException) {
            context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, list));
            return null;
        }
        return list;
    }

    @Nullable
    public static <V> List<V> readOptionalList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer) {
        JSONArray array = jsonObject.optJSONArray(key);
        if (array == null) {
            return null;
        }
        int length = array.length();
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            JSONObject json = JsonPropertyParser.nullable(array.optJSONObject(i));
            if (json == null) continue;
            try {
                item = ((Deserializer)deserializer.getValue()).deserialize(context, json);
            }
            catch (Exception e) {
                context.getLogger().logError(ParsingExceptionKt.dependencyFailed(array, key, i, e));
                continue;
            }
            if (item == null) continue;
            list.add(item);
        }
        return list;
    }

    @Nullable
    public static <V> List<V> readOptionalList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @NonNull Lazy<Deserializer<JSONObject, V>> deserializer, @NonNull ListValidator<V> listValidator) {
        JSONArray array = jsonObject.optJSONArray(key);
        if (array == null) {
            return null;
        }
        int length = array.length();
        if (length == 0) {
            List emptyList = Collections.emptyList();
            try {
                if (!listValidator.isValid(emptyList)) {
                    context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, emptyList));
                    return null;
                }
            }
            catch (ClassCastException castException) {
                context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, emptyList));
                return null;
            }
            return emptyList;
        }
        ArrayList list = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            Object item;
            JSONObject json = JsonPropertyParser.nullable(array.optJSONObject(i));
            if (json == null) continue;
            try {
                item = ((Deserializer)deserializer.getValue()).deserialize(context, json);
            }
            catch (Exception e) {
                context.getLogger().logError(ParsingExceptionKt.dependencyFailed(array, key, i, e));
                continue;
            }
            if (item == null) continue;
            list.add(item);
        }
        try {
            if (!listValidator.isValid(list)) {
                context.getLogger().logError(ParsingExceptionKt.invalidValue(jsonObject, key, list));
                return null;
            }
        }
        catch (ClassCastException castException) {
            context.getLogger().logError(ParsingExceptionKt.typeMismatch(jsonObject, key, list));
            return null;
        }
        return list;
    }

    @Nullable
    private static JSONObject nullable(@Nullable JSONObject json) {
        if (json == null || json == JSONObject.NULL) {
            return null;
        }
        return json;
    }

    @Nullable
    private static <T> T optSafe(JSONObject json, String key) {
        Object value = json.opt(key);
        if (value == JSONObject.NULL) {
            return null;
        }
        return (T)value;
    }

    @Nullable
    private static <T> T optSafe(JSONArray json, int index) {
        Object value = json.opt(index);
        if (value == JSONObject.NULL) {
            return null;
        }
        return (T)value;
    }

    public static <V> void write(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable V value) {
        JsonPropertyParser.write(context, jsonObject, key, value, JsonParsers.doNotConvert());
    }

    public static <R, V> void write(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable V value, @NonNull Function1<V, R> converter) {
        if (value != null) {
            try {
                jsonObject.put(key, converter.invoke(value));
            }
            catch (JSONException e) {
                context.getLogger().logError((Exception)((Object)e));
            }
        }
    }

    public static <V> void write(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable V value, @NonNull Lazy<Serializer<JSONObject, V>> serializer) {
        if (value != null) {
            try {
                jsonObject.put(key, ((Serializer)serializer.getValue()).serialize(context, value));
            }
            catch (JSONException e) {
                context.getLogger().logError((Exception)((Object)e));
            }
        }
    }

    public static <V> void writeList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable List<V> list) {
        JsonPropertyParser.writeList(context, jsonObject, key, list, JsonParsers.doNotConvert());
    }

    public static <R, V> void writeList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable List<V> list, @NonNull Function1<V, R> converter) {
        if (list != null && !list.isEmpty()) {
            int length = list.size();
            JSONArray array = new JSONArray();
            for (int i = 0; i < length; ++i) {
                V item = list.get(i);
                array.put(converter.invoke(item));
            }
            try {
                jsonObject.put(key, (Object)array);
            }
            catch (JSONException e) {
                context.getLogger().logError((Exception)((Object)e));
            }
        }
    }

    public static <V> void writeList(@NonNull ParsingContext context, @NonNull JSONObject jsonObject, @NonNull String key, @Nullable List<V> list, @NonNull Lazy<Serializer<JSONObject, V>> serializer) {
        if (list != null && !list.isEmpty()) {
            int length = list.size();
            JSONArray array = new JSONArray();
            for (int i = 0; i < length; ++i) {
                V item = list.get(i);
                array.put(((Serializer)serializer.getValue()).serialize(context, item));
            }
            try {
                jsonObject.put(key, (Object)array);
            }
            catch (JSONException e) {
                context.getLogger().logError((Exception)((Object)e));
            }
        }
    }
}

