/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.serialization;

import com.yandex.div.core.annotations.ExperimentalApi;
import com.yandex.div.internal.parser.JsonTopologicalSorting;
import com.yandex.div.internal.parser.TemplateParsingErrorLogger;
import com.yandex.div.internal.util.CollectionsKt;
import com.yandex.div.json.ParsingErrorLogger;
import com.yandex.div.json.ParsingException;
import com.yandex.div.json.templates.CachingTemplateProvider;
import com.yandex.div.json.templates.InMemoryTemplateProvider;
import com.yandex.div.json.templates.TemplateProvider;
import com.yandex.div.serialization.ParsingContext;
import com.yandex.div.serialization.TemplateParsingResult;
import com.yandex.div2.DivData;
import com.yandex.div2.DivDataJsonParser;
import com.yandex.div2.DivJsonParser;
import com.yandex.div2.DivPatch;
import com.yandex.div2.DivPatchJsonParser;
import com.yandex.div2.DivTemplate;
import com.yandex.div2.JsonParserComponent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/yandex/div/serialization/DivKitJsonParser;", "", "parserComponent", "Lcom/yandex/div2/JsonParserComponent;", "context", "Lcom/yandex/div/serialization/DivKitJsonParser$CachingParsingContextImpl;", "(Lcom/yandex/div2/JsonParserComponent;Lcom/yandex/div/serialization/DivKitJsonParser$CachingParsingContextImpl;)V", "deserializeData", "Lcom/yandex/div2/DivData;", "data", "Lorg/json/JSONObject;", "deserializePatch", "Lcom/yandex/div2/DivPatch;", "parseTemplates", "Lcom/yandex/div/serialization/TemplateParsingResult;", "Lcom/yandex/div2/DivTemplate;", "retainTemplates", "serializeData", "value", "serializePatch", "Builder", "CachingParsingContextImpl", "ParsingContextImpl", "div-data_release"})
@ExperimentalApi
@SourceDebugExtension(value={"SMAP\nDivKitJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DivKitJsonParser.kt\ncom/yandex/div/serialization/DivKitJsonParser\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,111:1\n215#2,2:112\n*S KotlinDebug\n*F\n+ 1 DivKitJsonParser.kt\ncom/yandex/div/serialization/DivKitJsonParser\n*L\n48#1:112,2\n*E\n"})
public final class DivKitJsonParser {
    @NotNull
    private final JsonParserComponent parserComponent;
    @NotNull
    private final CachingParsingContextImpl context;

    private DivKitJsonParser(JsonParserComponent parserComponent, CachingParsingContextImpl context) {
        this.parserComponent = parserComponent;
        this.context = context;
    }

    @NotNull
    public final DivData deserializeData(@NotNull JSONObject data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return ((DivDataJsonParser.EntityParserImpl)this.parserComponent.getDivDataJsonEntityParser().getValue()).deserialize((ParsingContext)this.context, data);
    }

    @NotNull
    public final JSONObject serializeData(@NotNull DivData value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return ((DivDataJsonParser.EntityParserImpl)this.parserComponent.getDivDataJsonEntityParser().getValue()).serialize((ParsingContext)this.context, value);
    }

    @NotNull
    public final DivPatch deserializePatch(@NotNull JSONObject data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return ((DivPatchJsonParser.EntityParserImpl)this.parserComponent.getDivPatchJsonEntityParser().getValue()).deserialize((ParsingContext)this.context, data);
    }

    @NotNull
    public final JSONObject serializePatch(@NotNull DivPatch value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return ((DivPatchJsonParser.EntityParserImpl)this.parserComponent.getDivPatchJsonEntityParser().getValue()).serialize((ParsingContext)this.context, value);
    }

    @NotNull
    public final TemplateParsingResult<DivTemplate> parseTemplates(@NotNull JSONObject data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Map templates = CollectionsKt.arrayMap();
        Map templateDependencies = CollectionsKt.arrayMap();
        try {
            Map<String, Set<String>> orderedNamesWithDependencies = JsonTopologicalSorting.INSTANCE.sort(this.context, data);
            ((CachingTemplateProvider)this.context.getTemplates()).takeSnapshot(templates);
            TemplateProvider templateProvider = TemplateProvider.Companion.wrap(templates);
            Map<String, Set<String>> $this$forEach$iv = orderedNamesWithDependencies;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Set<String>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Set<String>> element$iv;
                Map.Entry<String, Set<String>> entry = element$iv = iterator.next();
                boolean bl = false;
                String name = entry.getKey();
                Set<String> dependencies = entry.getValue();
                ParsingContextImpl templateContext = new ParsingContextImpl(templateProvider, new TemplateParsingErrorLogger(this.context.getLogger(), name));
                try {
                    DivJsonParser.TemplateParserImpl templateParserImpl = (DivJsonParser.TemplateParserImpl)this.parserComponent.getDivJsonTemplateParser().getValue();
                    ParsingContext parsingContext = templateContext;
                    JSONObject jSONObject = data.getJSONObject(name);
                    Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"data.getJSONObject(name)");
                    DivTemplate template = templateParserImpl.deserialize(parsingContext, jSONObject);
                    templates.put(name, template);
                    if (!(!((Collection)dependencies).isEmpty())) continue;
                    templateDependencies.put(name, dependencies);
                }
                catch (ParsingException e) {
                    this.context.getLogger().logTemplateError(e, name);
                }
            }
        }
        catch (Exception e) {
            this.context.getLogger().logError(e);
        }
        return new TemplateParsingResult<DivTemplate>(templates, templateDependencies);
    }

    @NotNull
    public final TemplateParsingResult<DivTemplate> retainTemplates(@NotNull JSONObject data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TemplateParsingResult<DivTemplate> result = this.parseTemplates(data);
        ((CachingTemplateProvider)this.context.getTemplates()).putAll(result.getTemplates());
        return result;
    }

    public /* synthetic */ DivKitJsonParser(JsonParserComponent parserComponent, CachingParsingContextImpl context, DefaultConstructorMarker $constructor_marker) {
        this(parserComponent, context);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/yandex/div/serialization/DivKitJsonParser$Builder;", "", "()V", "logger", "Lcom/yandex/div/json/ParsingErrorLogger;", "templateProvider", "Lcom/yandex/div/json/templates/CachingTemplateProvider;", "Lcom/yandex/div2/DivTemplate;", "build", "Lcom/yandex/div/serialization/DivKitJsonParser;", "div-data_release"})
    public static final class Builder {
        @Nullable
        private CachingTemplateProvider<DivTemplate> templateProvider;
        @NotNull
        private ParsingErrorLogger logger;

        public Builder() {
            ParsingErrorLogger parsingErrorLogger = ParsingErrorLogger.LOG;
            Intrinsics.checkNotNullExpressionValue((Object)parsingErrorLogger, (String)"LOG");
            this.logger = parsingErrorLogger;
        }

        @NotNull
        public final Builder logger(@NotNull ParsingErrorLogger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
            return this;
        }

        @NotNull
        public final DivKitJsonParser build() {
            JsonParserComponent jsonParserComponent = new JsonParserComponent();
            CachingTemplateProvider cachingTemplateProvider = this.templateProvider;
            if (cachingTemplateProvider == null) {
                cachingTemplateProvider = new CachingTemplateProvider(new InMemoryTemplateProvider(), TemplateProvider.Companion.empty());
            }
            return new DivKitJsonParser(jsonParserComponent, new CachingParsingContextImpl(cachingTemplateProvider, this.logger), null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/yandex/div/serialization/DivKitJsonParser$CachingParsingContextImpl;", "Lcom/yandex/div/serialization/ParsingContext;", "templates", "Lcom/yandex/div/json/templates/CachingTemplateProvider;", "Lcom/yandex/div2/DivTemplate;", "logger", "Lcom/yandex/div/json/ParsingErrorLogger;", "(Lcom/yandex/div/json/templates/CachingTemplateProvider;Lcom/yandex/div/json/ParsingErrorLogger;)V", "getLogger", "()Lcom/yandex/div/json/ParsingErrorLogger;", "getTemplates", "()Lcom/yandex/div/json/templates/CachingTemplateProvider;", "div-data_release"})
    private static final class CachingParsingContextImpl
    implements ParsingContext {
        @NotNull
        private final CachingTemplateProvider<DivTemplate> templates;
        @NotNull
        private final ParsingErrorLogger logger;

        public CachingParsingContextImpl(@NotNull CachingTemplateProvider<DivTemplate> templates, @NotNull ParsingErrorLogger logger) {
            Intrinsics.checkNotNullParameter(templates, (String)"templates");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.templates = templates;
            this.logger = logger;
        }

        @NotNull
        public CachingTemplateProvider<DivTemplate> getTemplates() {
            return this.templates;
        }

        @Override
        @NotNull
        public ParsingErrorLogger getLogger() {
            return this.logger;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/yandex/div/serialization/DivKitJsonParser$ParsingContextImpl;", "Lcom/yandex/div/serialization/ParsingContext;", "templates", "Lcom/yandex/div/json/templates/TemplateProvider;", "Lcom/yandex/div2/DivTemplate;", "logger", "Lcom/yandex/div/json/ParsingErrorLogger;", "(Lcom/yandex/div/json/templates/TemplateProvider;Lcom/yandex/div/json/ParsingErrorLogger;)V", "getLogger", "()Lcom/yandex/div/json/ParsingErrorLogger;", "getTemplates", "()Lcom/yandex/div/json/templates/TemplateProvider;", "div-data_release"})
    private static final class ParsingContextImpl
    implements ParsingContext {
        @NotNull
        private final TemplateProvider<DivTemplate> templates;
        @NotNull
        private final ParsingErrorLogger logger;

        public ParsingContextImpl(@NotNull TemplateProvider<? extends DivTemplate> templates, @NotNull ParsingErrorLogger logger) {
            Intrinsics.checkNotNullParameter(templates, (String)"templates");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.templates = templates;
            this.logger = logger;
        }

        @NotNull
        public TemplateProvider<DivTemplate> getTemplates() {
            return this.templates;
        }

        @Override
        @NotNull
        public ParsingErrorLogger getLogger() {
            return this.logger;
        }
    }
}

