// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivInputValidatorJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivInputValidator> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivInputValidator {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                DivInputValidatorRegex.TYPE -> return DivInputValidator.Regex(component.divInputValidatorRegexJsonEntityParser.value.deserialize(context, data))
                DivInputValidatorExpression.TYPE -> return DivInputValidator.Expression(component.divInputValidatorExpressionJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivInputValidatorTemplate
            if (template != null) {
                return component.divInputValidatorJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInputValidator): JSONObject {
            return when (value) {
                is DivInputValidator.Regex -> component.divInputValidatorRegexJsonEntityParser.value.serialize(context, value.value)
                is DivInputValidator.Expression -> component.divInputValidatorExpressionJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivInputValidatorTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivInputValidatorTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivInputValidatorTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivInputValidatorRegexTemplate.TYPE -> return DivInputValidatorTemplate.Regex(component.divInputValidatorRegexJsonTemplateParser.value.deserialize(context, parent?.value() as DivInputValidatorRegexTemplate?, data))
                DivInputValidatorExpressionTemplate.TYPE -> return DivInputValidatorTemplate.Expression(component.divInputValidatorExpressionJsonTemplateParser.value.deserialize(context, parent?.value() as DivInputValidatorExpressionTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInputValidatorTemplate): JSONObject {
            return when (value) {
                is DivInputValidatorTemplate.Regex -> component.divInputValidatorRegexJsonTemplateParser.value.serialize(context, value.value)
                is DivInputValidatorTemplate.Expression -> component.divInputValidatorExpressionJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivInputValidatorTemplate, DivInputValidator> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivInputValidatorTemplate, data: JSONObject): DivInputValidator {
            return when (template) {
                is DivInputValidatorTemplate.Regex -> DivInputValidator.Regex(component.divInputValidatorRegexJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivInputValidatorTemplate.Expression -> DivInputValidator.Expression(component.divInputValidatorExpressionJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
