// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

class DivPatch @DivModelInternalApi constructor (
    @JvmField val changes: List<Change>, // at least 1 elements
    @JvmField val mode: Expression<Mode> = MODE_DEFAULT_VALUE, // default value: partial
    @JvmField val onAppliedActions: List<DivAction>? = null,
    @JvmField val onFailedActions: List<DivAction>? = null,
) : JSONSerializable, Hashable {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            this::class.hashCode() +
            changes.sumOf { it.hash() } +
            mode.hashCode() +
            (onAppliedActions?.sumOf { it.hash() } ?: 0) +
            (onFailedActions?.sumOf { it.hash() } ?: 0)
        _hash = hash
        return hash
    }

    fun equals(other: DivPatch?, resolver: ExpressionResolver, otherResolver: ExpressionResolver): Boolean {
        other ?: return false
        return changes.compareWith(other.changes) { a, b -> a.equals(b, resolver, otherResolver) } &&
            mode.evaluate(resolver) == other.mode.evaluate(otherResolver) &&
            (onAppliedActions?.compareWith(other.onAppliedActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.onAppliedActions == null)) &&
            (onFailedActions?.compareWith(other.onFailedActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.onFailedActions == null))
    }

    fun copy(
        changes: List<Change> = this.changes,
        mode: Expression<Mode> = this.mode,
        onAppliedActions: List<DivAction>? = this.onAppliedActions,
        onFailedActions: List<DivAction>? = this.onFailedActions,
    ) = DivPatch(
        changes = changes,
        mode = mode,
        onAppliedActions = onAppliedActions,
        onFailedActions = onFailedActions,
    )

    override fun writeToJSON(): JSONObject {
        return builtInParserComponent.divPatchJsonEntityParser
            .value
            .serialize(context = builtInParsingContext, value = this)
    }

    companion object {
        private val MODE_DEFAULT_VALUE = Expression.constant(Mode.PARTIAL)

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivPatch {
            return builtInParserComponent.divPatchJsonEntityParser
                .value
                .deserialize(context = env, data = json)
        }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivPatch(env, json = it) }
    }

    enum class Mode(private val value: String) {
        TRANSACTIONAL("transactional"),
        PARTIAL("partial");

        companion object Converter {

            fun toString(obj: Mode): String {
                return obj.value
            }

            fun fromString(value: String): Mode? {
                return when (value) {
                    TRANSACTIONAL.value -> TRANSACTIONAL
                    PARTIAL.value -> PARTIAL
                    else -> null
                }
            }

            @JvmField
            val TO_STRING = { value: Mode -> toString(value) }

            @JvmField
            val FROM_STRING = { value: String -> fromString(value) }
        }
    }

    class Change @DivModelInternalApi constructor (
        @JvmField val id: String,
        @JvmField val items: List<Div>? = null,
    ) : JSONSerializable, Hashable {

        private var _propertiesHash: Int? = null 
        private var _hash: Int? = null 

        override fun propertiesHash(): Int {
            _propertiesHash?.let {
                return it
            }
            val propertiesHash = 
                this::class.hashCode() +
                id.hashCode()
            _propertiesHash = propertiesHash
            return propertiesHash
        }

        override fun hash(): Int {
            _hash?.let {
                return it
            }
            val hash = 
                propertiesHash() +
                (items?.sumOf { it.hash() } ?: 0)
            _hash = hash
            return hash
        }

        fun equals(other: Change?, resolver: ExpressionResolver, otherResolver: ExpressionResolver): Boolean {
            other ?: return false
            return id == other.id &&
                (items?.compareWith(other.items ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.items == null))
        }

        fun copy(
            id: String = this.id,
            items: List<Div>? = this.items,
        ) = Change(
            id = id,
            items = items,
        )

        override fun writeToJSON(): JSONObject {
            return builtInParserComponent.divPatchChangeJsonEntityParser
                .value
                .serialize(context = builtInParsingContext, value = this)
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Change {
                return builtInParserComponent.divPatchChangeJsonEntityParser
                    .value
                    .deserialize(context = env, data = json)
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Change(env, json = it) }
        }
    }
}
