// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, Div> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): Div {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                DivImage.TYPE -> return Div.Image(component.divImageJsonEntityParser.value.deserialize(context, data))
                DivGifImage.TYPE -> return Div.GifImage(component.divGifImageJsonEntityParser.value.deserialize(context, data))
                DivText.TYPE -> return Div.Text(component.divTextJsonEntityParser.value.deserialize(context, data))
                DivSeparator.TYPE -> return Div.Separator(component.divSeparatorJsonEntityParser.value.deserialize(context, data))
                DivContainer.TYPE -> return Div.Container(component.divContainerJsonEntityParser.value.deserialize(context, data))
                DivGrid.TYPE -> return Div.Grid(component.divGridJsonEntityParser.value.deserialize(context, data))
                DivGallery.TYPE -> return Div.Gallery(component.divGalleryJsonEntityParser.value.deserialize(context, data))
                DivPager.TYPE -> return Div.Pager(component.divPagerJsonEntityParser.value.deserialize(context, data))
                DivTabs.TYPE -> return Div.Tabs(component.divTabsJsonEntityParser.value.deserialize(context, data))
                DivState.TYPE -> return Div.State(component.divStateJsonEntityParser.value.deserialize(context, data))
                DivCustom.TYPE -> return Div.Custom(component.divCustomJsonEntityParser.value.deserialize(context, data))
                DivIndicator.TYPE -> return Div.Indicator(component.divIndicatorJsonEntityParser.value.deserialize(context, data))
                DivSlider.TYPE -> return Div.Slider(component.divSliderJsonEntityParser.value.deserialize(context, data))
                DivSwitch.TYPE -> return Div.Switch(component.divSwitchJsonEntityParser.value.deserialize(context, data))
                DivInput.TYPE -> return Div.Input(component.divInputJsonEntityParser.value.deserialize(context, data))
                DivSelect.TYPE -> return Div.Select(component.divSelectJsonEntityParser.value.deserialize(context, data))
                DivVideo.TYPE -> return Div.Video(component.divVideoJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivTemplate
            if (template != null) {
                return component.divJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: Div): JSONObject {
            return when (value) {
                is Div.Image -> component.divImageJsonEntityParser.value.serialize(context, value.value)
                is Div.GifImage -> component.divGifImageJsonEntityParser.value.serialize(context, value.value)
                is Div.Text -> component.divTextJsonEntityParser.value.serialize(context, value.value)
                is Div.Separator -> component.divSeparatorJsonEntityParser.value.serialize(context, value.value)
                is Div.Container -> component.divContainerJsonEntityParser.value.serialize(context, value.value)
                is Div.Grid -> component.divGridJsonEntityParser.value.serialize(context, value.value)
                is Div.Gallery -> component.divGalleryJsonEntityParser.value.serialize(context, value.value)
                is Div.Pager -> component.divPagerJsonEntityParser.value.serialize(context, value.value)
                is Div.Tabs -> component.divTabsJsonEntityParser.value.serialize(context, value.value)
                is Div.State -> component.divStateJsonEntityParser.value.serialize(context, value.value)
                is Div.Custom -> component.divCustomJsonEntityParser.value.serialize(context, value.value)
                is Div.Indicator -> component.divIndicatorJsonEntityParser.value.serialize(context, value.value)
                is Div.Slider -> component.divSliderJsonEntityParser.value.serialize(context, value.value)
                is Div.Switch -> component.divSwitchJsonEntityParser.value.serialize(context, value.value)
                is Div.Input -> component.divInputJsonEntityParser.value.serialize(context, value.value)
                is Div.Select -> component.divSelectJsonEntityParser.value.serialize(context, value.value)
                is Div.Video -> component.divVideoJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivImageTemplate.TYPE -> return DivTemplate.Image(component.divImageJsonTemplateParser.value.deserialize(context, parent?.value() as DivImageTemplate?, data))
                DivGifImageTemplate.TYPE -> return DivTemplate.GifImage(component.divGifImageJsonTemplateParser.value.deserialize(context, parent?.value() as DivGifImageTemplate?, data))
                DivTextTemplate.TYPE -> return DivTemplate.Text(component.divTextJsonTemplateParser.value.deserialize(context, parent?.value() as DivTextTemplate?, data))
                DivSeparatorTemplate.TYPE -> return DivTemplate.Separator(component.divSeparatorJsonTemplateParser.value.deserialize(context, parent?.value() as DivSeparatorTemplate?, data))
                DivContainerTemplate.TYPE -> return DivTemplate.Container(component.divContainerJsonTemplateParser.value.deserialize(context, parent?.value() as DivContainerTemplate?, data))
                DivGridTemplate.TYPE -> return DivTemplate.Grid(component.divGridJsonTemplateParser.value.deserialize(context, parent?.value() as DivGridTemplate?, data))
                DivGalleryTemplate.TYPE -> return DivTemplate.Gallery(component.divGalleryJsonTemplateParser.value.deserialize(context, parent?.value() as DivGalleryTemplate?, data))
                DivPagerTemplate.TYPE -> return DivTemplate.Pager(component.divPagerJsonTemplateParser.value.deserialize(context, parent?.value() as DivPagerTemplate?, data))
                DivTabsTemplate.TYPE -> return DivTemplate.Tabs(component.divTabsJsonTemplateParser.value.deserialize(context, parent?.value() as DivTabsTemplate?, data))
                DivStateTemplate.TYPE -> return DivTemplate.State(component.divStateJsonTemplateParser.value.deserialize(context, parent?.value() as DivStateTemplate?, data))
                DivCustomTemplate.TYPE -> return DivTemplate.Custom(component.divCustomJsonTemplateParser.value.deserialize(context, parent?.value() as DivCustomTemplate?, data))
                DivIndicatorTemplate.TYPE -> return DivTemplate.Indicator(component.divIndicatorJsonTemplateParser.value.deserialize(context, parent?.value() as DivIndicatorTemplate?, data))
                DivSliderTemplate.TYPE -> return DivTemplate.Slider(component.divSliderJsonTemplateParser.value.deserialize(context, parent?.value() as DivSliderTemplate?, data))
                DivSwitchTemplate.TYPE -> return DivTemplate.Switch(component.divSwitchJsonTemplateParser.value.deserialize(context, parent?.value() as DivSwitchTemplate?, data))
                DivInputTemplate.TYPE -> return DivTemplate.Input(component.divInputJsonTemplateParser.value.deserialize(context, parent?.value() as DivInputTemplate?, data))
                DivSelectTemplate.TYPE -> return DivTemplate.Select(component.divSelectJsonTemplateParser.value.deserialize(context, parent?.value() as DivSelectTemplate?, data))
                DivVideoTemplate.TYPE -> return DivTemplate.Video(component.divVideoJsonTemplateParser.value.deserialize(context, parent?.value() as DivVideoTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTemplate): JSONObject {
            return when (value) {
                is DivTemplate.Image -> component.divImageJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.GifImage -> component.divGifImageJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Text -> component.divTextJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Separator -> component.divSeparatorJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Container -> component.divContainerJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Grid -> component.divGridJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Gallery -> component.divGalleryJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Pager -> component.divPagerJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Tabs -> component.divTabsJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.State -> component.divStateJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Custom -> component.divCustomJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Indicator -> component.divIndicatorJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Slider -> component.divSliderJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Switch -> component.divSwitchJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Input -> component.divInputJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Select -> component.divSelectJsonTemplateParser.value.serialize(context, value.value)
                is DivTemplate.Video -> component.divVideoJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTemplate, Div> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTemplate, data: JSONObject): Div {
            return when (template) {
                is DivTemplate.Image -> Div.Image(component.divImageJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.GifImage -> Div.GifImage(component.divGifImageJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Text -> Div.Text(component.divTextJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Separator -> Div.Separator(component.divSeparatorJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Container -> Div.Container(component.divContainerJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Grid -> Div.Grid(component.divGridJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Gallery -> Div.Gallery(component.divGalleryJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Pager -> Div.Pager(component.divPagerJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Tabs -> Div.Tabs(component.divTabsJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.State -> Div.State(component.divStateJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Custom -> Div.Custom(component.divCustomJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Indicator -> Div.Indicator(component.divIndicatorJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Slider -> Div.Slider(component.divSliderJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Switch -> Div.Switch(component.divSwitchJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Input -> Div.Input(component.divInputJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Select -> Div.Select(component.divSelectJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTemplate.Video -> Div.Video(component.divVideoJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
