// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivTransformationJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivTransformation> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivTransformation {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                DivRotationTransformation.TYPE -> return DivTransformation.Rotation(component.divRotationTransformationJsonEntityParser.value.deserialize(context, data))
                DivTranslationTransformation.TYPE -> return DivTransformation.Translation(component.divTranslationTransformationJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivTransformationTemplate
            if (template != null) {
                return component.divTransformationJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTransformation): JSONObject {
            return when (value) {
                is DivTransformation.Rotation -> component.divRotationTransformationJsonEntityParser.value.serialize(context, value.value)
                is DivTransformation.Translation -> component.divTranslationTransformationJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivTransformationTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivTransformationTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivTransformationTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivRotationTransformationTemplate.TYPE -> return DivTransformationTemplate.Rotation(component.divRotationTransformationJsonTemplateParser.value.deserialize(context, parent?.value() as DivRotationTransformationTemplate?, data))
                DivTranslationTransformationTemplate.TYPE -> return DivTransformationTemplate.Translation(component.divTranslationTransformationJsonTemplateParser.value.deserialize(context, parent?.value() as DivTranslationTransformationTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTransformationTemplate): JSONObject {
            return when (value) {
                is DivTransformationTemplate.Rotation -> component.divRotationTransformationJsonTemplateParser.value.serialize(context, value.value)
                is DivTransformationTemplate.Translation -> component.divTranslationTransformationJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTransformationTemplate, DivTransformation> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTransformationTemplate, data: JSONObject): DivTransformation {
            return when (template) {
                is DivTransformationTemplate.Rotation -> DivTransformation.Rotation(component.divRotationTransformationJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTransformationTemplate.Translation -> DivTransformation.Translation(component.divTranslationTransformationJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
