// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivAnimatorJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivAnimator> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivAnimator {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                DivColorAnimator.TYPE -> return DivAnimator.Color(component.divColorAnimatorJsonEntityParser.value.deserialize(context, data))
                DivNumberAnimator.TYPE -> return DivAnimator.Number(component.divNumberAnimatorJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivAnimatorTemplate
            if (template != null) {
                return component.divAnimatorJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivAnimator): JSONObject {
            return when (value) {
                is DivAnimator.Color -> component.divColorAnimatorJsonEntityParser.value.serialize(context, value.value)
                is DivAnimator.Number -> component.divNumberAnimatorJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivAnimatorTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivAnimatorTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivAnimatorTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivColorAnimatorTemplate.TYPE -> return DivAnimatorTemplate.Color(component.divColorAnimatorJsonTemplateParser.value.deserialize(context, parent?.value() as DivColorAnimatorTemplate?, data))
                DivNumberAnimatorTemplate.TYPE -> return DivAnimatorTemplate.Number(component.divNumberAnimatorJsonTemplateParser.value.deserialize(context, parent?.value() as DivNumberAnimatorTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivAnimatorTemplate): JSONObject {
            return when (value) {
                is DivAnimatorTemplate.Color -> component.divColorAnimatorJsonTemplateParser.value.serialize(context, value.value)
                is DivAnimatorTemplate.Number -> component.divNumberAnimatorJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivAnimatorTemplate, DivAnimator> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivAnimatorTemplate, data: JSONObject): DivAnimator {
            return when (template) {
                is DivAnimatorTemplate.Color -> DivAnimator.Color(component.divColorAnimatorJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivAnimatorTemplate.Number -> DivAnimator.Number(component.divNumberAnimatorJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
