// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

class DivImageBackground @DivModelInternalApi constructor (
    @JvmField val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    @JvmField val contentAlignmentHorizontal: Expression<DivAlignmentHorizontal> = CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, // default value: center
    @JvmField val contentAlignmentVertical: Expression<DivAlignmentVertical> = CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, // default value: center
    @JvmField val filters: List<DivFilter>? = null,
    @JvmField val imageUrl: Expression<Uri>,
    @JvmField val preloadRequired: Expression<Boolean> = PRELOAD_REQUIRED_DEFAULT_VALUE, // default value: false
    @JvmField val scale: Expression<DivImageScale> = SCALE_DEFAULT_VALUE, // default value: fill
) : JSONSerializable, Hashable {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            this::class.hashCode() +
            alpha.hashCode() +
            contentAlignmentHorizontal.hashCode() +
            contentAlignmentVertical.hashCode() +
            (filters?.sumOf { it.hash() } ?: 0) +
            imageUrl.hashCode() +
            preloadRequired.hashCode() +
            scale.hashCode()
        _hash = hash
        return hash
    }

    fun equals(other: DivImageBackground?, resolver: ExpressionResolver, otherResolver: ExpressionResolver): Boolean {
        other ?: return false
        return alpha.evaluate(resolver) == other.alpha.evaluate(otherResolver) &&
            contentAlignmentHorizontal.evaluate(resolver) == other.contentAlignmentHorizontal.evaluate(otherResolver) &&
            contentAlignmentVertical.evaluate(resolver) == other.contentAlignmentVertical.evaluate(otherResolver) &&
            (filters?.compareWith(other.filters ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.filters == null)) &&
            imageUrl.evaluate(resolver) == other.imageUrl.evaluate(otherResolver) &&
            preloadRequired.evaluate(resolver) == other.preloadRequired.evaluate(otherResolver) &&
            scale.evaluate(resolver) == other.scale.evaluate(otherResolver)
    }

    fun copy(
        alpha: Expression<Double> = this.alpha,
        contentAlignmentHorizontal: Expression<DivAlignmentHorizontal> = this.contentAlignmentHorizontal,
        contentAlignmentVertical: Expression<DivAlignmentVertical> = this.contentAlignmentVertical,
        filters: List<DivFilter>? = this.filters,
        imageUrl: Expression<Uri> = this.imageUrl,
        preloadRequired: Expression<Boolean> = this.preloadRequired,
        scale: Expression<DivImageScale> = this.scale,
    ) = DivImageBackground(
        alpha = alpha,
        contentAlignmentHorizontal = contentAlignmentHorizontal,
        contentAlignmentVertical = contentAlignmentVertical,
        filters = filters,
        imageUrl = imageUrl,
        preloadRequired = preloadRequired,
        scale = scale,
    )

    override fun writeToJSON(): JSONObject {
        return builtInParserComponent.divImageBackgroundJsonEntityParser
            .value
            .serialize(context = builtInParsingContext, value = this)
    }

    companion object {
        const val TYPE = "image"

        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val CONTENT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.CENTER)
        private val CONTENT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.CENTER)
        private val PRELOAD_REQUIRED_DEFAULT_VALUE = Expression.constant(false)
        private val SCALE_DEFAULT_VALUE = Expression.constant(DivImageScale.FILL)

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivImageBackground {
            return builtInParserComponent.divImageBackgroundJsonEntityParser
                .value
                .deserialize(context = env, data = json)
        }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivImageBackground(env, json = it) }
    }
}
