// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivShapeJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivShape> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivShape {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                DivRoundedRectangleShape.TYPE -> return DivShape.RoundedRectangle(component.divRoundedRectangleShapeJsonEntityParser.value.deserialize(context, data))
                DivCircleShape.TYPE -> return DivShape.Circle(component.divCircleShapeJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivShapeTemplate
            if (template != null) {
                return component.divShapeJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivShape): JSONObject {
            return when (value) {
                is DivShape.RoundedRectangle -> component.divRoundedRectangleShapeJsonEntityParser.value.serialize(context, value.value)
                is DivShape.Circle -> component.divCircleShapeJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivShapeTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivShapeTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivShapeTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivRoundedRectangleShapeTemplate.TYPE -> return DivShapeTemplate.RoundedRectangle(component.divRoundedRectangleShapeJsonTemplateParser.value.deserialize(context, parent?.value() as DivRoundedRectangleShapeTemplate?, data))
                DivCircleShapeTemplate.TYPE -> return DivShapeTemplate.Circle(component.divCircleShapeJsonTemplateParser.value.deserialize(context, parent?.value() as DivCircleShapeTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivShapeTemplate): JSONObject {
            return when (value) {
                is DivShapeTemplate.RoundedRectangle -> component.divRoundedRectangleShapeJsonTemplateParser.value.serialize(context, value.value)
                is DivShapeTemplate.Circle -> component.divCircleShapeJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivShapeTemplate, DivShape> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivShapeTemplate, data: JSONObject): DivShape {
            return when (template) {
                is DivShapeTemplate.RoundedRectangle -> DivShape.RoundedRectangle(component.divRoundedRectangleShapeJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivShapeTemplate.Circle -> DivShape.Circle(component.divCircleShapeJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
