// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivTypedValueJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivTypedValue> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivTypedValue {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                StrValue.TYPE -> return DivTypedValue.Str(component.strValueJsonEntityParser.value.deserialize(context, data))
                IntegerValue.TYPE -> return DivTypedValue.Integer(component.integerValueJsonEntityParser.value.deserialize(context, data))
                NumberValue.TYPE -> return DivTypedValue.Number(component.numberValueJsonEntityParser.value.deserialize(context, data))
                ColorValue.TYPE -> return DivTypedValue.Color(component.colorValueJsonEntityParser.value.deserialize(context, data))
                BoolValue.TYPE -> return DivTypedValue.Bool(component.boolValueJsonEntityParser.value.deserialize(context, data))
                UrlValue.TYPE -> return DivTypedValue.Url(component.urlValueJsonEntityParser.value.deserialize(context, data))
                DictValue.TYPE -> return DivTypedValue.Dict(component.dictValueJsonEntityParser.value.deserialize(context, data))
                ArrayValue.TYPE -> return DivTypedValue.Array(component.arrayValueJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivTypedValueTemplate
            if (template != null) {
                return component.divTypedValueJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTypedValue): JSONObject {
            return when (value) {
                is DivTypedValue.Str -> component.strValueJsonEntityParser.value.serialize(context, value.value)
                is DivTypedValue.Integer -> component.integerValueJsonEntityParser.value.serialize(context, value.value)
                is DivTypedValue.Number -> component.numberValueJsonEntityParser.value.serialize(context, value.value)
                is DivTypedValue.Color -> component.colorValueJsonEntityParser.value.serialize(context, value.value)
                is DivTypedValue.Bool -> component.boolValueJsonEntityParser.value.serialize(context, value.value)
                is DivTypedValue.Url -> component.urlValueJsonEntityParser.value.serialize(context, value.value)
                is DivTypedValue.Dict -> component.dictValueJsonEntityParser.value.serialize(context, value.value)
                is DivTypedValue.Array -> component.arrayValueJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivTypedValueTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivTypedValueTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivTypedValueTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                StrValueTemplate.TYPE -> return DivTypedValueTemplate.Str(component.strValueJsonTemplateParser.value.deserialize(context, parent?.value() as StrValueTemplate?, data))
                IntegerValueTemplate.TYPE -> return DivTypedValueTemplate.Integer(component.integerValueJsonTemplateParser.value.deserialize(context, parent?.value() as IntegerValueTemplate?, data))
                NumberValueTemplate.TYPE -> return DivTypedValueTemplate.Number(component.numberValueJsonTemplateParser.value.deserialize(context, parent?.value() as NumberValueTemplate?, data))
                ColorValueTemplate.TYPE -> return DivTypedValueTemplate.Color(component.colorValueJsonTemplateParser.value.deserialize(context, parent?.value() as ColorValueTemplate?, data))
                BoolValueTemplate.TYPE -> return DivTypedValueTemplate.Bool(component.boolValueJsonTemplateParser.value.deserialize(context, parent?.value() as BoolValueTemplate?, data))
                UrlValueTemplate.TYPE -> return DivTypedValueTemplate.Url(component.urlValueJsonTemplateParser.value.deserialize(context, parent?.value() as UrlValueTemplate?, data))
                DictValueTemplate.TYPE -> return DivTypedValueTemplate.Dict(component.dictValueJsonTemplateParser.value.deserialize(context, parent?.value() as DictValueTemplate?, data))
                ArrayValueTemplate.TYPE -> return DivTypedValueTemplate.Array(component.arrayValueJsonTemplateParser.value.deserialize(context, parent?.value() as ArrayValueTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTypedValueTemplate): JSONObject {
            return when (value) {
                is DivTypedValueTemplate.Str -> component.strValueJsonTemplateParser.value.serialize(context, value.value)
                is DivTypedValueTemplate.Integer -> component.integerValueJsonTemplateParser.value.serialize(context, value.value)
                is DivTypedValueTemplate.Number -> component.numberValueJsonTemplateParser.value.serialize(context, value.value)
                is DivTypedValueTemplate.Color -> component.colorValueJsonTemplateParser.value.serialize(context, value.value)
                is DivTypedValueTemplate.Bool -> component.boolValueJsonTemplateParser.value.serialize(context, value.value)
                is DivTypedValueTemplate.Url -> component.urlValueJsonTemplateParser.value.serialize(context, value.value)
                is DivTypedValueTemplate.Dict -> component.dictValueJsonTemplateParser.value.serialize(context, value.value)
                is DivTypedValueTemplate.Array -> component.arrayValueJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTypedValueTemplate, DivTypedValue> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTypedValueTemplate, data: JSONObject): DivTypedValue {
            return when (template) {
                is DivTypedValueTemplate.Str -> DivTypedValue.Str(component.strValueJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTypedValueTemplate.Integer -> DivTypedValue.Integer(component.integerValueJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTypedValueTemplate.Number -> DivTypedValue.Number(component.numberValueJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTypedValueTemplate.Color -> DivTypedValue.Color(component.colorValueJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTypedValueTemplate.Bool -> DivTypedValue.Bool(component.boolValueJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTypedValueTemplate.Url -> DivTypedValue.Url(component.urlValueJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTypedValueTemplate.Dict -> DivTypedValue.Dict(component.dictValueJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTypedValueTemplate.Array -> DivTypedValue.Array(component.arrayValueJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
