// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivFilterJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivFilter> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivFilter {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                DivBlur.TYPE -> return DivFilter.Blur(component.divBlurJsonEntityParser.value.deserialize(context, data))
                DivFilterRtlMirror.TYPE -> return DivFilter.RtlMirror(component.divFilterRtlMirrorJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivFilterTemplate
            if (template != null) {
                return component.divFilterJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivFilter): JSONObject {
            return when (value) {
                is DivFilter.Blur -> component.divBlurJsonEntityParser.value.serialize(context, value.value)
                is DivFilter.RtlMirror -> component.divFilterRtlMirrorJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivFilterTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivFilterTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivFilterTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivBlurTemplate.TYPE -> return DivFilterTemplate.Blur(component.divBlurJsonTemplateParser.value.deserialize(context, parent?.value() as DivBlurTemplate?, data))
                DivFilterRtlMirrorTemplate.TYPE -> return DivFilterTemplate.RtlMirror(component.divFilterRtlMirrorJsonTemplateParser.value.deserialize(context, parent?.value() as DivFilterRtlMirrorTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivFilterTemplate): JSONObject {
            return when (value) {
                is DivFilterTemplate.Blur -> component.divBlurJsonTemplateParser.value.serialize(context, value.value)
                is DivFilterTemplate.RtlMirror -> component.divFilterRtlMirrorJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivFilterTemplate, DivFilter> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivFilterTemplate, data: JSONObject): DivFilter {
            return when (template) {
                is DivFilterTemplate.Blur -> DivFilter.Blur(component.divBlurJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivFilterTemplate.RtlMirror -> DivFilter.RtlMirror(component.divFilterRtlMirrorJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
