// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivInputFilterJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivInputFilter> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivInputFilter {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                DivInputFilterRegex.TYPE -> return DivInputFilter.Regex(component.divInputFilterRegexJsonEntityParser.value.deserialize(context, data))
                DivInputFilterExpression.TYPE -> return DivInputFilter.Expression(component.divInputFilterExpressionJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivInputFilterTemplate
            if (template != null) {
                return component.divInputFilterJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInputFilter): JSONObject {
            return when (value) {
                is DivInputFilter.Regex -> component.divInputFilterRegexJsonEntityParser.value.serialize(context, value.value)
                is DivInputFilter.Expression -> component.divInputFilterExpressionJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivInputFilterTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivInputFilterTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivInputFilterTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivInputFilterRegexTemplate.TYPE -> return DivInputFilterTemplate.Regex(component.divInputFilterRegexJsonTemplateParser.value.deserialize(context, parent?.value() as DivInputFilterRegexTemplate?, data))
                DivInputFilterExpressionTemplate.TYPE -> return DivInputFilterTemplate.Expression(component.divInputFilterExpressionJsonTemplateParser.value.deserialize(context, parent?.value() as DivInputFilterExpressionTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInputFilterTemplate): JSONObject {
            return when (value) {
                is DivInputFilterTemplate.Regex -> component.divInputFilterRegexJsonTemplateParser.value.serialize(context, value.value)
                is DivInputFilterTemplate.Expression -> component.divInputFilterExpressionJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivInputFilterTemplate, DivInputFilter> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivInputFilterTemplate, data: JSONObject): DivInputFilter {
            return when (template) {
                is DivInputFilterTemplate.Regex -> DivInputFilter.Regex(component.divInputFilterRegexJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivInputFilterTemplate.Expression -> DivInputFilter.Expression(component.divInputFilterExpressionJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
