// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivInputJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivInput> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivInput {
            return DivInput(
                accessibility = JsonPropertyParser.readOptional(context, data, "accessibility", component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonExpressionParser.readOptionalExpression(context, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonExpressionParser.readOptionalExpression(context, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonPropertyParser.readOptionalList(context, data, "animators", component.divAnimatorJsonEntityParser),
                autocapitalization = JsonExpressionParser.readOptionalExpression(context, data, "autocapitalization", TYPE_HELPER_AUTOCAPITALIZATION, DivInput.Autocapitalization.FROM_STRING, AUTOCAPITALIZATION_DEFAULT_VALUE) ?: AUTOCAPITALIZATION_DEFAULT_VALUE,
                background = JsonPropertyParser.readOptionalList(context, data, "background", component.divBackgroundJsonEntityParser),
                border = JsonPropertyParser.readOptional(context, data, "border", component.divBorderJsonEntityParser),
                columnSpan = JsonExpressionParser.readOptionalExpression(context, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonPropertyParser.readOptionalList(context, data, "disappear_actions", component.divDisappearActionJsonEntityParser),
                enterKeyActions = JsonPropertyParser.readOptionalList(context, data, "enter_key_actions", component.divActionJsonEntityParser),
                enterKeyType = JsonExpressionParser.readOptionalExpression(context, data, "enter_key_type", TYPE_HELPER_ENTER_KEY_TYPE, DivInput.EnterKeyType.FROM_STRING, ENTER_KEY_TYPE_DEFAULT_VALUE) ?: ENTER_KEY_TYPE_DEFAULT_VALUE,
                extensions = JsonPropertyParser.readOptionalList(context, data, "extensions", component.divExtensionJsonEntityParser),
                filters = JsonPropertyParser.readOptionalList(context, data, "filters", component.divInputFilterJsonEntityParser),
                focus = JsonPropertyParser.readOptional(context, data, "focus", component.divFocusJsonEntityParser),
                fontFamily = JsonExpressionParser.readOptionalExpression(context, data, "font_family", TYPE_HELPER_STRING),
                fontSize = JsonExpressionParser.readOptionalExpression(context, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, FONT_SIZE_DEFAULT_VALUE) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonExpressionParser.readOptionalExpression(context, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontVariationSettings = JsonExpressionParser.readOptionalExpression(context, data, "font_variation_settings", TYPE_HELPER_DICT),
                fontWeight = JsonExpressionParser.readOptionalExpression(context, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING),
                fontWeightValue = JsonExpressionParser.readOptionalExpression(context, data, "font_weight_value", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                functions = JsonPropertyParser.readOptionalList(context, data, "functions", component.divFunctionJsonEntityParser),
                height = JsonPropertyParser.readOptional(context, data, "height", component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                highlightColor = JsonExpressionParser.readOptionalExpression(context, data, "highlight_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                hintColor = JsonExpressionParser.readOptionalExpression(context, data, "hint_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, HINT_COLOR_DEFAULT_VALUE) ?: HINT_COLOR_DEFAULT_VALUE,
                hintText = JsonExpressionParser.readOptionalExpression(context, data, "hint_text", TYPE_HELPER_STRING),
                id = JsonPropertyParser.readOptional(context, data, "id"),
                isEnabled = JsonExpressionParser.readOptionalExpression(context, data, "is_enabled", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, IS_ENABLED_DEFAULT_VALUE) ?: IS_ENABLED_DEFAULT_VALUE,
                keyboardType = JsonExpressionParser.readOptionalExpression(context, data, "keyboard_type", TYPE_HELPER_KEYBOARD_TYPE, DivInput.KeyboardType.FROM_STRING, KEYBOARD_TYPE_DEFAULT_VALUE) ?: KEYBOARD_TYPE_DEFAULT_VALUE,
                layoutProvider = JsonPropertyParser.readOptional(context, data, "layout_provider", component.divLayoutProviderJsonEntityParser),
                letterSpacing = JsonExpressionParser.readOptionalExpression(context, data, "letter_spacing", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, LETTER_SPACING_DEFAULT_VALUE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonExpressionParser.readOptionalExpression(context, data, "line_height", TYPE_HELPER_INT, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                margins = JsonPropertyParser.readOptional(context, data, "margins", component.divEdgeInsetsJsonEntityParser),
                mask = JsonPropertyParser.readOptional(context, data, "mask", component.divInputMaskJsonEntityParser),
                maxLength = JsonExpressionParser.readOptionalExpression(context, data, "max_length", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_LENGTH_VALIDATOR),
                maxVisibleLines = JsonExpressionParser.readOptionalExpression(context, data, "max_visible_lines", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_VISIBLE_LINES_VALIDATOR),
                nativeInterface = JsonPropertyParser.readOptional(context, data, "native_interface", component.divInputNativeInterfaceJsonEntityParser),
                paddings = JsonPropertyParser.readOptional(context, data, "paddings", component.divEdgeInsetsJsonEntityParser),
                reuseId = JsonExpressionParser.readOptionalExpression(context, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonExpressionParser.readOptionalExpression(context, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectAllOnFocus = JsonExpressionParser.readOptionalExpression(context, data, "select_all_on_focus", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SELECT_ALL_ON_FOCUS_DEFAULT_VALUE) ?: SELECT_ALL_ON_FOCUS_DEFAULT_VALUE,
                selectedActions = JsonPropertyParser.readOptionalList(context, data, "selected_actions", component.divActionJsonEntityParser),
                textAlignmentHorizontal = JsonExpressionParser.readOptionalExpression(context, data, "text_alignment_horizontal", TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING, TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                textAlignmentVertical = JsonExpressionParser.readOptionalExpression(context, data, "text_alignment_vertical", TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING, TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                textColor = JsonExpressionParser.readOptionalExpression(context, data, "text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, TEXT_COLOR_DEFAULT_VALUE) ?: TEXT_COLOR_DEFAULT_VALUE,
                textVariable = JsonPropertyParser.read(context, data, "text_variable"),
                tooltips = JsonPropertyParser.readOptionalList(context, data, "tooltips", component.divTooltipJsonEntityParser),
                transform = JsonPropertyParser.readOptional(context, data, "transform", component.divTransformJsonEntityParser),
                transformations = JsonPropertyParser.readOptionalList(context, data, "transformations", component.divTransformationJsonEntityParser),
                transitionChange = JsonPropertyParser.readOptional(context, data, "transition_change", component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonPropertyParser.readOptional(context, data, "transition_in", component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonPropertyParser.readOptional(context, data, "transition_out", component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonPropertyParser.readOptionalList(context, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                validators = JsonPropertyParser.readOptionalList(context, data, "validators", component.divInputValidatorJsonEntityParser),
                variableTriggers = JsonPropertyParser.readOptionalList(context, data, "variable_triggers", component.divTriggerJsonEntityParser),
                variables = JsonPropertyParser.readOptionalList(context, data, "variables", component.divVariableJsonEntityParser),
                visibility = JsonExpressionParser.readOptionalExpression(context, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonPropertyParser.readOptional(context, data, "visibility_action", component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonPropertyParser.readOptionalList(context, data, "visibility_actions", component.divVisibilityActionJsonEntityParser),
                width = JsonPropertyParser.readOptional(context, data, "width", component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInput): JSONObject {
            val data = JSONObject()
            JsonPropertyParser.write(context, data, "accessibility", value.accessibility, component.divAccessibilityJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "alignment_horizontal", value.alignmentHorizontal, DivAlignmentHorizontal.TO_STRING)
            JsonExpressionParser.writeExpression(context, data, "alignment_vertical", value.alignmentVertical, DivAlignmentVertical.TO_STRING)
            JsonExpressionParser.writeExpression(context, data, "alpha", value.alpha)
            JsonPropertyParser.writeList(context, data, "animators", value.animators, component.divAnimatorJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "autocapitalization", value.autocapitalization, DivInput.Autocapitalization.TO_STRING)
            JsonPropertyParser.writeList(context, data, "background", value.background, component.divBackgroundJsonEntityParser)
            JsonPropertyParser.write(context, data, "border", value.border, component.divBorderJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "column_span", value.columnSpan)
            JsonPropertyParser.writeList(context, data, "disappear_actions", value.disappearActions, component.divDisappearActionJsonEntityParser)
            JsonPropertyParser.writeList(context, data, "enter_key_actions", value.enterKeyActions, component.divActionJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "enter_key_type", value.enterKeyType, DivInput.EnterKeyType.TO_STRING)
            JsonPropertyParser.writeList(context, data, "extensions", value.extensions, component.divExtensionJsonEntityParser)
            JsonPropertyParser.writeList(context, data, "filters", value.filters, component.divInputFilterJsonEntityParser)
            JsonPropertyParser.write(context, data, "focus", value.focus, component.divFocusJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "font_family", value.fontFamily)
            JsonExpressionParser.writeExpression(context, data, "font_size", value.fontSize)
            JsonExpressionParser.writeExpression(context, data, "font_size_unit", value.fontSizeUnit, DivSizeUnit.TO_STRING)
            JsonExpressionParser.writeExpression(context, data, "font_variation_settings", value.fontVariationSettings)
            JsonExpressionParser.writeExpression(context, data, "font_weight", value.fontWeight, DivFontWeight.TO_STRING)
            JsonExpressionParser.writeExpression(context, data, "font_weight_value", value.fontWeightValue)
            JsonPropertyParser.writeList(context, data, "functions", value.functions, component.divFunctionJsonEntityParser)
            JsonPropertyParser.write(context, data, "height", value.height, component.divSizeJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "highlight_color", value.highlightColor, COLOR_INT_TO_STRING)
            JsonExpressionParser.writeExpression(context, data, "hint_color", value.hintColor, COLOR_INT_TO_STRING)
            JsonExpressionParser.writeExpression(context, data, "hint_text", value.hintText)
            JsonPropertyParser.write(context, data, "id", value.id)
            JsonExpressionParser.writeExpression(context, data, "is_enabled", value.isEnabled)
            JsonExpressionParser.writeExpression(context, data, "keyboard_type", value.keyboardType, DivInput.KeyboardType.TO_STRING)
            JsonPropertyParser.write(context, data, "layout_provider", value.layoutProvider, component.divLayoutProviderJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "letter_spacing", value.letterSpacing)
            JsonExpressionParser.writeExpression(context, data, "line_height", value.lineHeight)
            JsonPropertyParser.write(context, data, "margins", value.margins, component.divEdgeInsetsJsonEntityParser)
            JsonPropertyParser.write(context, data, "mask", value.mask, component.divInputMaskJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "max_length", value.maxLength)
            JsonExpressionParser.writeExpression(context, data, "max_visible_lines", value.maxVisibleLines)
            JsonPropertyParser.write(context, data, "native_interface", value.nativeInterface, component.divInputNativeInterfaceJsonEntityParser)
            JsonPropertyParser.write(context, data, "paddings", value.paddings, component.divEdgeInsetsJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "reuse_id", value.reuseId)
            JsonExpressionParser.writeExpression(context, data, "row_span", value.rowSpan)
            JsonExpressionParser.writeExpression(context, data, "select_all_on_focus", value.selectAllOnFocus)
            JsonPropertyParser.writeList(context, data, "selected_actions", value.selectedActions, component.divActionJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "text_alignment_horizontal", value.textAlignmentHorizontal, DivAlignmentHorizontal.TO_STRING)
            JsonExpressionParser.writeExpression(context, data, "text_alignment_vertical", value.textAlignmentVertical, DivAlignmentVertical.TO_STRING)
            JsonExpressionParser.writeExpression(context, data, "text_color", value.textColor, COLOR_INT_TO_STRING)
            JsonPropertyParser.write(context, data, "text_variable", value.textVariable)
            JsonPropertyParser.writeList(context, data, "tooltips", value.tooltips, component.divTooltipJsonEntityParser)
            JsonPropertyParser.write(context, data, "transform", value.transform, component.divTransformJsonEntityParser)
            JsonPropertyParser.writeList(context, data, "transformations", value.transformations, component.divTransformationJsonEntityParser)
            JsonPropertyParser.write(context, data, "transition_change", value.transitionChange, component.divChangeTransitionJsonEntityParser)
            JsonPropertyParser.write(context, data, "transition_in", value.transitionIn, component.divAppearanceTransitionJsonEntityParser)
            JsonPropertyParser.write(context, data, "transition_out", value.transitionOut, component.divAppearanceTransitionJsonEntityParser)
            JsonPropertyParser.writeList(context, data, "transition_triggers", value.transitionTriggers, DivTransitionTrigger.TO_STRING)
            JsonPropertyParser.write(context, data, "type", DivInput.TYPE)
            JsonPropertyParser.writeList(context, data, "validators", value.validators, component.divInputValidatorJsonEntityParser)
            JsonPropertyParser.writeList(context, data, "variable_triggers", value.variableTriggers, component.divTriggerJsonEntityParser)
            JsonPropertyParser.writeList(context, data, "variables", value.variables, component.divVariableJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "visibility", value.visibility, DivVisibility.TO_STRING)
            JsonPropertyParser.write(context, data, "visibility_action", value.visibilityAction, component.divVisibilityActionJsonEntityParser)
            JsonPropertyParser.writeList(context, data, "visibility_actions", value.visibilityActions, component.divVisibilityActionJsonEntityParser)
            JsonPropertyParser.write(context, data, "width", value.width, component.divSizeJsonEntityParser)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivInputTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivInputTemplate?, data: JSONObject): DivInputTemplate {
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivInputTemplate(
                accessibility = JsonFieldParser.readOptionalField(context, data, "accessibility", allowOverride, parent?.accessibility, component.divAccessibilityJsonTemplateParser),
                alignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, allowOverride, parent?.alignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, allowOverride, parent?.alignmentVertical, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldParser.readOptionalFieldWithExpression(context, data, "alpha", TYPE_HELPER_DOUBLE, allowOverride, parent?.alpha, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR),
                animators = JsonFieldParser.readOptionalListField(context, data, "animators", allowOverride, parent?.animators, component.divAnimatorJsonTemplateParser),
                autocapitalization = JsonFieldParser.readOptionalFieldWithExpression(context, data, "autocapitalization", TYPE_HELPER_AUTOCAPITALIZATION, allowOverride, parent?.autocapitalization, DivInput.Autocapitalization.FROM_STRING),
                background = JsonFieldParser.readOptionalListField(context, data, "background", allowOverride, parent?.background, component.divBackgroundJsonTemplateParser),
                border = JsonFieldParser.readOptionalField(context, data, "border", allowOverride, parent?.border, component.divBorderJsonTemplateParser),
                columnSpan = JsonFieldParser.readOptionalFieldWithExpression(context, data, "column_span", TYPE_HELPER_INT, allowOverride, parent?.columnSpan, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldParser.readOptionalListField(context, data, "disappear_actions", allowOverride, parent?.disappearActions, component.divDisappearActionJsonTemplateParser),
                enterKeyActions = JsonFieldParser.readOptionalListField(context, data, "enter_key_actions", allowOverride, parent?.enterKeyActions, component.divActionJsonTemplateParser),
                enterKeyType = JsonFieldParser.readOptionalFieldWithExpression(context, data, "enter_key_type", TYPE_HELPER_ENTER_KEY_TYPE, allowOverride, parent?.enterKeyType, DivInput.EnterKeyType.FROM_STRING),
                extensions = JsonFieldParser.readOptionalListField(context, data, "extensions", allowOverride, parent?.extensions, component.divExtensionJsonTemplateParser),
                filters = JsonFieldParser.readOptionalListField(context, data, "filters", allowOverride, parent?.filters, component.divInputFilterJsonTemplateParser),
                focus = JsonFieldParser.readOptionalField(context, data, "focus", allowOverride, parent?.focus, component.divFocusJsonTemplateParser),
                fontFamily = JsonFieldParser.readOptionalFieldWithExpression(context, data, "font_family", TYPE_HELPER_STRING, allowOverride, parent?.fontFamily),
                fontSize = JsonFieldParser.readOptionalFieldWithExpression(context, data, "font_size", TYPE_HELPER_INT, allowOverride, parent?.fontSize, NUMBER_TO_INT, FONT_SIZE_VALIDATOR),
                fontSizeUnit = JsonFieldParser.readOptionalFieldWithExpression(context, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, allowOverride, parent?.fontSizeUnit, DivSizeUnit.FROM_STRING),
                fontVariationSettings = JsonFieldParser.readOptionalFieldWithExpression(context, data, "font_variation_settings", TYPE_HELPER_DICT, allowOverride, parent?.fontVariationSettings),
                fontWeight = JsonFieldParser.readOptionalFieldWithExpression(context, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, allowOverride, parent?.fontWeight, DivFontWeight.FROM_STRING),
                fontWeightValue = JsonFieldParser.readOptionalFieldWithExpression(context, data, "font_weight_value", TYPE_HELPER_INT, allowOverride, parent?.fontWeightValue, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                functions = JsonFieldParser.readOptionalListField(context, data, "functions", allowOverride, parent?.functions, component.divFunctionJsonTemplateParser),
                height = JsonFieldParser.readOptionalField(context, data, "height", allowOverride, parent?.height, component.divSizeJsonTemplateParser),
                highlightColor = JsonFieldParser.readOptionalFieldWithExpression(context, data, "highlight_color", TYPE_HELPER_COLOR, allowOverride, parent?.highlightColor, STRING_TO_COLOR_INT),
                hintColor = JsonFieldParser.readOptionalFieldWithExpression(context, data, "hint_color", TYPE_HELPER_COLOR, allowOverride, parent?.hintColor, STRING_TO_COLOR_INT),
                hintText = JsonFieldParser.readOptionalFieldWithExpression(context, data, "hint_text", TYPE_HELPER_STRING, allowOverride, parent?.hintText),
                id = JsonFieldParser.readOptionalField(context, data, "id", allowOverride, parent?.id),
                isEnabled = JsonFieldParser.readOptionalFieldWithExpression(context, data, "is_enabled", TYPE_HELPER_BOOLEAN, allowOverride, parent?.isEnabled, ANY_TO_BOOLEAN),
                keyboardType = JsonFieldParser.readOptionalFieldWithExpression(context, data, "keyboard_type", TYPE_HELPER_KEYBOARD_TYPE, allowOverride, parent?.keyboardType, DivInput.KeyboardType.FROM_STRING),
                layoutProvider = JsonFieldParser.readOptionalField(context, data, "layout_provider", allowOverride, parent?.layoutProvider, component.divLayoutProviderJsonTemplateParser),
                letterSpacing = JsonFieldParser.readOptionalFieldWithExpression(context, data, "letter_spacing", TYPE_HELPER_DOUBLE, allowOverride, parent?.letterSpacing, NUMBER_TO_DOUBLE),
                lineHeight = JsonFieldParser.readOptionalFieldWithExpression(context, data, "line_height", TYPE_HELPER_INT, allowOverride, parent?.lineHeight, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                margins = JsonFieldParser.readOptionalField(context, data, "margins", allowOverride, parent?.margins, component.divEdgeInsetsJsonTemplateParser),
                mask = JsonFieldParser.readOptionalField(context, data, "mask", allowOverride, parent?.mask, component.divInputMaskJsonTemplateParser),
                maxLength = JsonFieldParser.readOptionalFieldWithExpression(context, data, "max_length", TYPE_HELPER_INT, allowOverride, parent?.maxLength, NUMBER_TO_INT, MAX_LENGTH_VALIDATOR),
                maxVisibleLines = JsonFieldParser.readOptionalFieldWithExpression(context, data, "max_visible_lines", TYPE_HELPER_INT, allowOverride, parent?.maxVisibleLines, NUMBER_TO_INT, MAX_VISIBLE_LINES_VALIDATOR),
                nativeInterface = JsonFieldParser.readOptionalField(context, data, "native_interface", allowOverride, parent?.nativeInterface, component.divInputNativeInterfaceJsonTemplateParser),
                paddings = JsonFieldParser.readOptionalField(context, data, "paddings", allowOverride, parent?.paddings, component.divEdgeInsetsJsonTemplateParser),
                reuseId = JsonFieldParser.readOptionalFieldWithExpression(context, data, "reuse_id", TYPE_HELPER_STRING, allowOverride, parent?.reuseId),
                rowSpan = JsonFieldParser.readOptionalFieldWithExpression(context, data, "row_span", TYPE_HELPER_INT, allowOverride, parent?.rowSpan, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectAllOnFocus = JsonFieldParser.readOptionalFieldWithExpression(context, data, "select_all_on_focus", TYPE_HELPER_BOOLEAN, allowOverride, parent?.selectAllOnFocus, ANY_TO_BOOLEAN),
                selectedActions = JsonFieldParser.readOptionalListField(context, data, "selected_actions", allowOverride, parent?.selectedActions, component.divActionJsonTemplateParser),
                textAlignmentHorizontal = JsonFieldParser.readOptionalFieldWithExpression(context, data, "text_alignment_horizontal", TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL, allowOverride, parent?.textAlignmentHorizontal, DivAlignmentHorizontal.FROM_STRING),
                textAlignmentVertical = JsonFieldParser.readOptionalFieldWithExpression(context, data, "text_alignment_vertical", TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL, allowOverride, parent?.textAlignmentVertical, DivAlignmentVertical.FROM_STRING),
                textColor = JsonFieldParser.readOptionalFieldWithExpression(context, data, "text_color", TYPE_HELPER_COLOR, allowOverride, parent?.textColor, STRING_TO_COLOR_INT),
                textVariable = JsonFieldParser.readField(context, data, "text_variable", allowOverride, parent?.textVariable),
                tooltips = JsonFieldParser.readOptionalListField(context, data, "tooltips", allowOverride, parent?.tooltips, component.divTooltipJsonTemplateParser),
                transform = JsonFieldParser.readOptionalField(context, data, "transform", allowOverride, parent?.transform, component.divTransformJsonTemplateParser),
                transformations = JsonFieldParser.readOptionalListField(context, data, "transformations", allowOverride, parent?.transformations, component.divTransformationJsonTemplateParser),
                transitionChange = JsonFieldParser.readOptionalField(context, data, "transition_change", allowOverride, parent?.transitionChange, component.divChangeTransitionJsonTemplateParser),
                transitionIn = JsonFieldParser.readOptionalField(context, data, "transition_in", allowOverride, parent?.transitionIn, component.divAppearanceTransitionJsonTemplateParser),
                transitionOut = JsonFieldParser.readOptionalField(context, data, "transition_out", allowOverride, parent?.transitionOut, component.divAppearanceTransitionJsonTemplateParser),
                transitionTriggers = JsonFieldParser.readOptionalListField(context, data, "transition_triggers", allowOverride, parent?.transitionTriggers, DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR.cast()),
                validators = JsonFieldParser.readOptionalListField(context, data, "validators", allowOverride, parent?.validators, component.divInputValidatorJsonTemplateParser),
                variableTriggers = JsonFieldParser.readOptionalListField(context, data, "variable_triggers", allowOverride, parent?.variableTriggers, component.divTriggerJsonTemplateParser),
                variables = JsonFieldParser.readOptionalListField(context, data, "variables", allowOverride, parent?.variables, component.divVariableJsonTemplateParser),
                visibility = JsonFieldParser.readOptionalFieldWithExpression(context, data, "visibility", TYPE_HELPER_VISIBILITY, allowOverride, parent?.visibility, DivVisibility.FROM_STRING),
                visibilityAction = JsonFieldParser.readOptionalField(context, data, "visibility_action", allowOverride, parent?.visibilityAction, component.divVisibilityActionJsonTemplateParser),
                visibilityActions = JsonFieldParser.readOptionalListField(context, data, "visibility_actions", allowOverride, parent?.visibilityActions, component.divVisibilityActionJsonTemplateParser),
                width = JsonFieldParser.readOptionalField(context, data, "width", allowOverride, parent?.width, component.divSizeJsonTemplateParser),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInputTemplate): JSONObject {
            val data = JSONObject()
            JsonFieldParser.writeField(context, data, "accessibility", value.accessibility, component.divAccessibilityJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "alignment_horizontal", value.alignmentHorizontal, DivAlignmentHorizontal.TO_STRING)
            JsonFieldParser.writeExpressionField(context, data, "alignment_vertical", value.alignmentVertical, DivAlignmentVertical.TO_STRING)
            JsonFieldParser.writeExpressionField(context, data, "alpha", value.alpha)
            JsonFieldParser.writeListField(context, data, "animators", value.animators, component.divAnimatorJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "autocapitalization", value.autocapitalization, DivInput.Autocapitalization.TO_STRING)
            JsonFieldParser.writeListField(context, data, "background", value.background, component.divBackgroundJsonTemplateParser)
            JsonFieldParser.writeField(context, data, "border", value.border, component.divBorderJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "column_span", value.columnSpan)
            JsonFieldParser.writeListField(context, data, "disappear_actions", value.disappearActions, component.divDisappearActionJsonTemplateParser)
            JsonFieldParser.writeListField(context, data, "enter_key_actions", value.enterKeyActions, component.divActionJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "enter_key_type", value.enterKeyType, DivInput.EnterKeyType.TO_STRING)
            JsonFieldParser.writeListField(context, data, "extensions", value.extensions, component.divExtensionJsonTemplateParser)
            JsonFieldParser.writeListField(context, data, "filters", value.filters, component.divInputFilterJsonTemplateParser)
            JsonFieldParser.writeField(context, data, "focus", value.focus, component.divFocusJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "font_family", value.fontFamily)
            JsonFieldParser.writeExpressionField(context, data, "font_size", value.fontSize)
            JsonFieldParser.writeExpressionField(context, data, "font_size_unit", value.fontSizeUnit, DivSizeUnit.TO_STRING)
            JsonFieldParser.writeExpressionField(context, data, "font_variation_settings", value.fontVariationSettings)
            JsonFieldParser.writeExpressionField(context, data, "font_weight", value.fontWeight, DivFontWeight.TO_STRING)
            JsonFieldParser.writeExpressionField(context, data, "font_weight_value", value.fontWeightValue)
            JsonFieldParser.writeListField(context, data, "functions", value.functions, component.divFunctionJsonTemplateParser)
            JsonFieldParser.writeField(context, data, "height", value.height, component.divSizeJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "highlight_color", value.highlightColor, COLOR_INT_TO_STRING)
            JsonFieldParser.writeExpressionField(context, data, "hint_color", value.hintColor, COLOR_INT_TO_STRING)
            JsonFieldParser.writeExpressionField(context, data, "hint_text", value.hintText)
            JsonFieldParser.writeField(context, data, "id", value.id)
            JsonFieldParser.writeExpressionField(context, data, "is_enabled", value.isEnabled)
            JsonFieldParser.writeExpressionField(context, data, "keyboard_type", value.keyboardType, DivInput.KeyboardType.TO_STRING)
            JsonFieldParser.writeField(context, data, "layout_provider", value.layoutProvider, component.divLayoutProviderJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "letter_spacing", value.letterSpacing)
            JsonFieldParser.writeExpressionField(context, data, "line_height", value.lineHeight)
            JsonFieldParser.writeField(context, data, "margins", value.margins, component.divEdgeInsetsJsonTemplateParser)
            JsonFieldParser.writeField(context, data, "mask", value.mask, component.divInputMaskJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "max_length", value.maxLength)
            JsonFieldParser.writeExpressionField(context, data, "max_visible_lines", value.maxVisibleLines)
            JsonFieldParser.writeField(context, data, "native_interface", value.nativeInterface, component.divInputNativeInterfaceJsonTemplateParser)
            JsonFieldParser.writeField(context, data, "paddings", value.paddings, component.divEdgeInsetsJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "reuse_id", value.reuseId)
            JsonFieldParser.writeExpressionField(context, data, "row_span", value.rowSpan)
            JsonFieldParser.writeExpressionField(context, data, "select_all_on_focus", value.selectAllOnFocus)
            JsonFieldParser.writeListField(context, data, "selected_actions", value.selectedActions, component.divActionJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "text_alignment_horizontal", value.textAlignmentHorizontal, DivAlignmentHorizontal.TO_STRING)
            JsonFieldParser.writeExpressionField(context, data, "text_alignment_vertical", value.textAlignmentVertical, DivAlignmentVertical.TO_STRING)
            JsonFieldParser.writeExpressionField(context, data, "text_color", value.textColor, COLOR_INT_TO_STRING)
            JsonFieldParser.writeField(context, data, "text_variable", value.textVariable)
            JsonFieldParser.writeListField(context, data, "tooltips", value.tooltips, component.divTooltipJsonTemplateParser)
            JsonFieldParser.writeField(context, data, "transform", value.transform, component.divTransformJsonTemplateParser)
            JsonFieldParser.writeListField(context, data, "transformations", value.transformations, component.divTransformationJsonTemplateParser)
            JsonFieldParser.writeField(context, data, "transition_change", value.transitionChange, component.divChangeTransitionJsonTemplateParser)
            JsonFieldParser.writeField(context, data, "transition_in", value.transitionIn, component.divAppearanceTransitionJsonTemplateParser)
            JsonFieldParser.writeField(context, data, "transition_out", value.transitionOut, component.divAppearanceTransitionJsonTemplateParser)
            JsonFieldParser.writeListField(context, data, "transition_triggers", value.transitionTriggers, DivTransitionTrigger.TO_STRING)
            JsonPropertyParser.write(context, data, "type", DivInput.TYPE)
            JsonFieldParser.writeListField(context, data, "validators", value.validators, component.divInputValidatorJsonTemplateParser)
            JsonFieldParser.writeListField(context, data, "variable_triggers", value.variableTriggers, component.divTriggerJsonTemplateParser)
            JsonFieldParser.writeListField(context, data, "variables", value.variables, component.divVariableJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "visibility", value.visibility, DivVisibility.TO_STRING)
            JsonFieldParser.writeField(context, data, "visibility_action", value.visibilityAction, component.divVisibilityActionJsonTemplateParser)
            JsonFieldParser.writeListField(context, data, "visibility_actions", value.visibilityActions, component.divVisibilityActionJsonTemplateParser)
            JsonFieldParser.writeField(context, data, "width", value.width, component.divSizeJsonTemplateParser)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivInputTemplate, DivInput> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivInputTemplate, data: JSONObject): DivInput {
            return DivInput(
                accessibility = JsonFieldResolver.resolveOptional(context, template.accessibility, data, "accessibility", component.divAccessibilityJsonTemplateResolver, component.divAccessibilityJsonEntityParser),
                alignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, template.alignmentHorizontal, data, "alignment_horizontal", TYPE_HELPER_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING),
                alignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, template.alignmentVertical, data, "alignment_vertical", TYPE_HELPER_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING),
                alpha = JsonFieldResolver.resolveOptionalExpression(context, template.alpha, data, "alpha", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, ALPHA_VALIDATOR, ALPHA_DEFAULT_VALUE) ?: ALPHA_DEFAULT_VALUE,
                animators = JsonFieldResolver.resolveOptionalList(context, template.animators, data, "animators", component.divAnimatorJsonTemplateResolver, component.divAnimatorJsonEntityParser),
                autocapitalization = JsonFieldResolver.resolveOptionalExpression(context, template.autocapitalization, data, "autocapitalization", TYPE_HELPER_AUTOCAPITALIZATION, DivInput.Autocapitalization.FROM_STRING, AUTOCAPITALIZATION_DEFAULT_VALUE) ?: AUTOCAPITALIZATION_DEFAULT_VALUE,
                background = JsonFieldResolver.resolveOptionalList(context, template.background, data, "background", component.divBackgroundJsonTemplateResolver, component.divBackgroundJsonEntityParser),
                border = JsonFieldResolver.resolveOptional(context, template.border, data, "border", component.divBorderJsonTemplateResolver, component.divBorderJsonEntityParser),
                columnSpan = JsonFieldResolver.resolveOptionalExpression(context, template.columnSpan, data, "column_span", TYPE_HELPER_INT, NUMBER_TO_INT, COLUMN_SPAN_VALIDATOR),
                disappearActions = JsonFieldResolver.resolveOptionalList(context, template.disappearActions, data, "disappear_actions", component.divDisappearActionJsonTemplateResolver, component.divDisappearActionJsonEntityParser),
                enterKeyActions = JsonFieldResolver.resolveOptionalList(context, template.enterKeyActions, data, "enter_key_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                enterKeyType = JsonFieldResolver.resolveOptionalExpression(context, template.enterKeyType, data, "enter_key_type", TYPE_HELPER_ENTER_KEY_TYPE, DivInput.EnterKeyType.FROM_STRING, ENTER_KEY_TYPE_DEFAULT_VALUE) ?: ENTER_KEY_TYPE_DEFAULT_VALUE,
                extensions = JsonFieldResolver.resolveOptionalList(context, template.extensions, data, "extensions", component.divExtensionJsonTemplateResolver, component.divExtensionJsonEntityParser),
                filters = JsonFieldResolver.resolveOptionalList(context, template.filters, data, "filters", component.divInputFilterJsonTemplateResolver, component.divInputFilterJsonEntityParser),
                focus = JsonFieldResolver.resolveOptional(context, template.focus, data, "focus", component.divFocusJsonTemplateResolver, component.divFocusJsonEntityParser),
                fontFamily = JsonFieldResolver.resolveOptionalExpression(context, template.fontFamily, data, "font_family", TYPE_HELPER_STRING),
                fontSize = JsonFieldResolver.resolveOptionalExpression(context, template.fontSize, data, "font_size", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_SIZE_VALIDATOR, FONT_SIZE_DEFAULT_VALUE) ?: FONT_SIZE_DEFAULT_VALUE,
                fontSizeUnit = JsonFieldResolver.resolveOptionalExpression(context, template.fontSizeUnit, data, "font_size_unit", TYPE_HELPER_FONT_SIZE_UNIT, DivSizeUnit.FROM_STRING, FONT_SIZE_UNIT_DEFAULT_VALUE) ?: FONT_SIZE_UNIT_DEFAULT_VALUE,
                fontVariationSettings = JsonFieldResolver.resolveOptionalExpression(context, template.fontVariationSettings, data, "font_variation_settings", TYPE_HELPER_DICT),
                fontWeight = JsonFieldResolver.resolveOptionalExpression(context, template.fontWeight, data, "font_weight", TYPE_HELPER_FONT_WEIGHT, DivFontWeight.FROM_STRING),
                fontWeightValue = JsonFieldResolver.resolveOptionalExpression(context, template.fontWeightValue, data, "font_weight_value", TYPE_HELPER_INT, NUMBER_TO_INT, FONT_WEIGHT_VALUE_VALIDATOR),
                functions = JsonFieldResolver.resolveOptionalList(context, template.functions, data, "functions", component.divFunctionJsonTemplateResolver, component.divFunctionJsonEntityParser),
                height = JsonFieldResolver.resolveOptional(context, template.height, data, "height", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: HEIGHT_DEFAULT_VALUE,
                highlightColor = JsonFieldResolver.resolveOptionalExpression(context, template.highlightColor, data, "highlight_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                hintColor = JsonFieldResolver.resolveOptionalExpression(context, template.hintColor, data, "hint_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, HINT_COLOR_DEFAULT_VALUE) ?: HINT_COLOR_DEFAULT_VALUE,
                hintText = JsonFieldResolver.resolveOptionalExpression(context, template.hintText, data, "hint_text", TYPE_HELPER_STRING),
                id = JsonFieldResolver.resolveOptional(context, template.id, data, "id"),
                isEnabled = JsonFieldResolver.resolveOptionalExpression(context, template.isEnabled, data, "is_enabled", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, IS_ENABLED_DEFAULT_VALUE) ?: IS_ENABLED_DEFAULT_VALUE,
                keyboardType = JsonFieldResolver.resolveOptionalExpression(context, template.keyboardType, data, "keyboard_type", TYPE_HELPER_KEYBOARD_TYPE, DivInput.KeyboardType.FROM_STRING, KEYBOARD_TYPE_DEFAULT_VALUE) ?: KEYBOARD_TYPE_DEFAULT_VALUE,
                layoutProvider = JsonFieldResolver.resolveOptional(context, template.layoutProvider, data, "layout_provider", component.divLayoutProviderJsonTemplateResolver, component.divLayoutProviderJsonEntityParser),
                letterSpacing = JsonFieldResolver.resolveOptionalExpression(context, template.letterSpacing, data, "letter_spacing", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, LETTER_SPACING_DEFAULT_VALUE) ?: LETTER_SPACING_DEFAULT_VALUE,
                lineHeight = JsonFieldResolver.resolveOptionalExpression(context, template.lineHeight, data, "line_height", TYPE_HELPER_INT, NUMBER_TO_INT, LINE_HEIGHT_VALIDATOR),
                margins = JsonFieldResolver.resolveOptional(context, template.margins, data, "margins", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                mask = JsonFieldResolver.resolveOptional(context, template.mask, data, "mask", component.divInputMaskJsonTemplateResolver, component.divInputMaskJsonEntityParser),
                maxLength = JsonFieldResolver.resolveOptionalExpression(context, template.maxLength, data, "max_length", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_LENGTH_VALIDATOR),
                maxVisibleLines = JsonFieldResolver.resolveOptionalExpression(context, template.maxVisibleLines, data, "max_visible_lines", TYPE_HELPER_INT, NUMBER_TO_INT, MAX_VISIBLE_LINES_VALIDATOR),
                nativeInterface = JsonFieldResolver.resolveOptional(context, template.nativeInterface, data, "native_interface", component.divInputNativeInterfaceJsonTemplateResolver, component.divInputNativeInterfaceJsonEntityParser),
                paddings = JsonFieldResolver.resolveOptional(context, template.paddings, data, "paddings", component.divEdgeInsetsJsonTemplateResolver, component.divEdgeInsetsJsonEntityParser),
                reuseId = JsonFieldResolver.resolveOptionalExpression(context, template.reuseId, data, "reuse_id", TYPE_HELPER_STRING),
                rowSpan = JsonFieldResolver.resolveOptionalExpression(context, template.rowSpan, data, "row_span", TYPE_HELPER_INT, NUMBER_TO_INT, ROW_SPAN_VALIDATOR),
                selectAllOnFocus = JsonFieldResolver.resolveOptionalExpression(context, template.selectAllOnFocus, data, "select_all_on_focus", TYPE_HELPER_BOOLEAN, ANY_TO_BOOLEAN, SELECT_ALL_ON_FOCUS_DEFAULT_VALUE) ?: SELECT_ALL_ON_FOCUS_DEFAULT_VALUE,
                selectedActions = JsonFieldResolver.resolveOptionalList(context, template.selectedActions, data, "selected_actions", component.divActionJsonTemplateResolver, component.divActionJsonEntityParser),
                textAlignmentHorizontal = JsonFieldResolver.resolveOptionalExpression(context, template.textAlignmentHorizontal, data, "text_alignment_horizontal", TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL, DivAlignmentHorizontal.FROM_STRING, TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE,
                textAlignmentVertical = JsonFieldResolver.resolveOptionalExpression(context, template.textAlignmentVertical, data, "text_alignment_vertical", TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL, DivAlignmentVertical.FROM_STRING, TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE) ?: TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE,
                textColor = JsonFieldResolver.resolveOptionalExpression(context, template.textColor, data, "text_color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT, TEXT_COLOR_DEFAULT_VALUE) ?: TEXT_COLOR_DEFAULT_VALUE,
                textVariable = JsonFieldResolver.resolve(context, template.textVariable, data, "text_variable"),
                tooltips = JsonFieldResolver.resolveOptionalList(context, template.tooltips, data, "tooltips", component.divTooltipJsonTemplateResolver, component.divTooltipJsonEntityParser),
                transform = JsonFieldResolver.resolveOptional(context, template.transform, data, "transform", component.divTransformJsonTemplateResolver, component.divTransformJsonEntityParser),
                transformations = JsonFieldResolver.resolveOptionalList(context, template.transformations, data, "transformations", component.divTransformationJsonTemplateResolver, component.divTransformationJsonEntityParser),
                transitionChange = JsonFieldResolver.resolveOptional(context, template.transitionChange, data, "transition_change", component.divChangeTransitionJsonTemplateResolver, component.divChangeTransitionJsonEntityParser),
                transitionIn = JsonFieldResolver.resolveOptional(context, template.transitionIn, data, "transition_in", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionOut = JsonFieldResolver.resolveOptional(context, template.transitionOut, data, "transition_out", component.divAppearanceTransitionJsonTemplateResolver, component.divAppearanceTransitionJsonEntityParser),
                transitionTriggers = JsonFieldResolver.resolveOptionalList(context, template.transitionTriggers, data, "transition_triggers", DivTransitionTrigger.FROM_STRING, TRANSITION_TRIGGERS_VALIDATOR),
                validators = JsonFieldResolver.resolveOptionalList(context, template.validators, data, "validators", component.divInputValidatorJsonTemplateResolver, component.divInputValidatorJsonEntityParser),
                variableTriggers = JsonFieldResolver.resolveOptionalList(context, template.variableTriggers, data, "variable_triggers", component.divTriggerJsonTemplateResolver, component.divTriggerJsonEntityParser),
                variables = JsonFieldResolver.resolveOptionalList(context, template.variables, data, "variables", component.divVariableJsonTemplateResolver, component.divVariableJsonEntityParser),
                visibility = JsonFieldResolver.resolveOptionalExpression(context, template.visibility, data, "visibility", TYPE_HELPER_VISIBILITY, DivVisibility.FROM_STRING, VISIBILITY_DEFAULT_VALUE) ?: VISIBILITY_DEFAULT_VALUE,
                visibilityAction = JsonFieldResolver.resolveOptional(context, template.visibilityAction, data, "visibility_action", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                visibilityActions = JsonFieldResolver.resolveOptionalList(context, template.visibilityActions, data, "visibility_actions", component.divVisibilityActionJsonTemplateResolver, component.divVisibilityActionJsonEntityParser),
                width = JsonFieldResolver.resolveOptional(context, template.width, data, "width", component.divSizeJsonTemplateResolver, component.divSizeJsonEntityParser) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        @JvmField val AUTOCAPITALIZATION_DEFAULT_VALUE = Expression.constant(DivInput.Autocapitalization.AUTO)
        @JvmField val ENTER_KEY_TYPE_DEFAULT_VALUE = Expression.constant(DivInput.EnterKeyType.DEFAULT)
        @JvmField val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12L)
        @JvmField val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        @JvmField val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        @JvmField val HINT_COLOR_DEFAULT_VALUE = Expression.constant(0x73000000.toInt())
        @JvmField val IS_ENABLED_DEFAULT_VALUE = Expression.constant(true)
        @JvmField val KEYBOARD_TYPE_DEFAULT_VALUE = Expression.constant(DivInput.KeyboardType.MULTI_LINE_TEXT)
        @JvmField val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        @JvmField val SELECT_ALL_ON_FOCUS_DEFAULT_VALUE = Expression.constant(false)
        @JvmField val TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.START)
        @JvmField val TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.CENTER)
        @JvmField val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())
        @JvmField val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        @JvmField val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        @JvmField val TYPE_HELPER_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.values().first()) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.values().first()) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_AUTOCAPITALIZATION = TypeHelper.from(default = DivInput.Autocapitalization.AUTO) { it is DivInput.Autocapitalization }
        @JvmField val TYPE_HELPER_ENTER_KEY_TYPE = TypeHelper.from(default = DivInput.EnterKeyType.DEFAULT) { it is DivInput.EnterKeyType }
        @JvmField val TYPE_HELPER_FONT_SIZE_UNIT = TypeHelper.from(default = DivSizeUnit.SP) { it is DivSizeUnit }
        @JvmField val TYPE_HELPER_FONT_WEIGHT = TypeHelper.from(default = DivFontWeight.values().first()) { it is DivFontWeight }
        @JvmField val TYPE_HELPER_KEYBOARD_TYPE = TypeHelper.from(default = DivInput.KeyboardType.MULTI_LINE_TEXT) { it is DivInput.KeyboardType }
        @JvmField val TYPE_HELPER_TEXT_ALIGNMENT_HORIZONTAL = TypeHelper.from(default = DivAlignmentHorizontal.START) { it is DivAlignmentHorizontal }
        @JvmField val TYPE_HELPER_TEXT_ALIGNMENT_VERTICAL = TypeHelper.from(default = DivAlignmentVertical.CENTER) { it is DivAlignmentVertical }
        @JvmField val TYPE_HELPER_VISIBILITY = TypeHelper.from(default = DivVisibility.VISIBLE) { it is DivVisibility }

        @JvmField val ALPHA_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0.0 && it <= 1.0 }
        @JvmField val COLUMN_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val FONT_SIZE_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val FONT_WEIGHT_VALUE_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        @JvmField val LINE_HEIGHT_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val MAX_LENGTH_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        @JvmField val MAX_VISIBLE_LINES_VALIDATOR = ValueValidator<Long> { it: Long -> it > 0 }
        @JvmField val ROW_SPAN_VALIDATOR = ValueValidator<Long> { it: Long -> it >= 0 }
        @JvmField val TRANSITION_TRIGGERS_VALIDATOR = ListValidator<DivTransitionTrigger> { it: List<*> -> it.size >= 1 }
    }
}

internal class DivInputNativeInterfaceJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivInput.NativeInterface> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivInput.NativeInterface {
            return DivInput.NativeInterface(
                color = JsonExpressionParser.readExpression(context, data, "color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInput.NativeInterface): JSONObject {
            val data = JSONObject()
            JsonExpressionParser.writeExpression(context, data, "color", value.color, COLOR_INT_TO_STRING)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivInputTemplate.NativeInterfaceTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivInputTemplate.NativeInterfaceTemplate?, data: JSONObject): DivInputTemplate.NativeInterfaceTemplate {
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivInputTemplate.NativeInterfaceTemplate(
                color = JsonFieldParser.readFieldWithExpression(context, data, "color", TYPE_HELPER_COLOR, allowOverride, parent?.color, STRING_TO_COLOR_INT),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivInputTemplate.NativeInterfaceTemplate): JSONObject {
            val data = JSONObject()
            JsonFieldParser.writeExpressionField(context, data, "color", value.color, COLOR_INT_TO_STRING)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivInputTemplate.NativeInterfaceTemplate, DivInput.NativeInterface> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivInputTemplate.NativeInterfaceTemplate, data: JSONObject): DivInput.NativeInterface {
            return DivInput.NativeInterface(
                color = JsonFieldResolver.resolveExpression(context, template.color, data, "color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
            )
        }
    }
}
