// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

class DivText @DivModelInternalApi constructor (
    override val accessibility: DivAccessibility? = null,
    @JvmField val action: DivAction? = null,
    @JvmField val actionAnimation: DivAnimation = ACTION_ANIMATION_DEFAULT_VALUE, // default value: DivAnimation(duration = Expression.constant(100L), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
    @JvmField val actions: List<DivAction>? = null,
    override val alignmentHorizontal: Expression<DivAlignmentHorizontal>? = null,
    override val alignmentVertical: Expression<DivAlignmentVertical>? = null,
    override val alpha: Expression<Double> = ALPHA_DEFAULT_VALUE, // constraint: number >= 0.0 && number <= 1.0; default value: 1.0
    override val animators: List<DivAnimator>? = null,
    @JvmField val autoEllipsize: Expression<Boolean>? = null,
    override val background: List<DivBackground>? = null,
    override val border: DivBorder? = null,
    @JvmField val captureFocusOnAction: Expression<Boolean> = CAPTURE_FOCUS_ON_ACTION_DEFAULT_VALUE, // default value: true
    override val columnSpan: Expression<Long>? = null, // constraint: number >= 0
    override val disappearActions: List<DivDisappearAction>? = null,
    @JvmField val doubletapActions: List<DivAction>? = null,
    @JvmField val ellipsis: Ellipsis? = null,
    override val extensions: List<DivExtension>? = null,
    override val focus: DivFocus? = null,
    @JvmField val focusedTextColor: Expression<Int>? = null,
    @JvmField val fontFamily: Expression<String>? = null,
    @JvmField val fontFeatureSettings: Expression<String>? = null,
    @JvmField val fontSize: Expression<Long> = FONT_SIZE_DEFAULT_VALUE, // constraint: number >= 0; default value: 12
    @JvmField val fontSizeUnit: Expression<DivSizeUnit> = FONT_SIZE_UNIT_DEFAULT_VALUE, // default value: sp
    @JvmField val fontVariationSettings: Expression<JSONObject>? = null,
    @JvmField val fontWeight: Expression<DivFontWeight>? = null,
    @JvmField val fontWeightValue: Expression<Long>? = null, // constraint: number > 0
    override val functions: List<DivFunction>? = null,
    override val height: DivSize = HEIGHT_DEFAULT_VALUE, // default value: DivSize.WrapContent(DivWrapContentSize())
    @JvmField val hoverEndActions: List<DivAction>? = null,
    @JvmField val hoverStartActions: List<DivAction>? = null,
    override val id: String? = null,
    @JvmField val images: List<Image>? = null,
    override val layoutProvider: DivLayoutProvider? = null,
    @JvmField val letterSpacing: Expression<Double> = LETTER_SPACING_DEFAULT_VALUE, // default value: 0
    @JvmField val lineHeight: Expression<Long>? = null, // constraint: number >= 0
    @JvmField val longtapActions: List<DivAction>? = null,
    override val margins: DivEdgeInsets? = null,
    @JvmField val maxLines: Expression<Long>? = null, // constraint: number >= 0
    @JvmField val minHiddenLines: Expression<Long>? = null, // constraint: number >= 0
    override val paddings: DivEdgeInsets? = null,
    @JvmField val pressEndActions: List<DivAction>? = null,
    @JvmField val pressStartActions: List<DivAction>? = null,
    @JvmField val ranges: List<Range>? = null,
    override val reuseId: Expression<String>? = null,
    override val rowSpan: Expression<Long>? = null, // constraint: number >= 0
    @JvmField val selectable: Expression<Boolean> = SELECTABLE_DEFAULT_VALUE, // default value: false
    override val selectedActions: List<DivAction>? = null,
    @JvmField val strike: Expression<DivLineStyle> = STRIKE_DEFAULT_VALUE, // default value: none
    @JvmField val text: Expression<String>,
    @JvmField val textAlignmentHorizontal: Expression<DivAlignmentHorizontal> = TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE, // default value: start
    @JvmField val textAlignmentVertical: Expression<DivAlignmentVertical> = TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE, // default value: top
    @JvmField val textColor: Expression<Int> = TEXT_COLOR_DEFAULT_VALUE, // default value: #FF000000
    @JvmField val textGradient: DivTextGradient? = null,
    @JvmField val textShadow: DivShadow? = null,
    @JvmField val tightenWidth: Expression<Boolean> = TIGHTEN_WIDTH_DEFAULT_VALUE, // default value: false
    override val tooltips: List<DivTooltip>? = null,
    override val transform: DivTransform? = null,
    override val transformations: List<DivTransformation>? = null,
    override val transitionChange: DivChangeTransition? = null,
    override val transitionIn: DivAppearanceTransition? = null,
    override val transitionOut: DivAppearanceTransition? = null,
    override val transitionTriggers: List<DivTransitionTrigger>? = null, // at least 1 elements
    @JvmField val truncate: Expression<Truncate> = TRUNCATE_DEFAULT_VALUE, // default value: end
    @JvmField val underline: Expression<DivLineStyle> = UNDERLINE_DEFAULT_VALUE, // default value: none
    override val variableTriggers: List<DivTrigger>? = null,
    override val variables: List<DivVariable>? = null,
    override val visibility: Expression<DivVisibility> = VISIBILITY_DEFAULT_VALUE, // default value: visible
    override val visibilityAction: DivVisibilityAction? = null,
    override val visibilityActions: List<DivVisibilityAction>? = null,
    override val width: DivSize = WIDTH_DEFAULT_VALUE, // default value: DivSize.MatchParent(DivMatchParentSize())
) : JSONSerializable, Hashable, DivBase {

    private var _hash: Int? = null 

    override fun hash(): Int {
        _hash?.let {
            return it
        }
        val hash = 
            this::class.hashCode() +
            (accessibility?.hash() ?: 0) +
            (action?.hash() ?: 0) +
            actionAnimation.hash() +
            (actions?.sumOf { it.hash() } ?: 0) +
            (alignmentHorizontal?.hashCode() ?: 0) +
            (alignmentVertical?.hashCode() ?: 0) +
            alpha.hashCode() +
            (animators?.sumOf { it.hash() } ?: 0) +
            (autoEllipsize?.hashCode() ?: 0) +
            (background?.sumOf { it.hash() } ?: 0) +
            (border?.hash() ?: 0) +
            captureFocusOnAction.hashCode() +
            (columnSpan?.hashCode() ?: 0) +
            (disappearActions?.sumOf { it.hash() } ?: 0) +
            (doubletapActions?.sumOf { it.hash() } ?: 0) +
            (ellipsis?.hash() ?: 0) +
            (extensions?.sumOf { it.hash() } ?: 0) +
            (focus?.hash() ?: 0) +
            (focusedTextColor?.hashCode() ?: 0) +
            (fontFamily?.hashCode() ?: 0) +
            (fontFeatureSettings?.hashCode() ?: 0) +
            fontSize.hashCode() +
            fontSizeUnit.hashCode() +
            (fontVariationSettings?.hashCode() ?: 0) +
            (fontWeight?.hashCode() ?: 0) +
            (fontWeightValue?.hashCode() ?: 0) +
            (functions?.sumOf { it.hash() } ?: 0) +
            height.hash() +
            (hoverEndActions?.sumOf { it.hash() } ?: 0) +
            (hoverStartActions?.sumOf { it.hash() } ?: 0) +
            (id?.hashCode() ?: 0) +
            (images?.sumOf { it.hash() } ?: 0) +
            (layoutProvider?.hash() ?: 0) +
            letterSpacing.hashCode() +
            (lineHeight?.hashCode() ?: 0) +
            (longtapActions?.sumOf { it.hash() } ?: 0) +
            (margins?.hash() ?: 0) +
            (maxLines?.hashCode() ?: 0) +
            (minHiddenLines?.hashCode() ?: 0) +
            (paddings?.hash() ?: 0) +
            (pressEndActions?.sumOf { it.hash() } ?: 0) +
            (pressStartActions?.sumOf { it.hash() } ?: 0) +
            (ranges?.sumOf { it.hash() } ?: 0) +
            (reuseId?.hashCode() ?: 0) +
            (rowSpan?.hashCode() ?: 0) +
            selectable.hashCode() +
            (selectedActions?.sumOf { it.hash() } ?: 0) +
            strike.hashCode() +
            text.hashCode() +
            textAlignmentHorizontal.hashCode() +
            textAlignmentVertical.hashCode() +
            textColor.hashCode() +
            (textGradient?.hash() ?: 0) +
            (textShadow?.hash() ?: 0) +
            tightenWidth.hashCode() +
            (tooltips?.sumOf { it.hash() } ?: 0) +
            (transform?.hash() ?: 0) +
            (transformations?.sumOf { it.hash() } ?: 0) +
            (transitionChange?.hash() ?: 0) +
            (transitionIn?.hash() ?: 0) +
            (transitionOut?.hash() ?: 0) +
            (transitionTriggers?.hashCode() ?: 0) +
            truncate.hashCode() +
            underline.hashCode() +
            (variableTriggers?.sumOf { it.hash() } ?: 0) +
            (variables?.sumOf { it.hash() } ?: 0) +
            visibility.hashCode() +
            (visibilityAction?.hash() ?: 0) +
            (visibilityActions?.sumOf { it.hash() } ?: 0) +
            width.hash()
        _hash = hash
        return hash
    }

    fun equals(other: DivText?, resolver: ExpressionResolver, otherResolver: ExpressionResolver): Boolean {
        other ?: return false
        return (accessibility?.equals(other.accessibility, resolver, otherResolver) ?: (other.accessibility == null)) &&
            (action?.equals(other.action, resolver, otherResolver) ?: (other.action == null)) &&
            actionAnimation.equals(other.actionAnimation, resolver, otherResolver) &&
            (actions?.compareWith(other.actions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.actions == null)) &&
            alignmentHorizontal?.evaluate(resolver) == other.alignmentHorizontal?.evaluate(otherResolver) &&
            alignmentVertical?.evaluate(resolver) == other.alignmentVertical?.evaluate(otherResolver) &&
            alpha.evaluate(resolver) == other.alpha.evaluate(otherResolver) &&
            (animators?.compareWith(other.animators ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.animators == null)) &&
            autoEllipsize?.evaluate(resolver) == other.autoEllipsize?.evaluate(otherResolver) &&
            (background?.compareWith(other.background ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.background == null)) &&
            (border?.equals(other.border, resolver, otherResolver) ?: (other.border == null)) &&
            captureFocusOnAction.evaluate(resolver) == other.captureFocusOnAction.evaluate(otherResolver) &&
            columnSpan?.evaluate(resolver) == other.columnSpan?.evaluate(otherResolver) &&
            (disappearActions?.compareWith(other.disappearActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.disappearActions == null)) &&
            (doubletapActions?.compareWith(other.doubletapActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.doubletapActions == null)) &&
            (ellipsis?.equals(other.ellipsis, resolver, otherResolver) ?: (other.ellipsis == null)) &&
            (extensions?.compareWith(other.extensions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.extensions == null)) &&
            (focus?.equals(other.focus, resolver, otherResolver) ?: (other.focus == null)) &&
            focusedTextColor?.evaluate(resolver) == other.focusedTextColor?.evaluate(otherResolver) &&
            fontFamily?.evaluate(resolver) == other.fontFamily?.evaluate(otherResolver) &&
            fontFeatureSettings?.evaluate(resolver) == other.fontFeatureSettings?.evaluate(otherResolver) &&
            fontSize.evaluate(resolver) == other.fontSize.evaluate(otherResolver) &&
            fontSizeUnit.evaluate(resolver) == other.fontSizeUnit.evaluate(otherResolver) &&
            fontVariationSettings?.evaluate(resolver) == other.fontVariationSettings?.evaluate(otherResolver) &&
            fontWeight?.evaluate(resolver) == other.fontWeight?.evaluate(otherResolver) &&
            fontWeightValue?.evaluate(resolver) == other.fontWeightValue?.evaluate(otherResolver) &&
            (functions?.compareWith(other.functions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.functions == null)) &&
            height.equals(other.height, resolver, otherResolver) &&
            (hoverEndActions?.compareWith(other.hoverEndActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.hoverEndActions == null)) &&
            (hoverStartActions?.compareWith(other.hoverStartActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.hoverStartActions == null)) &&
            id == other.id &&
            (images?.compareWith(other.images ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.images == null)) &&
            (layoutProvider?.equals(other.layoutProvider, resolver, otherResolver) ?: (other.layoutProvider == null)) &&
            letterSpacing.evaluate(resolver) == other.letterSpacing.evaluate(otherResolver) &&
            lineHeight?.evaluate(resolver) == other.lineHeight?.evaluate(otherResolver) &&
            (longtapActions?.compareWith(other.longtapActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.longtapActions == null)) &&
            (margins?.equals(other.margins, resolver, otherResolver) ?: (other.margins == null)) &&
            maxLines?.evaluate(resolver) == other.maxLines?.evaluate(otherResolver) &&
            minHiddenLines?.evaluate(resolver) == other.minHiddenLines?.evaluate(otherResolver) &&
            (paddings?.equals(other.paddings, resolver, otherResolver) ?: (other.paddings == null)) &&
            (pressEndActions?.compareWith(other.pressEndActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.pressEndActions == null)) &&
            (pressStartActions?.compareWith(other.pressStartActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.pressStartActions == null)) &&
            (ranges?.compareWith(other.ranges ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.ranges == null)) &&
            reuseId?.evaluate(resolver) == other.reuseId?.evaluate(otherResolver) &&
            rowSpan?.evaluate(resolver) == other.rowSpan?.evaluate(otherResolver) &&
            selectable.evaluate(resolver) == other.selectable.evaluate(otherResolver) &&
            (selectedActions?.compareWith(other.selectedActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.selectedActions == null)) &&
            strike.evaluate(resolver) == other.strike.evaluate(otherResolver) &&
            text.evaluate(resolver) == other.text.evaluate(otherResolver) &&
            textAlignmentHorizontal.evaluate(resolver) == other.textAlignmentHorizontal.evaluate(otherResolver) &&
            textAlignmentVertical.evaluate(resolver) == other.textAlignmentVertical.evaluate(otherResolver) &&
            textColor.evaluate(resolver) == other.textColor.evaluate(otherResolver) &&
            (textGradient?.equals(other.textGradient, resolver, otherResolver) ?: (other.textGradient == null)) &&
            (textShadow?.equals(other.textShadow, resolver, otherResolver) ?: (other.textShadow == null)) &&
            tightenWidth.evaluate(resolver) == other.tightenWidth.evaluate(otherResolver) &&
            (tooltips?.compareWith(other.tooltips ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.tooltips == null)) &&
            (transform?.equals(other.transform, resolver, otherResolver) ?: (other.transform == null)) &&
            (transformations?.compareWith(other.transformations ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.transformations == null)) &&
            (transitionChange?.equals(other.transitionChange, resolver, otherResolver) ?: (other.transitionChange == null)) &&
            (transitionIn?.equals(other.transitionIn, resolver, otherResolver) ?: (other.transitionIn == null)) &&
            (transitionOut?.equals(other.transitionOut, resolver, otherResolver) ?: (other.transitionOut == null)) &&
            (transitionTriggers?.compareWith(other.transitionTriggers ?: return false) { a, b -> a == b } ?: (other.transitionTriggers == null)) &&
            truncate.evaluate(resolver) == other.truncate.evaluate(otherResolver) &&
            underline.evaluate(resolver) == other.underline.evaluate(otherResolver) &&
            (variableTriggers?.compareWith(other.variableTriggers ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.variableTriggers == null)) &&
            (variables?.compareWith(other.variables ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.variables == null)) &&
            visibility.evaluate(resolver) == other.visibility.evaluate(otherResolver) &&
            (visibilityAction?.equals(other.visibilityAction, resolver, otherResolver) ?: (other.visibilityAction == null)) &&
            (visibilityActions?.compareWith(other.visibilityActions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.visibilityActions == null)) &&
            width.equals(other.width, resolver, otherResolver)
    }

    fun copy(
        accessibility: DivAccessibility? = this.accessibility,
        action: DivAction? = this.action,
        actionAnimation: DivAnimation = this.actionAnimation,
        actions: List<DivAction>? = this.actions,
        alignmentHorizontal: Expression<DivAlignmentHorizontal>? = this.alignmentHorizontal,
        alignmentVertical: Expression<DivAlignmentVertical>? = this.alignmentVertical,
        alpha: Expression<Double> = this.alpha,
        animators: List<DivAnimator>? = this.animators,
        autoEllipsize: Expression<Boolean>? = this.autoEllipsize,
        background: List<DivBackground>? = this.background,
        border: DivBorder? = this.border,
        captureFocusOnAction: Expression<Boolean> = this.captureFocusOnAction,
        columnSpan: Expression<Long>? = this.columnSpan,
        disappearActions: List<DivDisappearAction>? = this.disappearActions,
        doubletapActions: List<DivAction>? = this.doubletapActions,
        ellipsis: Ellipsis? = this.ellipsis,
        extensions: List<DivExtension>? = this.extensions,
        focus: DivFocus? = this.focus,
        focusedTextColor: Expression<Int>? = this.focusedTextColor,
        fontFamily: Expression<String>? = this.fontFamily,
        fontFeatureSettings: Expression<String>? = this.fontFeatureSettings,
        fontSize: Expression<Long> = this.fontSize,
        fontSizeUnit: Expression<DivSizeUnit> = this.fontSizeUnit,
        fontVariationSettings: Expression<JSONObject>? = this.fontVariationSettings,
        fontWeight: Expression<DivFontWeight>? = this.fontWeight,
        fontWeightValue: Expression<Long>? = this.fontWeightValue,
        functions: List<DivFunction>? = this.functions,
        height: DivSize = this.height,
        hoverEndActions: List<DivAction>? = this.hoverEndActions,
        hoverStartActions: List<DivAction>? = this.hoverStartActions,
        id: String? = this.id,
        images: List<Image>? = this.images,
        layoutProvider: DivLayoutProvider? = this.layoutProvider,
        letterSpacing: Expression<Double> = this.letterSpacing,
        lineHeight: Expression<Long>? = this.lineHeight,
        longtapActions: List<DivAction>? = this.longtapActions,
        margins: DivEdgeInsets? = this.margins,
        maxLines: Expression<Long>? = this.maxLines,
        minHiddenLines: Expression<Long>? = this.minHiddenLines,
        paddings: DivEdgeInsets? = this.paddings,
        pressEndActions: List<DivAction>? = this.pressEndActions,
        pressStartActions: List<DivAction>? = this.pressStartActions,
        ranges: List<Range>? = this.ranges,
        reuseId: Expression<String>? = this.reuseId,
        rowSpan: Expression<Long>? = this.rowSpan,
        selectable: Expression<Boolean> = this.selectable,
        selectedActions: List<DivAction>? = this.selectedActions,
        strike: Expression<DivLineStyle> = this.strike,
        text: Expression<String> = this.text,
        textAlignmentHorizontal: Expression<DivAlignmentHorizontal> = this.textAlignmentHorizontal,
        textAlignmentVertical: Expression<DivAlignmentVertical> = this.textAlignmentVertical,
        textColor: Expression<Int> = this.textColor,
        textGradient: DivTextGradient? = this.textGradient,
        textShadow: DivShadow? = this.textShadow,
        tightenWidth: Expression<Boolean> = this.tightenWidth,
        tooltips: List<DivTooltip>? = this.tooltips,
        transform: DivTransform? = this.transform,
        transformations: List<DivTransformation>? = this.transformations,
        transitionChange: DivChangeTransition? = this.transitionChange,
        transitionIn: DivAppearanceTransition? = this.transitionIn,
        transitionOut: DivAppearanceTransition? = this.transitionOut,
        transitionTriggers: List<DivTransitionTrigger>? = this.transitionTriggers,
        truncate: Expression<Truncate> = this.truncate,
        underline: Expression<DivLineStyle> = this.underline,
        variableTriggers: List<DivTrigger>? = this.variableTriggers,
        variables: List<DivVariable>? = this.variables,
        visibility: Expression<DivVisibility> = this.visibility,
        visibilityAction: DivVisibilityAction? = this.visibilityAction,
        visibilityActions: List<DivVisibilityAction>? = this.visibilityActions,
        width: DivSize = this.width,
    ) = DivText(
        accessibility = accessibility,
        action = action,
        actionAnimation = actionAnimation,
        actions = actions,
        alignmentHorizontal = alignmentHorizontal,
        alignmentVertical = alignmentVertical,
        alpha = alpha,
        animators = animators,
        autoEllipsize = autoEllipsize,
        background = background,
        border = border,
        captureFocusOnAction = captureFocusOnAction,
        columnSpan = columnSpan,
        disappearActions = disappearActions,
        doubletapActions = doubletapActions,
        ellipsis = ellipsis,
        extensions = extensions,
        focus = focus,
        focusedTextColor = focusedTextColor,
        fontFamily = fontFamily,
        fontFeatureSettings = fontFeatureSettings,
        fontSize = fontSize,
        fontSizeUnit = fontSizeUnit,
        fontVariationSettings = fontVariationSettings,
        fontWeight = fontWeight,
        fontWeightValue = fontWeightValue,
        functions = functions,
        height = height,
        hoverEndActions = hoverEndActions,
        hoverStartActions = hoverStartActions,
        id = id,
        images = images,
        layoutProvider = layoutProvider,
        letterSpacing = letterSpacing,
        lineHeight = lineHeight,
        longtapActions = longtapActions,
        margins = margins,
        maxLines = maxLines,
        minHiddenLines = minHiddenLines,
        paddings = paddings,
        pressEndActions = pressEndActions,
        pressStartActions = pressStartActions,
        ranges = ranges,
        reuseId = reuseId,
        rowSpan = rowSpan,
        selectable = selectable,
        selectedActions = selectedActions,
        strike = strike,
        text = text,
        textAlignmentHorizontal = textAlignmentHorizontal,
        textAlignmentVertical = textAlignmentVertical,
        textColor = textColor,
        textGradient = textGradient,
        textShadow = textShadow,
        tightenWidth = tightenWidth,
        tooltips = tooltips,
        transform = transform,
        transformations = transformations,
        transitionChange = transitionChange,
        transitionIn = transitionIn,
        transitionOut = transitionOut,
        transitionTriggers = transitionTriggers,
        truncate = truncate,
        underline = underline,
        variableTriggers = variableTriggers,
        variables = variables,
        visibility = visibility,
        visibilityAction = visibilityAction,
        visibilityActions = visibilityActions,
        width = width,
    )

    override fun writeToJSON(): JSONObject {
        return builtInParserComponent.divTextJsonEntityParser
            .value
            .serialize(context = builtInParsingContext, value = this)
    }

    companion object {
        const val TYPE = "text"

        private val ACTION_ANIMATION_DEFAULT_VALUE = DivAnimation(duration = Expression.constant(100L), endValue = Expression.constant(0.6), name = Expression.constant(DivAnimation.Name.FADE), startValue = Expression.constant(1.0))
        private val ALPHA_DEFAULT_VALUE = Expression.constant(1.0)
        private val CAPTURE_FOCUS_ON_ACTION_DEFAULT_VALUE = Expression.constant(true)
        private val FONT_SIZE_DEFAULT_VALUE = Expression.constant(12L)
        private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
        private val HEIGHT_DEFAULT_VALUE = DivSize.WrapContent(DivWrapContentSize())
        private val LETTER_SPACING_DEFAULT_VALUE = Expression.constant(0.0)
        private val SELECTABLE_DEFAULT_VALUE = Expression.constant(false)
        private val STRIKE_DEFAULT_VALUE = Expression.constant(DivLineStyle.NONE)
        private val TEXT_ALIGNMENT_HORIZONTAL_DEFAULT_VALUE = Expression.constant(DivAlignmentHorizontal.START)
        private val TEXT_ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivAlignmentVertical.TOP)
        private val TEXT_COLOR_DEFAULT_VALUE = Expression.constant(0xFF000000.toInt())
        private val TIGHTEN_WIDTH_DEFAULT_VALUE = Expression.constant(false)
        private val TRUNCATE_DEFAULT_VALUE = Expression.constant(Truncate.END)
        private val UNDERLINE_DEFAULT_VALUE = Expression.constant(DivLineStyle.NONE)
        private val VISIBILITY_DEFAULT_VALUE = Expression.constant(DivVisibility.VISIBLE)
        private val WIDTH_DEFAULT_VALUE = DivSize.MatchParent(DivMatchParentSize())

        @JvmStatic
        @JvmName("fromJson")
        operator fun invoke(env: ParsingEnvironment, json: JSONObject): DivText {
            return builtInParserComponent.divTextJsonEntityParser
                .value
                .deserialize(context = env, data = json)
        }

        val CREATOR = { env: ParsingEnvironment, it: JSONObject -> DivText(env, json = it) }
    }

    class Range @DivModelInternalApi constructor (
        @JvmField val actions: List<DivAction>? = null,
        @JvmField val alignmentVertical: Expression<DivTextAlignmentVertical>? = null,
        @JvmField val background: DivTextRangeBackground? = null,
        @JvmField val baselineOffset: Expression<Double> = BASELINE_OFFSET_DEFAULT_VALUE, // default value: 0
        @JvmField val border: DivTextRangeBorder? = null,
        @JvmField val end: Expression<Long>? = null, // constraint: number > 0
        @JvmField val fontFamily: Expression<String>? = null,
        @JvmField val fontFeatureSettings: Expression<String>? = null,
        @JvmField val fontSize: Expression<Long>? = null, // constraint: number >= 0
        @JvmField val fontSizeUnit: Expression<DivSizeUnit> = FONT_SIZE_UNIT_DEFAULT_VALUE, // default value: sp
        @JvmField val fontVariationSettings: Expression<JSONObject>? = null,
        @JvmField val fontWeight: Expression<DivFontWeight>? = null,
        @JvmField val fontWeightValue: Expression<Long>? = null, // constraint: number > 0
        @JvmField val letterSpacing: Expression<Double>? = null,
        @JvmField val lineHeight: Expression<Long>? = null, // constraint: number >= 0
        @JvmField val mask: DivTextRangeMask? = null,
        @JvmField val start: Expression<Long> = START_DEFAULT_VALUE, // constraint: number >= 0; default value: 0
        @JvmField val strike: Expression<DivLineStyle>? = null,
        @JvmField val textColor: Expression<Int>? = null,
        @JvmField val textShadow: DivShadow? = null,
        @JvmField val topOffset: Expression<Long>? = null, // constraint: number >= 0
        @JvmField val underline: Expression<DivLineStyle>? = null,
    ) : JSONSerializable, Hashable {

        private var _hash: Int? = null 

        override fun hash(): Int {
            _hash?.let {
                return it
            }
            val hash = 
                this::class.hashCode() +
                (actions?.sumOf { it.hash() } ?: 0) +
                (alignmentVertical?.hashCode() ?: 0) +
                (background?.hash() ?: 0) +
                baselineOffset.hashCode() +
                (border?.hash() ?: 0) +
                (end?.hashCode() ?: 0) +
                (fontFamily?.hashCode() ?: 0) +
                (fontFeatureSettings?.hashCode() ?: 0) +
                (fontSize?.hashCode() ?: 0) +
                fontSizeUnit.hashCode() +
                (fontVariationSettings?.hashCode() ?: 0) +
                (fontWeight?.hashCode() ?: 0) +
                (fontWeightValue?.hashCode() ?: 0) +
                (letterSpacing?.hashCode() ?: 0) +
                (lineHeight?.hashCode() ?: 0) +
                (mask?.hash() ?: 0) +
                start.hashCode() +
                (strike?.hashCode() ?: 0) +
                (textColor?.hashCode() ?: 0) +
                (textShadow?.hash() ?: 0) +
                (topOffset?.hashCode() ?: 0) +
                (underline?.hashCode() ?: 0)
            _hash = hash
            return hash
        }

        fun equals(other: Range?, resolver: ExpressionResolver, otherResolver: ExpressionResolver): Boolean {
            other ?: return false
            return (actions?.compareWith(other.actions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.actions == null)) &&
                alignmentVertical?.evaluate(resolver) == other.alignmentVertical?.evaluate(otherResolver) &&
                (background?.equals(other.background, resolver, otherResolver) ?: (other.background == null)) &&
                baselineOffset.evaluate(resolver) == other.baselineOffset.evaluate(otherResolver) &&
                (border?.equals(other.border, resolver, otherResolver) ?: (other.border == null)) &&
                end?.evaluate(resolver) == other.end?.evaluate(otherResolver) &&
                fontFamily?.evaluate(resolver) == other.fontFamily?.evaluate(otherResolver) &&
                fontFeatureSettings?.evaluate(resolver) == other.fontFeatureSettings?.evaluate(otherResolver) &&
                fontSize?.evaluate(resolver) == other.fontSize?.evaluate(otherResolver) &&
                fontSizeUnit.evaluate(resolver) == other.fontSizeUnit.evaluate(otherResolver) &&
                fontVariationSettings?.evaluate(resolver) == other.fontVariationSettings?.evaluate(otherResolver) &&
                fontWeight?.evaluate(resolver) == other.fontWeight?.evaluate(otherResolver) &&
                fontWeightValue?.evaluate(resolver) == other.fontWeightValue?.evaluate(otherResolver) &&
                letterSpacing?.evaluate(resolver) == other.letterSpacing?.evaluate(otherResolver) &&
                lineHeight?.evaluate(resolver) == other.lineHeight?.evaluate(otherResolver) &&
                (mask?.equals(other.mask, resolver, otherResolver) ?: (other.mask == null)) &&
                start.evaluate(resolver) == other.start.evaluate(otherResolver) &&
                strike?.evaluate(resolver) == other.strike?.evaluate(otherResolver) &&
                textColor?.evaluate(resolver) == other.textColor?.evaluate(otherResolver) &&
                (textShadow?.equals(other.textShadow, resolver, otherResolver) ?: (other.textShadow == null)) &&
                topOffset?.evaluate(resolver) == other.topOffset?.evaluate(otherResolver) &&
                underline?.evaluate(resolver) == other.underline?.evaluate(otherResolver)
        }

        fun copy(
            actions: List<DivAction>? = this.actions,
            alignmentVertical: Expression<DivTextAlignmentVertical>? = this.alignmentVertical,
            background: DivTextRangeBackground? = this.background,
            baselineOffset: Expression<Double> = this.baselineOffset,
            border: DivTextRangeBorder? = this.border,
            end: Expression<Long>? = this.end,
            fontFamily: Expression<String>? = this.fontFamily,
            fontFeatureSettings: Expression<String>? = this.fontFeatureSettings,
            fontSize: Expression<Long>? = this.fontSize,
            fontSizeUnit: Expression<DivSizeUnit> = this.fontSizeUnit,
            fontVariationSettings: Expression<JSONObject>? = this.fontVariationSettings,
            fontWeight: Expression<DivFontWeight>? = this.fontWeight,
            fontWeightValue: Expression<Long>? = this.fontWeightValue,
            letterSpacing: Expression<Double>? = this.letterSpacing,
            lineHeight: Expression<Long>? = this.lineHeight,
            mask: DivTextRangeMask? = this.mask,
            start: Expression<Long> = this.start,
            strike: Expression<DivLineStyle>? = this.strike,
            textColor: Expression<Int>? = this.textColor,
            textShadow: DivShadow? = this.textShadow,
            topOffset: Expression<Long>? = this.topOffset,
            underline: Expression<DivLineStyle>? = this.underline,
        ) = Range(
            actions = actions,
            alignmentVertical = alignmentVertical,
            background = background,
            baselineOffset = baselineOffset,
            border = border,
            end = end,
            fontFamily = fontFamily,
            fontFeatureSettings = fontFeatureSettings,
            fontSize = fontSize,
            fontSizeUnit = fontSizeUnit,
            fontVariationSettings = fontVariationSettings,
            fontWeight = fontWeight,
            fontWeightValue = fontWeightValue,
            letterSpacing = letterSpacing,
            lineHeight = lineHeight,
            mask = mask,
            start = start,
            strike = strike,
            textColor = textColor,
            textShadow = textShadow,
            topOffset = topOffset,
            underline = underline,
        )

        override fun writeToJSON(): JSONObject {
            return builtInParserComponent.divTextRangeJsonEntityParser
                .value
                .serialize(context = builtInParsingContext, value = this)
        }

        companion object {
            private val BASELINE_OFFSET_DEFAULT_VALUE = Expression.constant(0.0)
            private val FONT_SIZE_UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.SP)
            private val START_DEFAULT_VALUE = Expression.constant(0L)

            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Range {
                return builtInParserComponent.divTextRangeJsonEntityParser
                    .value
                    .deserialize(context = env, data = json)
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Range(env, json = it) }
        }
    }

    class Image @DivModelInternalApi constructor (
        @JvmField val accessibility: Accessibility? = null,
        @JvmField val alignmentVertical: Expression<DivTextAlignmentVertical> = ALIGNMENT_VERTICAL_DEFAULT_VALUE, // default value: center
        @JvmField val height: DivFixedSize = HEIGHT_DEFAULT_VALUE, // default value: DivFixedSize(value = Expression.constant(20L))
        @JvmField val indexingDirection: Expression<IndexingDirection> = INDEXING_DIRECTION_DEFAULT_VALUE, // default value: normal
        @JvmField val preloadRequired: Expression<Boolean> = PRELOAD_REQUIRED_DEFAULT_VALUE, // default value: false
        @JvmField val start: Expression<Long>, // constraint: number >= 0
        @JvmField val tintColor: Expression<Int>? = null,
        @JvmField val tintMode: Expression<DivBlendMode> = TINT_MODE_DEFAULT_VALUE, // default value: source_in
        @JvmField val url: Expression<Uri>,
        @JvmField val width: DivFixedSize = WIDTH_DEFAULT_VALUE, // default value: DivFixedSize(value = Expression.constant(20L))
    ) : JSONSerializable, Hashable {

        private var _hash: Int? = null 

        override fun hash(): Int {
            _hash?.let {
                return it
            }
            val hash = 
                this::class.hashCode() +
                (accessibility?.hash() ?: 0) +
                alignmentVertical.hashCode() +
                height.hash() +
                indexingDirection.hashCode() +
                preloadRequired.hashCode() +
                start.hashCode() +
                (tintColor?.hashCode() ?: 0) +
                tintMode.hashCode() +
                url.hashCode() +
                width.hash()
            _hash = hash
            return hash
        }

        fun equals(other: Image?, resolver: ExpressionResolver, otherResolver: ExpressionResolver): Boolean {
            other ?: return false
            return (accessibility?.equals(other.accessibility, resolver, otherResolver) ?: (other.accessibility == null)) &&
                alignmentVertical.evaluate(resolver) == other.alignmentVertical.evaluate(otherResolver) &&
                height.equals(other.height, resolver, otherResolver) &&
                indexingDirection.evaluate(resolver) == other.indexingDirection.evaluate(otherResolver) &&
                preloadRequired.evaluate(resolver) == other.preloadRequired.evaluate(otherResolver) &&
                start.evaluate(resolver) == other.start.evaluate(otherResolver) &&
                tintColor?.evaluate(resolver) == other.tintColor?.evaluate(otherResolver) &&
                tintMode.evaluate(resolver) == other.tintMode.evaluate(otherResolver) &&
                url.evaluate(resolver) == other.url.evaluate(otherResolver) &&
                width.equals(other.width, resolver, otherResolver)
        }

        fun copy(
            accessibility: Accessibility? = this.accessibility,
            alignmentVertical: Expression<DivTextAlignmentVertical> = this.alignmentVertical,
            height: DivFixedSize = this.height,
            indexingDirection: Expression<IndexingDirection> = this.indexingDirection,
            preloadRequired: Expression<Boolean> = this.preloadRequired,
            start: Expression<Long> = this.start,
            tintColor: Expression<Int>? = this.tintColor,
            tintMode: Expression<DivBlendMode> = this.tintMode,
            url: Expression<Uri> = this.url,
            width: DivFixedSize = this.width,
        ) = Image(
            accessibility = accessibility,
            alignmentVertical = alignmentVertical,
            height = height,
            indexingDirection = indexingDirection,
            preloadRequired = preloadRequired,
            start = start,
            tintColor = tintColor,
            tintMode = tintMode,
            url = url,
            width = width,
        )

        override fun writeToJSON(): JSONObject {
            return builtInParserComponent.divTextImageJsonEntityParser
                .value
                .serialize(context = builtInParsingContext, value = this)
        }

        companion object {
            private val ALIGNMENT_VERTICAL_DEFAULT_VALUE = Expression.constant(DivTextAlignmentVertical.CENTER)
            private val HEIGHT_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(20L))
            private val INDEXING_DIRECTION_DEFAULT_VALUE = Expression.constant(IndexingDirection.NORMAL)
            private val PRELOAD_REQUIRED_DEFAULT_VALUE = Expression.constant(false)
            private val TINT_MODE_DEFAULT_VALUE = Expression.constant(DivBlendMode.SOURCE_IN)
            private val WIDTH_DEFAULT_VALUE = DivFixedSize(value = Expression.constant(20L))

            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Image {
                return builtInParserComponent.divTextImageJsonEntityParser
                    .value
                    .deserialize(context = env, data = json)
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Image(env, json = it) }
        }

        class Accessibility @DivModelInternalApi constructor (
            @JvmField val description: Expression<String>? = null,
            @JvmField val type: Type = TYPE_DEFAULT_VALUE, // default value: auto
        ) : JSONSerializable, Hashable {

            private var _hash: Int? = null 

            override fun hash(): Int {
                _hash?.let {
                    return it
                }
                val hash = 
                    this::class.hashCode() +
                    (description?.hashCode() ?: 0) +
                    type.hashCode()
                _hash = hash
                return hash
            }

            fun equals(other: Accessibility?, resolver: ExpressionResolver, otherResolver: ExpressionResolver): Boolean {
                other ?: return false
                return description?.evaluate(resolver) == other.description?.evaluate(otherResolver) &&
                    type == other.type
            }

            fun copy(
                description: Expression<String>? = this.description,
                type: Type = this.type,
            ) = Accessibility(
                description = description,
                type = type,
            )

            override fun writeToJSON(): JSONObject {
                return builtInParserComponent.divTextImageAccessibilityJsonEntityParser
                    .value
                    .serialize(context = builtInParsingContext, value = this)
            }

            companion object {
                private val TYPE_DEFAULT_VALUE = Type.AUTO

                @JvmStatic
                @JvmName("fromJson")
                operator fun invoke(env: ParsingEnvironment, json: JSONObject): Accessibility {
                    return builtInParserComponent.divTextImageAccessibilityJsonEntityParser
                        .value
                        .deserialize(context = env, data = json)
                }

                val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Accessibility(env, json = it) }
            }

            enum class Type(private val value: String) {
                NONE("none"),
                BUTTON("button"),
                IMAGE("image"),
                TEXT("text"),
                AUTO("auto");

                companion object Converter {

                    fun toString(obj: Type): String {
                        return obj.value
                    }

                    fun fromString(value: String): Type? {
                        return when (value) {
                            NONE.value -> NONE
                            BUTTON.value -> BUTTON
                            IMAGE.value -> IMAGE
                            TEXT.value -> TEXT
                            AUTO.value -> AUTO
                            else -> null
                        }
                    }

                    @JvmField
                    val TO_STRING = { value: Type -> toString(value) }

                    @JvmField
                    val FROM_STRING = { value: String -> fromString(value) }
                }
            }
        }

        enum class IndexingDirection(private val value: String) {
            NORMAL("normal"),
            REVERSED("reversed");

            companion object Converter {

                fun toString(obj: IndexingDirection): String {
                    return obj.value
                }

                fun fromString(value: String): IndexingDirection? {
                    return when (value) {
                        NORMAL.value -> NORMAL
                        REVERSED.value -> REVERSED
                        else -> null
                    }
                }

                @JvmField
                val TO_STRING = { value: IndexingDirection -> toString(value) }

                @JvmField
                val FROM_STRING = { value: String -> fromString(value) }
            }
        }
    }

    class Ellipsis @DivModelInternalApi constructor (
        @JvmField val actions: List<DivAction>? = null,
        @JvmField val images: List<Image>? = null,
        @JvmField val ranges: List<Range>? = null,
        @JvmField val text: Expression<String>,
    ) : JSONSerializable, Hashable {

        private var _hash: Int? = null 

        override fun hash(): Int {
            _hash?.let {
                return it
            }
            val hash = 
                this::class.hashCode() +
                (actions?.sumOf { it.hash() } ?: 0) +
                (images?.sumOf { it.hash() } ?: 0) +
                (ranges?.sumOf { it.hash() } ?: 0) +
                text.hashCode()
            _hash = hash
            return hash
        }

        fun equals(other: Ellipsis?, resolver: ExpressionResolver, otherResolver: ExpressionResolver): Boolean {
            other ?: return false
            return (actions?.compareWith(other.actions ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.actions == null)) &&
                (images?.compareWith(other.images ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.images == null)) &&
                (ranges?.compareWith(other.ranges ?: return false) { a, b -> a.equals(b, resolver, otherResolver) } ?: (other.ranges == null)) &&
                text.evaluate(resolver) == other.text.evaluate(otherResolver)
        }

        fun copy(
            actions: List<DivAction>? = this.actions,
            images: List<Image>? = this.images,
            ranges: List<Range>? = this.ranges,
            text: Expression<String> = this.text,
        ) = Ellipsis(
            actions = actions,
            images = images,
            ranges = ranges,
            text = text,
        )

        override fun writeToJSON(): JSONObject {
            return builtInParserComponent.divTextEllipsisJsonEntityParser
                .value
                .serialize(context = builtInParsingContext, value = this)
        }

        companion object {
            @JvmStatic
            @JvmName("fromJson")
            operator fun invoke(env: ParsingEnvironment, json: JSONObject): Ellipsis {
                return builtInParserComponent.divTextEllipsisJsonEntityParser
                    .value
                    .deserialize(context = env, data = json)
            }

            val CREATOR = { env: ParsingEnvironment, it: JSONObject -> Ellipsis(env, json = it) }
        }
    }

    enum class Truncate(private val value: String) {
        NONE("none"),
        START("start"),
        END("end"),
        MIDDLE("middle");

        companion object Converter {

            fun toString(obj: Truncate): String {
                return obj.value
            }

            fun fromString(value: String): Truncate? {
                return when (value) {
                    NONE.value -> NONE
                    START.value -> START
                    END.value -> END
                    MIDDLE.value -> MIDDLE
                    else -> null
                }
            }

            @JvmField
            val TO_STRING = { value: Truncate -> toString(value) }

            @JvmField
            val FROM_STRING = { value: String -> fromString(value) }
        }
    }
}
