// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivTranslationJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivTranslation> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivTranslation {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                DivFixedTranslation.TYPE -> return DivTranslation.Fixed(component.divFixedTranslationJsonEntityParser.value.deserialize(context, data))
                DivPercentageTranslation.TYPE -> return DivTranslation.Percentage(component.divPercentageTranslationJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivTranslationTemplate
            if (template != null) {
                return component.divTranslationJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTranslation): JSONObject {
            return when (value) {
                is DivTranslation.Fixed -> component.divFixedTranslationJsonEntityParser.value.serialize(context, value.value)
                is DivTranslation.Percentage -> component.divPercentageTranslationJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivTranslationTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivTranslationTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivTranslationTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivFixedTranslationTemplate.TYPE -> return DivTranslationTemplate.Fixed(component.divFixedTranslationJsonTemplateParser.value.deserialize(context, parent?.value() as DivFixedTranslationTemplate?, data))
                DivPercentageTranslationTemplate.TYPE -> return DivTranslationTemplate.Percentage(component.divPercentageTranslationJsonTemplateParser.value.deserialize(context, parent?.value() as DivPercentageTranslationTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivTranslationTemplate): JSONObject {
            return when (value) {
                is DivTranslationTemplate.Fixed -> component.divFixedTranslationJsonTemplateParser.value.serialize(context, value.value)
                is DivTranslationTemplate.Percentage -> component.divPercentageTranslationJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivTranslationTemplate, DivTranslation> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivTranslationTemplate, data: JSONObject): DivTranslation {
            return when (template) {
                is DivTranslationTemplate.Fixed -> DivTranslation.Fixed(component.divFixedTranslationJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivTranslationTemplate.Percentage -> DivTranslation.Percentage(component.divPercentageTranslationJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
