// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivVariableJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivVariable> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivVariable {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                StrVariable.TYPE -> return DivVariable.Str(component.strVariableJsonEntityParser.value.deserialize(context, data))
                NumberVariable.TYPE -> return DivVariable.Number(component.numberVariableJsonEntityParser.value.deserialize(context, data))
                IntegerVariable.TYPE -> return DivVariable.Integer(component.integerVariableJsonEntityParser.value.deserialize(context, data))
                BoolVariable.TYPE -> return DivVariable.Bool(component.boolVariableJsonEntityParser.value.deserialize(context, data))
                ColorVariable.TYPE -> return DivVariable.Color(component.colorVariableJsonEntityParser.value.deserialize(context, data))
                UrlVariable.TYPE -> return DivVariable.Url(component.urlVariableJsonEntityParser.value.deserialize(context, data))
                DictVariable.TYPE -> return DivVariable.Dict(component.dictVariableJsonEntityParser.value.deserialize(context, data))
                ArrayVariable.TYPE -> return DivVariable.Array(component.arrayVariableJsonEntityParser.value.deserialize(context, data))
                PropertyVariable.TYPE -> return DivVariable.Property(component.propertyVariableJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivVariableTemplate
            if (template != null) {
                return component.divVariableJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivVariable): JSONObject {
            return when (value) {
                is DivVariable.Str -> component.strVariableJsonEntityParser.value.serialize(context, value.value)
                is DivVariable.Number -> component.numberVariableJsonEntityParser.value.serialize(context, value.value)
                is DivVariable.Integer -> component.integerVariableJsonEntityParser.value.serialize(context, value.value)
                is DivVariable.Bool -> component.boolVariableJsonEntityParser.value.serialize(context, value.value)
                is DivVariable.Color -> component.colorVariableJsonEntityParser.value.serialize(context, value.value)
                is DivVariable.Url -> component.urlVariableJsonEntityParser.value.serialize(context, value.value)
                is DivVariable.Dict -> component.dictVariableJsonEntityParser.value.serialize(context, value.value)
                is DivVariable.Array -> component.arrayVariableJsonEntityParser.value.serialize(context, value.value)
                is DivVariable.Property -> component.propertyVariableJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivVariableTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivVariableTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivVariableTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                StrVariableTemplate.TYPE -> return DivVariableTemplate.Str(component.strVariableJsonTemplateParser.value.deserialize(context, parent?.value() as StrVariableTemplate?, data))
                NumberVariableTemplate.TYPE -> return DivVariableTemplate.Number(component.numberVariableJsonTemplateParser.value.deserialize(context, parent?.value() as NumberVariableTemplate?, data))
                IntegerVariableTemplate.TYPE -> return DivVariableTemplate.Integer(component.integerVariableJsonTemplateParser.value.deserialize(context, parent?.value() as IntegerVariableTemplate?, data))
                BoolVariableTemplate.TYPE -> return DivVariableTemplate.Bool(component.boolVariableJsonTemplateParser.value.deserialize(context, parent?.value() as BoolVariableTemplate?, data))
                ColorVariableTemplate.TYPE -> return DivVariableTemplate.Color(component.colorVariableJsonTemplateParser.value.deserialize(context, parent?.value() as ColorVariableTemplate?, data))
                UrlVariableTemplate.TYPE -> return DivVariableTemplate.Url(component.urlVariableJsonTemplateParser.value.deserialize(context, parent?.value() as UrlVariableTemplate?, data))
                DictVariableTemplate.TYPE -> return DivVariableTemplate.Dict(component.dictVariableJsonTemplateParser.value.deserialize(context, parent?.value() as DictVariableTemplate?, data))
                ArrayVariableTemplate.TYPE -> return DivVariableTemplate.Array(component.arrayVariableJsonTemplateParser.value.deserialize(context, parent?.value() as ArrayVariableTemplate?, data))
                PropertyVariableTemplate.TYPE -> return DivVariableTemplate.Property(component.propertyVariableJsonTemplateParser.value.deserialize(context, parent?.value() as PropertyVariableTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivVariableTemplate): JSONObject {
            return when (value) {
                is DivVariableTemplate.Str -> component.strVariableJsonTemplateParser.value.serialize(context, value.value)
                is DivVariableTemplate.Number -> component.numberVariableJsonTemplateParser.value.serialize(context, value.value)
                is DivVariableTemplate.Integer -> component.integerVariableJsonTemplateParser.value.serialize(context, value.value)
                is DivVariableTemplate.Bool -> component.boolVariableJsonTemplateParser.value.serialize(context, value.value)
                is DivVariableTemplate.Color -> component.colorVariableJsonTemplateParser.value.serialize(context, value.value)
                is DivVariableTemplate.Url -> component.urlVariableJsonTemplateParser.value.serialize(context, value.value)
                is DivVariableTemplate.Dict -> component.dictVariableJsonTemplateParser.value.serialize(context, value.value)
                is DivVariableTemplate.Array -> component.arrayVariableJsonTemplateParser.value.serialize(context, value.value)
                is DivVariableTemplate.Property -> component.propertyVariableJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivVariableTemplate, DivVariable> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivVariableTemplate, data: JSONObject): DivVariable {
            return when (template) {
                is DivVariableTemplate.Str -> DivVariable.Str(component.strVariableJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivVariableTemplate.Number -> DivVariable.Number(component.numberVariableJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivVariableTemplate.Integer -> DivVariable.Integer(component.integerVariableJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivVariableTemplate.Bool -> DivVariable.Bool(component.boolVariableJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivVariableTemplate.Color -> DivVariable.Color(component.colorVariableJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivVariableTemplate.Url -> DivVariable.Url(component.urlVariableJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivVariableTemplate.Dict -> DivVariable.Dict(component.dictVariableJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivVariableTemplate.Array -> DivVariable.Array(component.arrayVariableJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivVariableTemplate.Property -> DivVariable.Property(component.propertyVariableJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
