// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivSizeJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivSize> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivSize {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                DivFixedSize.TYPE -> return DivSize.Fixed(component.divFixedSizeJsonEntityParser.value.deserialize(context, data))
                DivMatchParentSize.TYPE -> return DivSize.MatchParent(component.divMatchParentSizeJsonEntityParser.value.deserialize(context, data))
                DivWrapContentSize.TYPE -> return DivSize.WrapContent(component.divWrapContentSizeJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivSizeTemplate
            if (template != null) {
                return component.divSizeJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivSize): JSONObject {
            return when (value) {
                is DivSize.Fixed -> component.divFixedSizeJsonEntityParser.value.serialize(context, value.value)
                is DivSize.MatchParent -> component.divMatchParentSizeJsonEntityParser.value.serialize(context, value.value)
                is DivSize.WrapContent -> component.divWrapContentSizeJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivSizeTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivSizeTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivSizeTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivFixedSizeTemplate.TYPE -> return DivSizeTemplate.Fixed(component.divFixedSizeJsonTemplateParser.value.deserialize(context, parent?.value() as DivFixedSizeTemplate?, data))
                DivMatchParentSizeTemplate.TYPE -> return DivSizeTemplate.MatchParent(component.divMatchParentSizeJsonTemplateParser.value.deserialize(context, parent?.value() as DivMatchParentSizeTemplate?, data))
                DivWrapContentSizeTemplate.TYPE -> return DivSizeTemplate.WrapContent(component.divWrapContentSizeJsonTemplateParser.value.deserialize(context, parent?.value() as DivWrapContentSizeTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivSizeTemplate): JSONObject {
            return when (value) {
                is DivSizeTemplate.Fixed -> component.divFixedSizeJsonTemplateParser.value.serialize(context, value.value)
                is DivSizeTemplate.MatchParent -> component.divMatchParentSizeJsonTemplateParser.value.serialize(context, value.value)
                is DivSizeTemplate.WrapContent -> component.divWrapContentSizeJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivSizeTemplate, DivSize> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivSizeTemplate, data: JSONObject): DivSize {
            return when (template) {
                is DivSizeTemplate.Fixed -> DivSize.Fixed(component.divFixedSizeJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivSizeTemplate.MatchParent -> DivSize.MatchParent(component.divMatchParentSizeJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivSizeTemplate.WrapContent -> DivSize.WrapContent(component.divWrapContentSizeJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
