// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivBackgroundJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivBackground> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivBackground {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                DivLinearGradient.TYPE -> return DivBackground.LinearGradient(component.divLinearGradientJsonEntityParser.value.deserialize(context, data))
                DivRadialGradient.TYPE -> return DivBackground.RadialGradient(component.divRadialGradientJsonEntityParser.value.deserialize(context, data))
                DivImageBackground.TYPE -> return DivBackground.Image(component.divImageBackgroundJsonEntityParser.value.deserialize(context, data))
                DivSolidBackground.TYPE -> return DivBackground.Solid(component.divSolidBackgroundJsonEntityParser.value.deserialize(context, data))
                DivNinePatchBackground.TYPE -> return DivBackground.NinePatch(component.divNinePatchBackgroundJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivBackgroundTemplate
            if (template != null) {
                return component.divBackgroundJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivBackground): JSONObject {
            return when (value) {
                is DivBackground.LinearGradient -> component.divLinearGradientJsonEntityParser.value.serialize(context, value.value)
                is DivBackground.RadialGradient -> component.divRadialGradientJsonEntityParser.value.serialize(context, value.value)
                is DivBackground.Image -> component.divImageBackgroundJsonEntityParser.value.serialize(context, value.value)
                is DivBackground.Solid -> component.divSolidBackgroundJsonEntityParser.value.serialize(context, value.value)
                is DivBackground.NinePatch -> component.divNinePatchBackgroundJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivBackgroundTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivBackgroundTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivBackgroundTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivLinearGradientTemplate.TYPE -> return DivBackgroundTemplate.LinearGradient(component.divLinearGradientJsonTemplateParser.value.deserialize(context, parent?.value() as DivLinearGradientTemplate?, data))
                DivRadialGradientTemplate.TYPE -> return DivBackgroundTemplate.RadialGradient(component.divRadialGradientJsonTemplateParser.value.deserialize(context, parent?.value() as DivRadialGradientTemplate?, data))
                DivImageBackgroundTemplate.TYPE -> return DivBackgroundTemplate.Image(component.divImageBackgroundJsonTemplateParser.value.deserialize(context, parent?.value() as DivImageBackgroundTemplate?, data))
                DivSolidBackgroundTemplate.TYPE -> return DivBackgroundTemplate.Solid(component.divSolidBackgroundJsonTemplateParser.value.deserialize(context, parent?.value() as DivSolidBackgroundTemplate?, data))
                DivNinePatchBackgroundTemplate.TYPE -> return DivBackgroundTemplate.NinePatch(component.divNinePatchBackgroundJsonTemplateParser.value.deserialize(context, parent?.value() as DivNinePatchBackgroundTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivBackgroundTemplate): JSONObject {
            return when (value) {
                is DivBackgroundTemplate.LinearGradient -> component.divLinearGradientJsonTemplateParser.value.serialize(context, value.value)
                is DivBackgroundTemplate.RadialGradient -> component.divRadialGradientJsonTemplateParser.value.serialize(context, value.value)
                is DivBackgroundTemplate.Image -> component.divImageBackgroundJsonTemplateParser.value.serialize(context, value.value)
                is DivBackgroundTemplate.Solid -> component.divSolidBackgroundJsonTemplateParser.value.serialize(context, value.value)
                is DivBackgroundTemplate.NinePatch -> component.divNinePatchBackgroundJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivBackgroundTemplate, DivBackground> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivBackgroundTemplate, data: JSONObject): DivBackground {
            return when (template) {
                is DivBackgroundTemplate.LinearGradient -> DivBackground.LinearGradient(component.divLinearGradientJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivBackgroundTemplate.RadialGradient -> DivBackground.RadialGradient(component.divRadialGradientJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivBackgroundTemplate.Image -> DivBackground.Image(component.divImageBackgroundJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivBackgroundTemplate.Solid -> DivBackground.Solid(component.divSolidBackgroundJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivBackgroundTemplate.NinePatch -> DivBackground.NinePatch(component.divNinePatchBackgroundJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
