// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivCountJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivCount> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivCount {
            val type: String = JsonPropertyParser.readString(context, data, "type")
            when (type) {
                DivInfinityCount.TYPE -> return DivCount.Infinity(component.divInfinityCountJsonEntityParser.value.deserialize(context, data))
                DivFixedCount.TYPE -> return DivCount.Fixed(component.divFixedCountJsonEntityParser.value.deserialize(context, data))
            }

            val template = context.templates.getOrThrow(type, data) as? DivCountTemplate
            if (template != null) {
                return component.divCountJsonTemplateResolver
                    .value
                    .resolve(context, template, data)
            } else {
                throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivCount): JSONObject {
            return when (value) {
                is DivCount.Infinity -> component.divInfinityCountJsonEntityParser.value.serialize(context, value.value)
                is DivCount.Fixed -> component.divFixedCountJsonEntityParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivCountTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivCountTemplate {
            val extendedType = JsonPropertyParser.readString(context, data, "type")
            val parent = context.templates[extendedType] as? DivCountTemplate
            val type = parent?.type ?: extendedType
            when (type) {
                DivInfinityCountTemplate.TYPE -> return DivCountTemplate.Infinity(component.divInfinityCountJsonTemplateParser.value.deserialize(context, parent?.value() as DivInfinityCountTemplate?, data))
                DivFixedCountTemplate.TYPE -> return DivCountTemplate.Fixed(component.divFixedCountJsonTemplateParser.value.deserialize(context, parent?.value() as DivFixedCountTemplate?, data))
                else -> throw typeMismatch(json = data, key = "type", value = type)
            }
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivCountTemplate): JSONObject {
            return when (value) {
                is DivCountTemplate.Infinity -> component.divInfinityCountJsonTemplateParser.value.serialize(context, value.value)
                is DivCountTemplate.Fixed -> component.divFixedCountJsonTemplateParser.value.serialize(context, value.value)
            }
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivCountTemplate, DivCount> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivCountTemplate, data: JSONObject): DivCount {
            return when (template) {
                is DivCountTemplate.Infinity -> DivCount.Infinity(component.divInfinityCountJsonTemplateResolver.value.resolve(context, template.value, data))
                is DivCountTemplate.Fixed -> DivCount.Fixed(component.divFixedCountJsonTemplateResolver.value.resolve(context, template.value, data))
            }
        }
    }
}
