// Generated code. Do not modify.

@file:Suppress("DEPRECATION", "TYPEALIAS_EXPANSION_DEPRECATION")

package com.yandex.div2

import android.graphics.Color
import android.net.Uri
import androidx.annotation.ColorInt
import com.yandex.div.data.*
import com.yandex.div.internal.parser.*
import com.yandex.div.internal.template.*
import com.yandex.div.internal.util.*
import com.yandex.div.json.*
import com.yandex.div.json.expressions.*
import com.yandex.div.serialization.*
import org.json.JSONArray
import org.json.JSONObject

internal class DivStrokeJsonParser(
    private val component: JsonParserComponent
) {

    class EntityParserImpl(
        private val component: JsonParserComponent
    ) : Parser<JSONObject, DivStroke> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, data: JSONObject): DivStroke {
            return DivStroke(
                color = JsonExpressionParser.readExpression(context, data, "color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                style = JsonPropertyParser.readOptional(context, data, "style", component.divStrokeStyleJsonEntityParser) ?: STYLE_DEFAULT_VALUE,
                unit = JsonExpressionParser.readOptionalExpression(context, data, "unit", TYPE_HELPER_UNIT, DivSizeUnit.FROM_STRING, UNIT_DEFAULT_VALUE) ?: UNIT_DEFAULT_VALUE,
                width = JsonExpressionParser.readOptionalExpression(context, data, "width", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, WIDTH_VALIDATOR, WIDTH_DEFAULT_VALUE) ?: WIDTH_DEFAULT_VALUE,
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivStroke): JSONObject {
            val data = JSONObject()
            JsonExpressionParser.writeExpression(context, data, "color", value.color, COLOR_INT_TO_STRING)
            JsonPropertyParser.write(context, data, "style", value.style, component.divStrokeStyleJsonEntityParser)
            JsonExpressionParser.writeExpression(context, data, "unit", value.unit, DivSizeUnit.TO_STRING)
            JsonExpressionParser.writeExpression(context, data, "width", value.width)
            return data
        }
    }

    class TemplateParserImpl(
        private val component: JsonParserComponent
    ) : TemplateParser<JSONObject, DivStrokeTemplate> {

        @Throws(ParsingException::class)
        override fun deserialize(context: ParsingContext, parent: DivStrokeTemplate?, data: JSONObject): DivStrokeTemplate {
            val allowOverride = context.allowPropertyOverride
            @Suppress("NAME_SHADOWING") val context = context.restrictPropertyOverride()
            return DivStrokeTemplate(
                color = JsonFieldParser.readFieldWithExpression(context, data, "color", TYPE_HELPER_COLOR, allowOverride, parent?.color, STRING_TO_COLOR_INT),
                style = JsonFieldParser.readOptionalField(context, data, "style", allowOverride, parent?.style, component.divStrokeStyleJsonTemplateParser),
                unit = JsonFieldParser.readOptionalFieldWithExpression(context, data, "unit", TYPE_HELPER_UNIT, allowOverride, parent?.unit, DivSizeUnit.FROM_STRING),
                width = JsonFieldParser.readOptionalFieldWithExpression(context, data, "width", TYPE_HELPER_DOUBLE, allowOverride, parent?.width, NUMBER_TO_DOUBLE, WIDTH_VALIDATOR),
            )
        }

        @Throws(ParsingException::class)
        override fun serialize(context: ParsingContext, value: DivStrokeTemplate): JSONObject {
            val data = JSONObject()
            JsonFieldParser.writeExpressionField(context, data, "color", value.color, COLOR_INT_TO_STRING)
            JsonFieldParser.writeField(context, data, "style", value.style, component.divStrokeStyleJsonTemplateParser)
            JsonFieldParser.writeExpressionField(context, data, "unit", value.unit, DivSizeUnit.TO_STRING)
            JsonFieldParser.writeExpressionField(context, data, "width", value.width)
          return data
        }
    }

    class TemplateResolverImpl(
        private val component: JsonParserComponent
    ) : TemplateResolver<JSONObject, DivStrokeTemplate, DivStroke> {

        @Throws(ParsingException::class)
        override fun resolve(context: ParsingContext, template: DivStrokeTemplate, data: JSONObject): DivStroke {
            return DivStroke(
                color = JsonFieldResolver.resolveExpression(context, template.color, data, "color", TYPE_HELPER_COLOR, STRING_TO_COLOR_INT),
                style = JsonFieldResolver.resolveOptional(context, template.style, data, "style", component.divStrokeStyleJsonTemplateResolver, component.divStrokeStyleJsonEntityParser) ?: STYLE_DEFAULT_VALUE,
                unit = JsonFieldResolver.resolveOptionalExpression(context, template.unit, data, "unit", TYPE_HELPER_UNIT, DivSizeUnit.FROM_STRING, UNIT_DEFAULT_VALUE) ?: UNIT_DEFAULT_VALUE,
                width = JsonFieldResolver.resolveOptionalExpression(context, template.width, data, "width", TYPE_HELPER_DOUBLE, NUMBER_TO_DOUBLE, WIDTH_VALIDATOR, WIDTH_DEFAULT_VALUE) ?: WIDTH_DEFAULT_VALUE,
            )
        }
    }

    private companion object {

        @JvmField val STYLE_DEFAULT_VALUE = DivStrokeStyle.Solid(DivStrokeStyleSolid())
        @JvmField val UNIT_DEFAULT_VALUE = Expression.constant(DivSizeUnit.DP)
        @JvmField val WIDTH_DEFAULT_VALUE = Expression.constant(1.0)

        @JvmField val TYPE_HELPER_UNIT = TypeHelper.from(default = DivSizeUnit.DP) { it is DivSizeUnit }

        @JvmField val WIDTH_VALIDATOR = ValueValidator<Double> { it: Double -> it >= 0 }
    }
}
